/*
 * Decompiled with CFR 0.152.
 */
package com.epson.epsonio.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.epson.epsonio.EpsonIoException;

public class AdapterHandler
extends Handler {
    private BluetoothAdapter mAdapter = null;
    private boolean mDoLoop = true;
    private Object mSynchronizeFlag = new Object();
    private static Context mContext = null;

    public AdapterHandler() {
        super(Looper.getMainLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BluetoothAdapter getAdapter(Context context) throws EpsonIoException {
        Object object = this.mSynchronizeFlag;
        synchronized (object) {
            Message msg = this.obtainMessage(0);
            if (!this.sendMessage(msg)) {
                throw new EpsonIoException(255);
            }
            mContext = context;
            while (this.mDoLoop) {
                try {
                    this.mSynchronizeFlag.wait();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception e) {
                    EpsonIoException ioe = new EpsonIoException(null, e);
                    ioe.setStatus(255);
                    throw ioe;
                }
            }
        }
        return this.mAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(Message msg) {
        if (msg.what == 0) {
            BluetoothManager bluetoothManager;
            this.mAdapter = mContext != null && Build.VERSION.SDK_INT >= 18 ? ((bluetoothManager = (BluetoothManager)mContext.getSystemService("bluetooth")) == null ? null : bluetoothManager.getAdapter()) : BluetoothAdapter.getDefaultAdapter();
            Object object = this.mSynchronizeFlag;
            synchronized (object) {
                this.mDoLoop = false;
                this.mSynchronizeFlag.notify();
            }
        }
    }
}

