/*
 * Decompiled with CFR 0.152.
 */
package com.epson.epsonio.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.epson.epsonio.DeviceInfo;
import com.epson.epsonio.EpsonIoException;
import com.epson.epsonio.Finder;
import com.epson.epsonio.bluetooth.AdapterHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Set;

public class DevBt {
    private static ArrayList<DeviceInfo> mDeviceInfoList = new ArrayList();
    private static BluetoothAdapter mAdapter = null;
    private static BroadcastReceiver mReceiver = null;
    private static Context mContext = null;
    private static boolean mIsFinding = false;
    private static final int MBT_DEV_SUB_CLASS_PRINTER = 128;
    private static final int MBT_DEV_SUB_CLASS_PRINTER_MASK = 128;
    private static Integer unregisterReceiverSynchronizer = 0;
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    protected static Class<?> mClassOutputLog = null;
    protected static Method mOutputLogInfoMethod = null;
    private static final Handler unregisterReceiverCallbackHandler;

    protected static void initializeOuputLogFunctions() {
        try {
            mClassOutputLog = Class.forName("com.epson.epos2.OutputLog");
            mOutputLogInfoMethod = mClassOutputLog.getDeclaredMethod("outputLogInfo", Long.TYPE, Object[].class);
            mOutputLogInfoMethod.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static void outputLogInfo(Object ... param) {
        try {
            mOutputLogInfoMethod.invoke(mClassOutputLog, 0, param);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int start(Context caller, int deviceType, String deviceName, int bondedDevices) {
        if (mIsFinding) {
            DevBt.outputLogInfo(new Object[0]);
            return 6;
        }
        if (258 != deviceType) {
            DevBt.outputLogInfo(new Object[0]);
            return 1;
        }
        if (null != deviceName) {
            DevBt.outputLogInfo(new Object[0]);
            return 1;
        }
        if (bondedDevices != 1 && bondedDevices != 0) {
            DevBt.outputLogInfo(new Object[0]);
            return 1;
        }
        if (null == caller) {
            DevBt.outputLogInfo(new Object[0]);
            return 1;
        }
        ArrayList<DeviceInfo> arrayList = mDeviceInfoList;
        synchronized (arrayList) {
            mDeviceInfoList.clear();
        }
        mContext = caller;
        if (null == mAdapter) {
            AdapterHandler mHandler = new AdapterHandler();
            if (mHandler.getLooper().getThread().getId() != Thread.currentThread().getId()) {
                try {
                    mAdapter = mHandler.getAdapter(mContext);
                }
                catch (EpsonIoException e) {
                    DevBt.outputLogInfo(e);
                    return e.getStatus();
                }
            } else if (Build.VERSION.SDK_INT >= 18) {
                BluetoothManager bluetoothManager = (BluetoothManager)mContext.getSystemService("bluetooth");
                if (bluetoothManager == null) {
                    DevBt.outputLogInfo(new Object[0]);
                    return 255;
                }
                mAdapter = bluetoothManager.getAdapter();
            } else {
                mAdapter = BluetoothAdapter.getDefaultAdapter();
            }
        }
        if (null == mAdapter) {
            DevBt.outputLogInfo(new Object[0]);
            return 255;
        }
        try {
            if (!mAdapter.isEnabled()) {
                DevBt.outputLogInfo("Bluetooth Setting OFF");
                mAdapter = null;
                return 6;
            }
        }
        catch (Exception e) {
            DevBt.outputLogInfo(e);
            mAdapter = null;
            return 6;
        }
        if (bondedDevices == 1) {
            Set pairedDevices = null;
            try {
                pairedDevices = mAdapter.getBondedDevices();
            }
            catch (Exception e) {
                DevBt.outputLogInfo(e);
                mAdapter = null;
                return 6;
            }
            if (pairedDevices != null && pairedDevices.size() > 0) {
                for (BluetoothDevice device : pairedDevices) {
                    try {
                        String printerName = device.getName();
                        if (printerName == null) {
                            printerName = "";
                        }
                        DeviceInfo deviceInfo = new DeviceInfo(258, printerName, device.getAddress(), "", "");
                        mDeviceInfoList.add(deviceInfo);
                    }
                    catch (Exception e) {
                        DevBt.outputLogInfo(e);
                    }
                }
            }
        }
        mReceiver = new BroadcastReceiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if ("android.bluetooth.device.action.FOUND".equals(action)) {
                    BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                    if (null != device) {
                        int majorClass;
                        BluetoothClass bluetoothClass = null;
                        try {
                            bluetoothClass = device.getBluetoothClass();
                        }
                        catch (Exception e) {
                            DevBt.outputLogInfo(e);
                            return;
                        }
                        if (null != bluetoothClass && (7936 == (majorClass = bluetoothClass.getMajorDeviceClass()) || 1536 == majorClass && 128 == (0x80 & bluetoothClass.getDeviceClass()))) {
                            ArrayList arrayList = mDeviceInfoList;
                            synchronized (arrayList) {
                                Boolean bFind = false;
                                for (DeviceInfo devInfo : mDeviceInfoList) {
                                    String work = devInfo.getDeviceName();
                                    if (!work.equalsIgnoreCase(device.getAddress())) continue;
                                    bFind = true;
                                    break;
                                }
                                if (!bFind.booleanValue()) {
                                    String printerName = null;
                                    try {
                                        printerName = device.getName();
                                    }
                                    catch (Exception e) {
                                        DevBt.outputLogInfo(e);
                                        return;
                                    }
                                    if (printerName == null) {
                                        printerName = "";
                                    }
                                    DeviceInfo deviceInfo = new DeviceInfo(258, printerName, device.getAddress(), "", "");
                                    mDeviceInfoList.add(deviceInfo);
                                }
                            }
                        }
                    }
                } else if ("android.bluetooth.adapter.action.DISCOVERY_FINISHED".equals(action)) {
                    try {
                        mAdapter.startDiscovery();
                    }
                    catch (Exception e) {
                        DevBt.outputLogInfo(e);
                    }
                }
            }
        };
        IntentFilter filter = new IntentFilter("android.bluetooth.device.action.FOUND");
        filter.addAction("android.bluetooth.adapter.action.DISCOVERY_FINISHED");
        mContext.registerReceiver(mReceiver, filter);
        try {
            if (!mAdapter.startDiscovery()) {
                DevBt.outputLogInfo("Permission DENIED. or GPS Setting OFF.");
                if (bondedDevices == 1) {
                    mIsFinding = true;
                    return 0;
                }
                mContext.unregisterReceiver(mReceiver);
                mReceiver = null;
                mAdapter = null;
                return 6;
            }
        }
        catch (Exception e) {
            DevBt.outputLogInfo(e);
            mContext.unregisterReceiver(mReceiver);
            mReceiver = null;
            mAdapter = null;
            return 6;
        }
        mIsFinding = true;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final DeviceInfo[] getResult(int[] errStatus, int filterOption) {
        DeviceInfo[] deviceInfoList = null;
        if (null == errStatus || 0 == errStatus.length) {
            DevBt.outputLogInfo(new Object[0]);
            return null;
        }
        errStatus[0] = 255;
        if (!mIsFinding) {
            errStatus[0] = 6;
            DevBt.outputLogInfo(new Object[0]);
            return null;
        }
        try {
            ArrayList<DeviceInfo> arrayList = mDeviceInfoList;
            synchronized (arrayList) {
                if (0 < mDeviceInfoList.size()) {
                    DeviceInfo devInfo = null;
                    ArrayList<DeviceInfo> tmpDevInfo = new ArrayList<DeviceInfo>();
                    for (int i = 0; i < mDeviceInfoList.size(); ++i) {
                        boolean setFlg = false;
                        devInfo = mDeviceInfoList.get(i);
                        switch (filterOption) {
                            case -2: 
                            case 1: {
                                if (!Finder.isEpson(devInfo.getPrinterName())) break;
                                setFlg = true;
                                break;
                            }
                            default: {
                                setFlg = true;
                            }
                        }
                        if (!setFlg) continue;
                        DeviceInfo deviceInfo = new DeviceInfo(devInfo.getDeviceType(), devInfo.getPrinterName(), devInfo.getDeviceName(), "", "");
                        tmpDevInfo.add(deviceInfo);
                    }
                    deviceInfoList = tmpDevInfo.toArray(new DeviceInfo[tmpDevInfo.size()]);
                }
            }
            errStatus[0] = 0;
        }
        catch (Exception e) {
            DevBt.outputLogInfo(e);
            errStatus[0] = 5;
        }
        return deviceInfoList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int stop() {
        if (!mIsFinding) {
            DevBt.outputLogInfo(new Object[0]);
            return 6;
        }
        mIsFinding = false;
        if (null != mReceiver) {
            if (unregisterReceiverCallbackHandler.getLooper().getThread().getId() != Thread.currentThread().getId()) {
                Integer n = unregisterReceiverSynchronizer;
                synchronized (n) {
                    Message msg = unregisterReceiverCallbackHandler.obtainMessage(0);
                    unregisterReceiverCallbackHandler.sendMessage(msg);
                    try {
                        unregisterReceiverSynchronizer.wait();
                    }
                    catch (Exception e) {
                        DevBt.outputLogInfo(e);
                    }
                }
            }
            mContext.unregisterReceiver(mReceiver);
        }
        try {
            if (null != mAdapter && mAdapter.isDiscovering()) {
                mAdapter.cancelDiscovery();
            }
        }
        catch (Exception e) {
            DevBt.outputLogInfo(e);
            mReceiver = null;
            mAdapter = null;
            return 255;
        }
        mReceiver = null;
        mAdapter = null;
        return 0;
    }

    static {
        try {
            DevBt.initializeOuputLogFunctions();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        unregisterReceiverCallbackHandler = new Handler(Looper.getMainLooper()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleMessage(Message msg) {
                if (msg.what == 0) {
                    Integer n = unregisterReceiverSynchronizer;
                    synchronized (n) {
                        mContext.unregisterReceiver(mReceiver);
                        unregisterReceiverSynchronizer.notify();
                    }
                }
            }
        };
    }
}

