/*
 * Decompiled with CFR 0.152.
 */
package com.epson.epsonio.usb;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbAccessory;
import android.hardware.usb.UsbManager;
import android.os.ParcelFileDescriptor;
import com.epson.epsonio.usb.StreamReadThread;
import com.epson.epsonio.usb.Usb;
import java.io.FileDescriptor;
import java.io.FileOutputStream;

public class AoaUsb
extends Usb {
    private static Context mContext = null;
    private UsbManager mUsbManager = null;
    private UsbAccessory mUsbAccessory = null;
    private ParcelFileDescriptor mFileDescriptor = null;
    private final Object mLockParcelFdObj = new Object();
    private FileOutputStream mOutputStream = null;
    private StreamReadThread mStreamReadThread = null;
    protected static final int M_MAX_A0A_SENT_SIZE_AT_ONCE = 16384;
    private static final String AOA_EPSON = "EPSON";
    BroadcastReceiver mUsbReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            Usb.outputLogInfo(new Object[0]);
            String action = intent.getAction();
            if ("android.hardware.usb.action.USB_ACCESSORY_DETACHED".equals(action)) {
                try {
                    Usb.outputLogInfo(new Object[0]);
                    Object object = AoaUsb.this.mLockParcelFdObj;
                    synchronized (object) {
                        if (AoaUsb.this.mFileDescriptor != null) {
                            AoaUsb.this.mFileDescriptor.close();
                            AoaUsb.this.mFileDescriptor = null;
                        }
                    }
                }
                catch (Exception e) {
                    Usb.outputLogInfo(e);
                }
            }
        }
    };

    @Override
    public final int getUsbType() {
        return 1;
    }

    @Override
    public int setUsbInfo(String deviceName) {
        UsbAccessory[] usbAccessoryList;
        if (this.mUsbManager == null || deviceName == null) {
            AoaUsb.outputLogInfo(new Object[0]);
            return 255;
        }
        try {
            usbAccessoryList = this.mUsbManager.getAccessoryList();
        }
        catch (Exception e) {
            usbAccessoryList = null;
        }
        if (null == usbAccessoryList) {
            AoaUsb.outputLogInfo(new Object[0]);
            return 255;
        }
        int result = 255;
        for (int i = 0; i < usbAccessoryList.length; ++i) {
            try {
                String serial = usbAccessoryList[i].getSerial();
                if (null == serial) {
                    AoaUsb.outputLogInfo(new Object[0]);
                    continue;
                }
                if (!serial.equals(deviceName)) continue;
                this.mUsbAccessory = usbAccessoryList[i];
                result = 0;
                break;
            }
            catch (Exception e) {
                AoaUsb.outputLogInfo(e);
            }
        }
        return result;
    }

    @Override
    public final int requestPermission(Object context, String deviceName, int[] timeout) {
        UsbAccessory[] usbAccessoryList;
        UsbManager usbManager = (UsbManager)((Context)context).getSystemService("usb");
        if (null == usbManager) {
            AoaUsb.outputLogInfo(new Object[0]);
            return 2;
        }
        try {
            usbAccessoryList = usbManager.getAccessoryList();
        }
        catch (Exception e) {
            usbAccessoryList = null;
        }
        if (null == usbAccessoryList) {
            AoaUsb.outputLogInfo(new Object[0]);
            return 2;
        }
        UsbAccessory usbAccessory = null;
        int result = 2;
        for (int i = 0; i < usbAccessoryList.length; ++i) {
            usbAccessory = usbAccessoryList[i];
            if (null == usbAccessory) {
                AoaUsb.outputLogInfo(new Object[0]);
                continue;
            }
            if (!usbAccessory.getManufacturer().equals(AOA_EPSON)) continue;
            try {
                if (!usbManager.hasPermission(usbAccessory)) {
                    PendingIntent permissionIntent = PendingIntent.getBroadcast((Context)((Context)context), (int)0, (Intent)new Intent("com.android.eposprint.USB_PERMISSION"), (int)0x4000000);
                    if (null == permissionIntent) {
                        AoaUsb.outputLogInfo(new Object[0]);
                        continue;
                    }
                    usbManager.requestPermission(usbAccessory, permissionIntent);
                    long startTime = 0L;
                    long currentTime = 0L;
                    long difference = 0L;
                    int differenceInt = 0;
                    startTime = System.currentTimeMillis();
                    while (!usbManager.hasPermission(usbAccessory)) {
                        currentTime = System.currentTimeMillis();
                        difference = currentTime - startTime;
                        differenceInt = (int)difference;
                        if ((long)differenceInt < Long.MIN_VALUE || Long.MAX_VALUE < (long)differenceInt) {
                            AoaUsb.outputLogInfo(new Object[0]);
                            break;
                        }
                        if (timeout[0] < differenceInt) {
                            timeout[0] = 0;
                            AoaUsb.outputLogInfo(new Object[0]);
                            break;
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (Exception e) {
                            // empty catch block
                            break;
                        }
                    }
                    timeout[0] = timeout[0] - differenceInt;
                    if (timeout[0] <= 0) continue;
                    result = 0;
                    continue;
                }
                result = 0;
                continue;
            }
            catch (Exception e) {
                AoaUsb.outputLogInfo(e);
            }
        }
        if (result == 0) {
            this.mUsbManager = usbManager;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int open(int handle, Object context) {
        if (null == this.mUsbManager || null == this.mUsbAccessory || null == context) {
            AoaUsb.outputLogInfo(new Object[0]);
            return 2;
        }
        mContext = (Context)context;
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.hardware.usb.action.USB_ACCESSORY_DETACHED");
        mContext.registerReceiver(this.mUsbReceiver, filter);
        FileDescriptor fd = null;
        Object object = this.mLockParcelFdObj;
        synchronized (object) {
            try {
                this.mFileDescriptor = this.mUsbManager.openAccessory(this.mUsbAccessory);
            }
            catch (Exception e) {
                this.mFileDescriptor = null;
            }
            if (null == this.mFileDescriptor) {
                mContext.unregisterReceiver(this.mUsbReceiver);
                AoaUsb.outputLogInfo(new Object[0]);
                return 2;
            }
            fd = this.mFileDescriptor.getFileDescriptor();
        }
        try {
            this.mOutputStream = new FileOutputStream(fd);
        }
        catch (Exception e) {
            this.clean();
            mContext.unregisterReceiver(this.mUsbReceiver);
            AoaUsb.outputLogInfo(e);
            return 2;
        }
        try {
            this.mStreamReadThread = new StreamReadThread();
            this.mStreamReadThread.startThread(fd);
        }
        catch (IllegalArgumentException e) {
            this.clean();
            mContext.unregisterReceiver(this.mUsbReceiver);
            AoaUsb.outputLogInfo(e);
            return 2;
        }
        catch (Exception e) {
            this.clean();
            mContext.unregisterReceiver(this.mUsbReceiver);
            AoaUsb.outputLogInfo(e);
            return 2;
        }
        this.mHandle = handle;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void clean() {
        if (null != this.mOutputStream) {
            try {
                this.mOutputStream.close();
                this.mOutputStream = null;
            }
            catch (Exception e) {
                AoaUsb.outputLogInfo(e);
            }
        }
        Object object = this.mLockParcelFdObj;
        synchronized (object) {
            if (null != this.mFileDescriptor) {
                try {
                    this.mFileDescriptor.close();
                    this.mFileDescriptor = null;
                }
                catch (Exception e) {
                    AoaUsb.outputLogInfo(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int close() {
        boolean closeSuccess = true;
        mContext.unregisterReceiver(this.mUsbReceiver);
        if (null != this.mOutputStream) {
            try {
                this.mOutputStream.close();
                this.mOutputStream = null;
            }
            catch (Exception e) {
                AoaUsb.outputLogInfo(e);
                closeSuccess = false;
            }
        }
        Object e = this.mLockParcelFdObj;
        synchronized (e) {
            if (null != this.mFileDescriptor) {
                try {
                    this.mFileDescriptor.close();
                    this.mFileDescriptor = null;
                }
                catch (Exception e2) {
                    AoaUsb.outputLogInfo(e2);
                    closeSuccess = false;
                }
            }
        }
        if (null != this.mStreamReadThread) {
            try {
                this.mStreamReadThread.stopThread();
                this.mStreamReadThread = null;
            }
            catch (Exception e3) {
                AoaUsb.outputLogInfo(e3);
                closeSuccess = false;
            }
        }
        if (!closeSuccess) {
            return 255;
        }
        this.mHandle = -1;
        this.mUsbAccessory = null;
        this.mUsbManager = null;
        return 0;
    }

    @Override
    public final int write(byte[] data, int offset, int dataSize, int[] timelimit, int[] sentSize) {
        byte[] totalWriteData;
        if (null == data || null == sentSize || null == timelimit) {
            return 1;
        }
        try {
            totalWriteData = new byte[dataSize];
            System.arraycopy(data, offset, totalWriteData, 0, dataSize);
        }
        catch (Exception e) {
            return 5;
        }
        int result = 0;
        try {
            long startTime = System.currentTimeMillis();
            int differenceInt = 0;
            int remainingBytes = totalWriteData.length;
            int sourceIndex = 0;
            while (0 < remainingBytes) {
                byte[] writeBuffer = new byte[16384];
                int writeBufferSize = Math.min(remainingBytes, 16384);
                int[] written = new int[1];
                System.arraycopy(totalWriteData, sourceIndex, writeBuffer, 0, writeBufferSize);
                if (0 == writeBufferSize) {
                    return 1;
                }
                if (null == this.mOutputStream) {
                    return 3;
                }
                written[0] = 0;
                try {
                    this.mOutputStream.write(writeBuffer, 0, writeBufferSize);
                    written[0] = writeBufferSize;
                }
                catch (Exception e) {
                    written[0] = 0;
                    AoaUsb.outputLogInfo(e);
                    return 3;
                }
                remainingBytes -= written[0];
                sourceIndex += written[0];
                sentSize[0] = sentSize[0] + written[0];
                if (0 != written[0]) continue;
                differenceInt = (int)(System.currentTimeMillis() - startTime);
                if ((long)differenceInt < Long.MIN_VALUE || Long.MAX_VALUE < (long)differenceInt) {
                    result = 4;
                    break;
                }
                if (differenceInt > timelimit[0]) {
                    result = 4;
                    break;
                }
                Thread.sleep(20L);
            }
            if (0 == result) {
                timelimit[0] = timelimit[0] - differenceInt;
            } else if (4 == result) {
                timelimit[0] = 0;
            }
        }
        catch (Exception e) {
            AoaUsb.outputLogInfo(e);
            result = 255;
        }
        return result;
    }

    @Override
    public final int read(byte[] data, int offset, int dataSize, int[] timelimit, int[] readSize) {
        if (null == data || null == readSize || null == timelimit || 0 == dataSize) {
            return 1;
        }
        long startTime = System.currentTimeMillis();
        int differenceInt = 0;
        int totalBytesReceived = 0;
        boolean gotData = false;
        int result = 255;
        int bufferOffset = offset;
        byte[] receiveBuffer = new byte[dataSize];
        int receiveSize = 0;
        while (true) {
            try {
                receiveSize = this.mStreamReadThread.read(receiveBuffer, 0, dataSize - totalBytesReceived);
            }
            catch (Exception e) {
                result = 255;
                AoaUsb.outputLogInfo(e);
                break;
            }
            if (0 < receiveSize) {
                gotData = true;
                try {
                    System.arraycopy(receiveBuffer, 0, data, bufferOffset, receiveSize);
                }
                catch (Exception e) {
                    result = 5;
                    break;
                }
                readSize[0] = totalBytesReceived += receiveSize;
                bufferOffset += receiveSize;
                if (totalBytesReceived == dataSize) {
                    result = 0;
                    break;
                }
            }
            if ((long)(differenceInt = (int)(System.currentTimeMillis() - startTime)) < Long.MIN_VALUE || Long.MAX_VALUE < (long)differenceInt) {
                result = 4;
                break;
            }
            if (!gotData && differenceInt > timelimit[0]) {
                result = 4;
                break;
            }
            if (gotData && 0 >= receiveSize) {
                result = 0;
                break;
            }
            try {
                Thread.sleep(20L);
            }
            catch (Exception exception) {}
        }
        if (0 == result) {
            timelimit[0] = timelimit[0] - differenceInt;
        } else if (4 == result) {
            timelimit[0] = 0;
        }
        return result;
    }

    @Override
    public final int enableFlowControl(int enable) {
        return 0;
    }

    @Override
    public final int getOnlineTMStatus(int[] onlineStatus) {
        onlineStatus[0] = 1;
        return 0;
    }

    @Override
    public final int getOnlineDMStatus(int[] onlineStatus) {
        onlineStatus[0] = 1;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isPowerOn() {
        Object object = this.mLockParcelFdObj;
        synchronized (object) {
            return this.mFileDescriptor != null;
            {
            }
        }
    }

    @Override
    public final boolean checkDevice(String deviceName) {
        if (null == this.mUsbAccessory) {
            return false;
        }
        String serial = null;
        try {
            serial = this.mUsbAccessory.getSerial();
            if (null == serial) {
                return false;
            }
        }
        catch (Exception e) {
            AoaUsb.outputLogInfo(e);
            return false;
        }
        return serial.equals(deviceName);
    }

    public static boolean isConnection(Object context) {
        UsbAccessory[] usbAccessory;
        boolean result = false;
        UsbManager usbManager = (UsbManager)((Context)context).getSystemService("usb");
        if (null == usbManager) {
            return false;
        }
        try {
            usbAccessory = usbManager.getAccessoryList();
        }
        catch (Exception e) {
            usbAccessory = null;
        }
        result = null != usbAccessory;
        return result;
    }

    public static String getDeviceName(Object context) {
        UsbAccessory[] usbAccessory;
        UsbManager usbManager = (UsbManager)((Context)context).getSystemService("usb");
        if (null == usbManager) {
            AoaUsb.outputLogInfo(new Object[0]);
            return null;
        }
        try {
            usbAccessory = usbManager.getAccessoryList();
        }
        catch (Exception e) {
            usbAccessory = null;
        }
        if (null == usbAccessory) {
            return null;
        }
        String serial = null;
        try {
            serial = usbAccessory[0].getSerial();
        }
        catch (Exception e) {
            AoaUsb.outputLogInfo(e);
        }
        return serial;
    }
}

