/*
 * Decompiled with CFR 0.152.
 */
package com.epson.epsonio.usb;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbAccessory;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbManager;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.epson.epsonio.DeviceInfo;
import com.epson.epsonio.Finder;
import com.epson.epsonio.usb.AoaUsb;
import com.epson.epsonio.usb.Usb;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class DevUsb {
    private static final String ACTION_USB_PERMISSION = "com.android.eposprint.USB_PERMISSION";
    private static final int VID_EPSON = 1208;
    private static final int PID_VENDER_CLASS = 514;
    private static final int PID_PRINTER_CLASS_MIN = 3584;
    private static final int PID_PRINTER_CLASS_MAX = 3839;
    private static final String AOA_EPSON = "EPSON";
    private static final String DEFAULT_PRINTER_NAME = "TM Printer";
    private static UsbManager mUsbManager = null;
    private static HashMap<String, UsbDevice> mUsbDeviceList = null;
    private static ArrayList<DeviceInfo> mDeviceInfoList = new ArrayList();
    private static Thread mDiscoverThread = null;
    private static boolean mDiscoverThreadRunning = false;
    private static BroadcastReceiver mUsbReceiver = null;
    private static Context mContext = null;
    private static int mConnectionType = 0;
    private static Integer unregisterReceiverSynchronizer = 0;
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    private static final Handler unregisterReceiverCallbackHandler = new Handler(Looper.getMainLooper()){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            if (0 == msg.what) {
                Integer n = unregisterReceiverSynchronizer;
                synchronized (n) {
                    mContext.unregisterReceiver(mUsbReceiver);
                    unregisterReceiverSynchronizer.notify();
                }
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int start(Context caller, int deviceType, String deviceName, final int usbDeviceName) {
        if (259 != deviceType) {
            return 1;
        }
        if (null == caller || null != deviceName) {
            return 1;
        }
        if (usbDeviceName != 1 && usbDeviceName != 0) {
            return 1;
        }
        ArrayList<DeviceInfo> arrayList = mDeviceInfoList;
        synchronized (arrayList) {
            mDeviceInfoList.clear();
        }
        mContext = caller;
        if (null == mUsbManager) {
            mUsbManager = (UsbManager)mContext.getSystemService("usb");
        }
        mUsbReceiver = new BroadcastReceiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if (DevUsb.ACTION_USB_PERMISSION.equals(action)) {
                    Intent i;
                    1 var4_4 = this;
                    synchronized (var4_4) {
                        UsbDevice device = (UsbDevice)intent.getParcelableExtra("device");
                        if (intent.getBooleanExtra("permission", false) && null != device) {
                            i = new Intent();
                            i.putExtra("DEVICE_NAME", device.getDeviceName());
                            i.putExtra("CONNECTION_TYPE", mConnectionType);
                            if (1208 == device.getVendorId() && (514 == device.getProductId() || 3584 <= device.getProductId() && 3839 >= device.getProductId())) {
                                ArrayList arrayList = mDeviceInfoList;
                                synchronized (arrayList) {
                                    boolean bFind = false;
                                    for (DeviceInfo devInfo : mDeviceInfoList) {
                                        String work = devInfo.getDeviceName();
                                        if (!work.equals(device.getDeviceName())) continue;
                                        bFind = true;
                                        break;
                                    }
                                    if (!bFind) {
                                        String productName = DevUsb.DEFAULT_PRINTER_NAME;
                                        if (usbDeviceName == 1 && Build.VERSION.SDK_INT >= 21 && mContext.getApplicationInfo().targetSdkVersion >= 21) {
                                            productName = device.getProductName();
                                            if (productName == null) {
                                                productName = DevUsb.DEFAULT_PRINTER_NAME;
                                            } else if (!Finder.isEpson(productName)) {
                                                productName = DevUsb.DEFAULT_PRINTER_NAME;
                                            }
                                        }
                                        DeviceInfo deviceInfo = new DeviceInfo(259, productName, device.getDeviceName(), "", "");
                                        mDeviceInfoList.add(deviceInfo);
                                    }
                                }
                            }
                        }
                    }
                    var4_4 = this;
                    synchronized (var4_4) {
                        block27: {
                            UsbAccessory accessory = (UsbAccessory)intent.getParcelableExtra("accessory");
                            if (intent.getBooleanExtra("permission", false) && null != accessory) {
                                i = new Intent();
                                String serial = null;
                                try {
                                    serial = accessory.getSerial();
                                    i.putExtra("DEVICE_NAME", serial);
                                    i.putExtra("CONNECTION_TYPE", mConnectionType);
                                    if (!accessory.getManufacturer().equals(DevUsb.AOA_EPSON)) break block27;
                                    ArrayList bFind = mDeviceInfoList;
                                    synchronized (bFind) {
                                        boolean bFind2 = false;
                                        for (DeviceInfo devInfo : mDeviceInfoList) {
                                            String work = devInfo.getDeviceName();
                                            if (null == serial || !work.equals(serial)) continue;
                                            bFind2 = true;
                                            break;
                                        }
                                        if (!bFind2) {
                                            String productName = DevUsb.DEFAULT_PRINTER_NAME;
                                            if (usbDeviceName == 1 && !Finder.isEpson(productName = accessory.getModel())) {
                                                productName = DevUsb.DEFAULT_PRINTER_NAME;
                                            }
                                            DeviceInfo deviceInfo = new DeviceInfo(259, productName, serial, "", "");
                                            mDeviceInfoList.add(deviceInfo);
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    Usb.outputLogInfo(e);
                                }
                            }
                        }
                    }
                }
            }
        };
        try {
            IntentFilter filter = new IntentFilter(ACTION_USB_PERMISSION);
            mContext.registerReceiver(mUsbReceiver, filter);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (AoaUsb.isConnection(mContext) && Build.VERSION.SDK_INT >= 29 && DevUsb.mContext.getApplicationInfo().targetSdkVersion >= 29) {
            DevUsb.requestPermission();
        }
        mDiscoverThread = DevUsb.CreateDiscoverThread(usbDeviceName);
        mDiscoverThreadRunning = true;
        mDiscoverThread.start();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final DeviceInfo[] getResult(int[] errStatus, int filterOption) {
        DeviceInfo[] deviceInfoList = null;
        if (null == errStatus || 0 == errStatus.length) {
            return null;
        }
        errStatus[0] = 255;
        if (!mDiscoverThreadRunning) {
            errStatus[0] = 6;
            return null;
        }
        try {
            ArrayList<DeviceInfo> arrayList = mDeviceInfoList;
            synchronized (arrayList) {
                deviceInfoList = mDeviceInfoList.toArray(new DeviceInfo[mDeviceInfoList.size()]);
            }
            errStatus[0] = 0;
        }
        catch (Exception e) {
            errStatus[0] = 5;
        }
        return deviceInfoList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int stop() {
        if (!mDiscoverThreadRunning) {
            return 6;
        }
        mDiscoverThreadRunning = false;
        if (null != mUsbReceiver) {
            if (unregisterReceiverCallbackHandler.getLooper().getThread().getId() != Thread.currentThread().getId()) {
                Integer n = unregisterReceiverSynchronizer;
                synchronized (n) {
                    Message msg = unregisterReceiverCallbackHandler.obtainMessage(0);
                    unregisterReceiverCallbackHandler.sendMessage(msg);
                    try {
                        unregisterReceiverSynchronizer.wait();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            mContext.unregisterReceiver(mUsbReceiver);
        }
        return 0;
    }

    private static Thread CreateDiscoverThread(final int usbDeviceName) {
        Thread theThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (mDiscoverThreadRunning) {
                    Iterator deviceIterator;
                    try {
                        mUsbDeviceList = mUsbManager.getDeviceList();
                        deviceIterator = mUsbDeviceList.values().iterator();
                    }
                    catch (Exception ex) {
                        break;
                    }
                    while (deviceIterator.hasNext()) {
                        UsbDevice device = (UsbDevice)deviceIterator.next();
                        if (1208 != device.getVendorId() || 514 != device.getProductId() && (3584 > device.getProductId() || 3839 < device.getProductId())) continue;
                        ArrayList arrayList = mDeviceInfoList;
                        synchronized (arrayList) {
                            boolean bFind = false;
                            for (DeviceInfo devInfo : mDeviceInfoList) {
                                String work = devInfo.getDeviceName();
                                if (!work.equals(device.getDeviceName())) continue;
                                bFind = true;
                                break;
                            }
                            if (!bFind) {
                                String productName = DevUsb.DEFAULT_PRINTER_NAME;
                                if (usbDeviceName == 1 && Build.VERSION.SDK_INT >= 21 && mContext.getApplicationInfo().targetSdkVersion >= 21) {
                                    productName = device.getProductName();
                                    if (productName == null) {
                                        productName = DevUsb.DEFAULT_PRINTER_NAME;
                                    } else if (!Finder.isEpson(productName)) {
                                        productName = DevUsb.DEFAULT_PRINTER_NAME;
                                    }
                                }
                                DeviceInfo deviceInfo = new DeviceInfo(259, productName, device.getDeviceName(), "", "");
                                mDeviceInfoList.add(deviceInfo);
                            }
                        }
                    }
                    UsbAccessory[] usbAccessoryList = mUsbManager.getAccessoryList();
                    if (usbAccessoryList != null) {
                        UsbAccessory usbAccessory = null;
                        for (int i = 0; i < usbAccessoryList.length; ++i) {
                            usbAccessory = usbAccessoryList[i];
                            if (!usbAccessory.getManufacturer().equals(DevUsb.AOA_EPSON)) continue;
                            ArrayList arrayList = mDeviceInfoList;
                            synchronized (arrayList) {
                                boolean bFind = false;
                                String serial = null;
                                try {
                                    serial = usbAccessory.getSerial();
                                }
                                catch (Exception e) {
                                    Usb.outputLogInfo(e);
                                    continue;
                                }
                                for (DeviceInfo devInfo : mDeviceInfoList) {
                                    String work = devInfo.getDeviceName();
                                    if (null == serial || !work.equals(serial)) continue;
                                    bFind = true;
                                    break;
                                }
                                if (!bFind) {
                                    String productName = DevUsb.DEFAULT_PRINTER_NAME;
                                    if (usbDeviceName == 1 && !Finder.isEpson(productName = usbAccessory.getModel())) {
                                        productName = DevUsb.DEFAULT_PRINTER_NAME;
                                    }
                                    DeviceInfo deviceInfo = new DeviceInfo(259, productName, serial, "", "");
                                    mDeviceInfoList.add(deviceInfo);
                                }
                                continue;
                            }
                        }
                    }
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        });
        return theThread;
    }

    private static void requestPermission() {
        UsbAccessory[] usbAccessoryList;
        if (mContext == null) {
            return;
        }
        UsbManager usbManager = (UsbManager)mContext.getSystemService("usb");
        if (null == usbManager) {
            Usb.outputLogInfo(new Object[0]);
            return;
        }
        try {
            usbAccessoryList = usbManager.getAccessoryList();
        }
        catch (Exception e) {
            usbAccessoryList = null;
        }
        if (null == usbAccessoryList) {
            Usb.outputLogInfo(new Object[0]);
            return;
        }
        UsbAccessory usbAccessory = null;
        for (int i = 0; i < usbAccessoryList.length; ++i) {
            usbAccessory = usbAccessoryList[i];
            if (null == usbAccessory) {
                Usb.outputLogInfo(new Object[0]);
                continue;
            }
            if (!usbAccessory.getManufacturer().equals(AOA_EPSON)) continue;
            PendingIntent permissionIntent = PendingIntent.getBroadcast((Context)mContext, (int)0, (Intent)new Intent(ACTION_USB_PERMISSION), (int)0x4000000);
            if (null == permissionIntent) {
                Usb.outputLogInfo(new Object[0]);
                continue;
            }
            usbManager.requestPermission(usbAccessory, permissionIntent);
        }
    }
}

