/*
 * Decompiled with CFR 0.152.
 */
package com.epson.epsonio.usb;

import android.annotation.TargetApi;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.os.Build;
import com.epson.epsonio.usb.Usb;
import java.util.HashMap;
import java.util.Map;

public class DeviceUsb
extends Usb {
    private static final int M_INVALID_HANDLE_INDEX = -1;
    private static final int M_MAX_DEVICE_SENT_SIZE_AT_ONCE = 4096;
    private static final int M_MAX_DEVICE_RECEIVE_BUFFER_SIZE = 1024;
    private static final int VSR_GET_TM_STATUS = 1;
    private static final int VSR_SET_TM_STATUS = 2;
    private static final int VSR_GET_DM_STATUS = 3;
    private static final int VSR_GET_TM_COUNT = 18;
    private static final int VSR_CLEAR_TM_COUNT = 17;
    private static final int VSR_GET_UB_CONFIGURATION = 0;
    private static final int USB_TYPE_VENDOR = 64;
    private static final int USB_RECIP_INTERFACE = 1;
    private static final int USB_ENDPOINT_OUT = 0;
    private static final int USB_ENDPOINT_IN = 128;
    private static final int USB_SUPPORT_FLOW_CONTROL = 2;
    private static final int USB_OFFLINE_STATUS_OFFLINE = 1;
    private static final int USB_FLOW_CONTROL_ENABLE = 0;
    private static final int USB_FLOW_CONTROL_DISABLE = 2;
    private static final int USB_REQ_CLEAR_FEATURE = 1;
    private static final int USB_REQ_SET_FEATURE = 3;
    private static final int VID_EPSON = 1208;
    private static final int PID_VENDER_CLASS = 514;
    private static final int PID_PRINTER_CLASS_MIN = 3584;
    private static final int PID_PRINTER_CLASS_MAX = 3839;
    private static final int USB_PRINTER_CLASS = 7;
    private static final int USB_VENDOR_CLASS = 255;
    private UsbManager mUsbManager = null;
    private UsbDevice mUsbDevice = null;
    private UsbDeviceConnection mConnection = null;
    private UsbInterface mUsbInterface = null;
    private UsbEndpoint mUsbSendEndpoint = null;
    private UsbEndpoint mUsbReceiveEndpoint = null;

    @Override
    public int getUsbType() {
        return 0;
    }

    @Override
    public int setUsbInfo(String deviceName) {
        return 0;
    }

    @Override
    public final int requestPermission(Object context, String deviceName, int[] timeout) {
        HashMap deviceList;
        if (null == deviceName) {
            DeviceUsb.outputLogInfo(new Object[0]);
            return 2;
        }
        UsbManager usbManager = (UsbManager)((Context)context).getSystemService("usb");
        if (null == usbManager) {
            DeviceUsb.outputLogInfo(new Object[0]);
            return 2;
        }
        try {
            deviceList = usbManager.getDeviceList();
        }
        catch (Exception e) {
            DeviceUsb.outputLogInfo(e);
            return 2;
        }
        UsbDevice usbDevice = (UsbDevice)deviceList.get(deviceName);
        if (null == usbDevice) {
            DeviceUsb.outputLogInfo(new Object[0]);
            return 2;
        }
        try {
            if (!usbManager.hasPermission(usbDevice)) {
                PendingIntent permissionIntent = PendingIntent.getBroadcast((Context)((Context)context), (int)0, (Intent)new Intent("com.android.eposprint.USB_PERMISSION"), (int)0x4000000);
                if (null == permissionIntent) {
                    DeviceUsb.outputLogInfo(new Object[0]);
                    return 2;
                }
                usbManager.requestPermission(usbDevice, permissionIntent);
                long startTime = 0L;
                long currentTime = 0L;
                long difference = 0L;
                int differenceInt = 0;
                startTime = System.currentTimeMillis();
                while (!usbManager.hasPermission(usbDevice)) {
                    currentTime = System.currentTimeMillis();
                    difference = currentTime - startTime;
                    differenceInt = (int)difference;
                    if ((long)differenceInt < Long.MIN_VALUE || Long.MAX_VALUE < (long)differenceInt) {
                        DeviceUsb.outputLogInfo(new Object[0]);
                        return 255;
                    }
                    if (timeout[0] < differenceInt) {
                        timeout[0] = 0;
                        DeviceUsb.outputLogInfo(new Object[0]);
                        return 2;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception e) {
                        DeviceUsb.outputLogInfo(e);
                        break;
                    }
                }
                timeout[0] = timeout[0] - differenceInt;
            }
        }
        catch (Exception e) {
            DeviceUsb.outputLogInfo(e);
            return 0;
        }
        this.mUsbDevice = usbDevice;
        this.mUsbManager = usbManager;
        return 0;
    }

    @Override
    public final int open(int handle, Object context) {
        if (null == this.mUsbDevice || null == this.mUsbManager) {
            DeviceUsb.outputLogInfo(new Object[0]);
            return 2;
        }
        try {
            this.mUsbInterface = this.getUsbInterface(this.mUsbDevice);
            if (null == this.mUsbInterface) {
                DeviceUsb.outputLogInfo(new Object[0]);
                return 255;
            }
            int count = this.mUsbInterface.getEndpointCount();
            this.mUsbSendEndpoint = null;
            this.mUsbReceiveEndpoint = null;
            for (int i = 0; i < count; ++i) {
                int endpoint = this.mUsbInterface.getEndpoint(i).getDirection();
                if (0 == endpoint) {
                    if (this.mUsbSendEndpoint != null) continue;
                    this.mUsbSendEndpoint = this.mUsbInterface.getEndpoint(i);
                    continue;
                }
                if (128 != endpoint || this.mUsbReceiveEndpoint != null) continue;
                this.mUsbReceiveEndpoint = this.mUsbInterface.getEndpoint(i);
            }
            this.mConnection = this.mUsbManager.openDevice(this.mUsbDevice);
            if (null != this.mConnection) {
                if (!this.mConnection.claimInterface(this.mUsbInterface, true)) {
                    DeviceUsb.outputLogInfo(new Object[0]);
                    return 255;
                }
            } else {
                DeviceUsb.outputLogInfo(new Object[0]);
                return 2;
            }
            this.mHandle = handle;
        }
        catch (Exception e) {
            DeviceUsb.outputLogInfo(e);
            return 255;
        }
        return 0;
    }

    @Override
    public final int close() {
        if (null == this.mConnection) {
            DeviceUsb.outputLogInfo(new Object[0]);
            return 6;
        }
        try {
            this.mConnection.close();
            this.mConnection.releaseInterface(this.mUsbInterface);
            this.mHandle = -1;
            this.mUsbManager = null;
            this.mUsbDevice = null;
            this.mConnection = null;
            this.mUsbInterface = null;
            this.mUsbSendEndpoint = null;
            this.mUsbReceiveEndpoint = null;
        }
        catch (Exception e) {
            DeviceUsb.outputLogInfo(e);
            return 255;
        }
        return 0;
    }

    @Override
    public final int write(byte[] data, int offset, int dataSize, int[] timelimit, int[] sentSize) {
        byte[] totalWriteData;
        if (null == data || null == sentSize || null == timelimit) {
            DeviceUsb.outputLogInfo(new Object[0]);
            return 1;
        }
        try {
            totalWriteData = new byte[dataSize];
            System.arraycopy(data, offset, totalWriteData, 0, dataSize);
        }
        catch (Exception e) {
            DeviceUsb.outputLogInfo(e);
            return 5;
        }
        int result = 0;
        try {
            long startTime = System.currentTimeMillis();
            int differenceInt = 0;
            int remainingBytes = totalWriteData.length;
            int sourceIndex = 0;
            while (0 < remainingBytes) {
                byte[] writeBuffer = new byte[4096];
                int writeBufferSize = Math.min(remainingBytes, 4096);
                int[] written = new int[1];
                System.arraycopy(totalWriteData, sourceIndex, writeBuffer, 0, writeBufferSize);
                written[0] = 0;
                if (null == this.mConnection || null == this.mUsbSendEndpoint) {
                    DeviceUsb.outputLogInfo(new Object[0]);
                    return 2;
                }
                byte[] abyStatus = new byte[2];
                this.ioctrlRev(1, abyStatus);
                this.ioctrlSend(17, 0, 0);
                this.ioctrlRev(18, abyStatus);
                int retval = this.mConnection.bulkTransfer(this.mUsbSendEndpoint, writeBuffer, writeBufferSize, timelimit[0]);
                if (0 > retval) {
                    this.ioctrlSend(3, 0, 0);
                    this.ioctrlSend(1, 0, 0);
                }
                this.ioctrlRev(18, abyStatus);
                written[0] = abyStatus[0] & 0xFF | (abyStatus[1] & 0xFF) << 8;
                remainingBytes -= written[0];
                sourceIndex += written[0];
                sentSize[0] = sentSize[0] + written[0];
                if (0 != written[0]) continue;
                differenceInt = (int)(System.currentTimeMillis() - startTime);
                if ((long)differenceInt < Long.MIN_VALUE || Long.MAX_VALUE < (long)differenceInt) {
                    result = 4;
                    break;
                }
                if (differenceInt > timelimit[0]) {
                    result = 4;
                    break;
                }
                Thread.sleep(20L);
            }
            if (0 == result) {
                timelimit[0] = timelimit[0] - differenceInt;
            } else if (4 == result) {
                timelimit[0] = 0;
            }
        }
        catch (Exception e) {
            DeviceUsb.outputLogInfo(e);
            result = 255;
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final int read(byte[] data, int offset, int dataSize, int[] timelimit, int[] readSize) {
        block13: {
            if (null == readSize || null == data || null == timelimit) {
                DeviceUsb.outputLogInfo(new Object[0]);
                return 1;
            }
            startTime = System.currentTimeMillis();
            differenceInt = 0;
            totalBytesReceived = 0;
            gotData = false;
            result = 255;
            bufferOffset = offset;
            do {
                receiveBuffer = new byte[1024];
                receiveBufferSize = Math.min(receiveBuffer.length, dataSize);
                receiveSize = new int[]{0};
                if (null == this.mConnection || null == this.mUsbReceiveEndpoint) {
                    DeviceUsb.outputLogInfo(new Object[0]);
                    return 2;
                }
                transferSize = 0;
                transferSize = this.mConnection.bulkTransfer(this.mUsbReceiveEndpoint, receiveBuffer, receiveBufferSize, timelimit[0]);
                if (0 > transferSize) {
                    DeviceUsb.outputLogInfo(new Object[0]);
                    return 255;
                }
                receiveSize[0] = transferSize;
                if (0 >= receiveSize[0]) ** GOTO lbl-1000
                gotData = true;
                try {
                    System.arraycopy(receiveBuffer, 0, data, bufferOffset, receiveSize[0]);
                }
                catch (Exception e) {
                    DeviceUsb.outputLogInfo(new Object[]{e});
                    result = 5;
                    break block13;
                }
                readSize[0] = totalBytesReceived += receiveSize[0];
                bufferOffset += receiveSize[0];
                if (totalBytesReceived == dataSize) {
                    result = 0;
                } else if ((long)(differenceInt = (int)(System.currentTimeMillis() - startTime)) < -9223372036854775808L || 0x7FFFFFFFFFFFFFFFL < (long)differenceInt) {
                    result = 4;
                } else {
                    if (gotData || differenceInt <= timelimit[0]) continue;
                    result = 4;
                }
                break block13;
            } while (!gotData || 0 < receiveSize[0]);
            result = 0;
        }
        if (0 == result) {
            timelimit[0] = timelimit[0] - differenceInt;
        } else if (4 == result) {
            timelimit[0] = 0;
        }
        return result;
    }

    @Override
    public final int enableFlowControl(int enable) {
        int enableFlowControl = 1 == enable ? 0 : 2;
        int result = 255;
        byte[] status = new byte[2];
        result = this.ioctrlRev(0, status);
        if (0 != result) {
            return result;
        }
        if (0 == (status[0] & 2)) {
            return 0;
        }
        while (0 == (result = this.ioctrlSend(2, enableFlowControl, 0)) && 0 == (result = this.ioctrlRev(1, status))) {
            if ((status[0] & 2) == enableFlowControl) {
                result = 0;
                break;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                DeviceUsb.outputLogInfo(e);
            }
        }
        return result;
    }

    @Override
    public final int getOnlineTMStatus(int[] onlineStatus) {
        return this.getOnlineStatus(onlineStatus, 1);
    }

    @Override
    public final int getOnlineDMStatus(int[] onlineStatus) {
        return this.getOnlineStatus(onlineStatus, 3);
    }

    protected int getOnlineStatus(int[] onlineStatus, int controlCode) {
        int result = 255;
        byte[] status = new byte[2];
        if (null == onlineStatus || 1 > onlineStatus.length) {
            DeviceUsb.outputLogInfo(new Object[0]);
            return 1;
        }
        status[0] = 0;
        result = this.ioctrlRev(controlCode, status);
        if (0 != result) {
            DeviceUsb.outputLogInfo(new Object[0]);
            return 255;
        }
        onlineStatus[0] = 0 == (status[0] & 1) ? 1 : 0;
        return 0;
    }

    @Override
    public final boolean isPowerOn() {
        int[] onlineStatus = new int[]{0};
        int result = this.getOnlineStatus(onlineStatus, 1);
        return result == 0;
    }

    @Override
    public final boolean checkDevice(String deviceName) {
        if (null == this.mUsbDevice) {
            return false;
        }
        return false != this.mUsbDevice.getDeviceName().equals(deviceName);
    }

    protected int ioctrlRev(int request, byte[] buffer) {
        if (null == this.mConnection) {
            DeviceUsb.outputLogInfo(new Object[0]);
            return 255;
        }
        int iRet = 0;
        for (int i = 0; i < 2; ++i) {
            iRet = this.mConnection.controlTransfer(193, request, 0, this.mUsbInterface.getId(), buffer, buffer.length, 100);
            if (0 > iRet) {
                DeviceUsb.outputLogInfo(new Object[0]);
                iRet = 255;
                break;
            }
            iRet = 0;
        }
        return iRet;
    }

    protected int ioctrlSend(int request, int value, int length) {
        if (null == this.mConnection) {
            DeviceUsb.outputLogInfo(new Object[0]);
            return 255;
        }
        int iRet = 0;
        iRet = this.mConnection.controlTransfer(65, request, value, this.mUsbInterface.getId(), null, length, 100);
        if (0 <= iRet) {
            iRet = 0;
        } else {
            DeviceUsb.outputLogInfo(new Object[0]);
            iRet = 255;
        }
        return iRet;
    }

    public static boolean isConnection(Object context) {
        HashMap deviceList;
        UsbManager usbManager = (UsbManager)((Context)context).getSystemService("usb");
        if (null == usbManager) {
            DeviceUsb.outputLogInfo(new Object[0]);
            return false;
        }
        try {
            deviceList = usbManager.getDeviceList();
        }
        catch (Exception e) {
            DeviceUsb.outputLogInfo(e);
            return false;
        }
        return !deviceList.isEmpty();
    }

    public static String getDeviceName(Object context) {
        HashMap deviceList;
        UsbManager usbManager = (UsbManager)((Context)context).getSystemService("usb");
        if (null == usbManager) {
            DeviceUsb.outputLogInfo(new Object[0]);
            return null;
        }
        try {
            deviceList = usbManager.getDeviceList();
        }
        catch (Exception e) {
            DeviceUsb.outputLogInfo(e);
            return null;
        }
        if (deviceList.isEmpty()) {
            DeviceUsb.outputLogInfo(new Object[0]);
            return null;
        }
        String deviceName = null;
        try {
            for (Map.Entry entry : deviceList.entrySet()) {
                UsbDevice usbDevice = (UsbDevice)entry.getValue();
                if (1208 != usbDevice.getVendorId() || 514 != usbDevice.getProductId() && (3584 > usbDevice.getProductId() || 3839 < usbDevice.getProductId())) continue;
                deviceName = (String)entry.getKey();
                break;
            }
        }
        catch (Exception e) {
            DeviceUsb.outputLogInfo(e);
            return null;
        }
        return deviceName;
    }

    private UsbInterface getUsbInterface(UsbDevice usbDevice) {
        if (usbDevice == null) {
            DeviceUsb.outputLogInfo(new Object[0]);
            return null;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            return this.getUsbInterfaceRecommend(usbDevice);
        }
        return this.getUsbInterfaceDeprecate(usbDevice);
    }

    @TargetApi(value=21)
    private UsbInterface getUsbInterfaceRecommend(UsbDevice usbDevice) {
        if (usbDevice == null) {
            DeviceUsb.outputLogInfo(new Object[0]);
            return null;
        }
        int count = usbDevice.getInterfaceCount();
        UsbInterface usbInterface = null;
        for (int i = 0; i < count; ++i) {
            UsbInterface tmp = usbDevice.getInterface(i);
            String logText = tmp.toString();
            DeviceUsb.outputLogInfo(logText);
            if (tmp.getInterfaceClass() != 7 && tmp.getInterfaceClass() != 255) continue;
            usbInterface = tmp;
        }
        if (usbInterface == null) {
            DeviceUsb.outputLogInfo(new Object[0]);
        }
        return usbInterface;
    }

    private UsbInterface getUsbInterfaceDeprecate(UsbDevice usbDevice) {
        if (usbDevice == null) {
            DeviceUsb.outputLogInfo(new Object[0]);
            return null;
        }
        UsbInterface usbInterface = usbDevice.getInterface(0);
        if (usbInterface.getInterfaceClass() != 7 && usbInterface.getInterfaceClass() != 255) {
            DeviceUsb.outputLogInfo(new Object[0]);
            usbInterface = null;
        }
        return usbInterface;
    }
}

