/*
 * Decompiled with CFR 0.152.
 */
package com.epson.epsonio.usb;

import com.epson.epsonio.usb.RingBuffer;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.lang.reflect.Method;

public class StreamReadThread
extends Thread {
    private static int M_MAX_AOA_READ_BUFFER_SIZE = 16384;
    private static int M_MAX_RING_BUFFER_SIZE = 65536;
    private FileInputStream mInputStream = null;
    private RingBuffer mBuffer = null;
    private boolean mRunning = false;
    private final Object mLockObj = new Object();
    private static Class<?> mClassOutputLog = null;
    private static Method mOutputLogInfoMethod = null;

    public StreamReadThread() throws Exception {
        this.mBuffer = new RingBuffer(M_MAX_RING_BUFFER_SIZE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startThread(FileDescriptor fd) throws Exception {
        if (fd == null) {
            throw new IllegalArgumentException();
        }
        Object object = this.mLockObj;
        synchronized (object) {
            if (this.mInputStream != null) {
                throw new Exception();
            }
            try {
                this.mInputStream = new FileInputStream(fd);
            }
            catch (Exception e) {
                StreamReadThread.outputLogInfo(e);
                throw e;
            }
            this.mRunning = true;
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopThread() throws Exception {
        Object object = this.mLockObj;
        synchronized (object) {
            if (this.mInputStream == null) {
                throw new Exception();
            }
            this.mRunning = false;
            try {
                this.mInputStream.close();
                this.mInputStream = null;
            }
            catch (Exception e) {
                StreamReadThread.outputLogInfo(e);
                throw e;
            }
            if (this.isAlive()) {
                try {
                    this.join(600L);
                }
                catch (Exception e) {
                    this.mBuffer = null;
                    StreamReadThread.outputLogInfo(e);
                    throw e;
                }
            }
            if (this.isAlive()) {
                StreamReadThread.outputLogInfo("UsbAccessories would not unbind cleanly when application is closed or i/o stopped while the usb cable is still connected");
            }
            this.mBuffer = null;
        }
    }

    @Override
    public void run() {
        int transferSize = 0;
        byte[] receiveBuffer = new byte[M_MAX_AOA_READ_BUFFER_SIZE];
        while (this.mRunning) {
            try {
                this.mBuffer.enqueue(receiveBuffer, 0, transferSize);
            }
            catch (IllegalArgumentException e) {
                try {
                    Thread.sleep(20L);
                }
                catch (Exception ex) {
                    continue;
                }
            }
            catch (NullPointerException e) {
                StreamReadThread.outputLogInfo(e);
                break;
            }
            catch (Exception e) {
                StreamReadThread.outputLogInfo(e);
                try {
                    Thread.sleep(20L);
                }
                catch (Exception ex) {
                    continue;
                }
            }
            try {
                transferSize = this.mInputStream.read(receiveBuffer, 0, M_MAX_AOA_READ_BUFFER_SIZE);
            }
            catch (Exception e) {
                StreamReadThread.outputLogInfo(e);
                break;
            }
        }
    }

    public int read(byte[] data, int offset, int size) throws Exception {
        int readSize = 0;
        if (data == null) {
            throw new IllegalArgumentException();
        }
        try {
            readSize = this.mBuffer.dequeue(data, offset, size);
        }
        catch (NullPointerException e) {
            StreamReadThread.outputLogInfo(e);
            throw e;
        }
        catch (Exception e) {
            StreamReadThread.outputLogInfo(e);
            throw e;
        }
        return readSize;
    }

    private static void initializeOuputLogFunctions() {
        try {
            mClassOutputLog = Class.forName("com.epson.epos2.OutputLog");
            mOutputLogInfoMethod = mClassOutputLog.getDeclaredMethod("outputLogInfo", Long.TYPE, Object[].class);
            mOutputLogInfoMethod.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void outputLogInfo(Object ... param) {
        try {
            mOutputLogInfoMethod.invoke(mClassOutputLog, 0, param);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        try {
            StreamReadThread.initializeOuputLogFunctions();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }
}

