/*
 * Decompiled with CFR 0.152.
 */
package net.posprinter.service;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Binder;
import android.os.IBinder;
import android.util.Log;
import java.util.List;
import net.posprinter.asynncTask.PosAsynncTask;
import net.posprinter.posprinterface.BackgroundInit;
import net.posprinter.posprinterface.IMyBinder;
import net.posprinter.posprinterface.ProcessData;
import net.posprinter.posprinterface.UiExecute;
import net.posprinter.utils.PosPrinterDev;
import net.posprinter.utils.RoundQueue;

public class PosprinterService
extends Service {
    private PosPrinterDev xPrinterDev;
    private PosPrinterDev.ReturnMessage mMsg;
    private boolean isConnected = false;
    private RoundQueue<byte[]> que;
    private IBinder myBinder = new MyBinder();

    private RoundQueue<byte[]> getinstaceRoundQueue() {
        if (this.que == null) {
            this.que = new RoundQueue(500);
        }
        return this.que;
    }

    public void onCreate() {
        super.onCreate();
        this.que = this.getinstaceRoundQueue();
        Log.i((String)"TAG", (String)"onCreate");
    }

    public IBinder onBind(Intent intent) {
        Log.i((String)"TAG", (String)"onBind");
        return this.myBinder;
    }

    public boolean onUnbind(Intent intent) {
        return super.onUnbind(intent);
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.xPrinterDev != null) {
            this.xPrinterDev.Close();
        }
    }

    public class MyBinder
    extends Binder
    implements IMyBinder {
        @Override
        public void connectNetPort(final String ethernetIP, final int ethernetPort, UiExecute execute) {
            PosAsynncTask task = new PosAsynncTask(execute, new BackgroundInit(){

                @Override
                public boolean doinbackground() {
                    PosprinterService.this.xPrinterDev = new PosPrinterDev(PosPrinterDev.PortType.Ethernet, ethernetIP, ethernetPort);
                    PosprinterService.this.mMsg = PosprinterService.this.xPrinterDev.Open();
                    if (PosprinterService.this.mMsg.GetErrorCode().equals((Object)PosPrinterDev.ErrorCode.OpenPortSuccess)) {
                        PosprinterService.this.isConnected = true;
                        return true;
                    }
                    return false;
                }
            });
            task.execute(new Void[0]);
        }

        @Override
        public void connectBtPort(final String bluetoothID, UiExecute execute) {
            PosAsynncTask task = new PosAsynncTask(execute, new BackgroundInit(){

                @Override
                public boolean doinbackground() {
                    PosprinterService.this.xPrinterDev = new PosPrinterDev(PosPrinterDev.PortType.Bluetooth, bluetoothID);
                    PosprinterService.this.mMsg = PosprinterService.this.xPrinterDev.Open();
                    if (PosprinterService.this.mMsg.GetErrorCode().equals((Object)PosPrinterDev.ErrorCode.OpenPortSuccess)) {
                        PosprinterService.this.isConnected = true;
                        return true;
                    }
                    return false;
                }
            });
            task.execute(new Void[0]);
        }

        @Override
        public void connectUsbPort(final Context context, final String usbPathName, UiExecute execute) {
            PosAsynncTask task = new PosAsynncTask(execute, new BackgroundInit(){

                @Override
                public boolean doinbackground() {
                    PosprinterService.this.xPrinterDev = new PosPrinterDev(PosPrinterDev.PortType.USB, context, usbPathName);
                    PosprinterService.this.mMsg = PosprinterService.this.xPrinterDev.Open();
                    if (PosprinterService.this.mMsg.GetErrorCode().equals((Object)PosPrinterDev.ErrorCode.OpenPortSuccess)) {
                        PosprinterService.this.isConnected = true;
                        return true;
                    }
                    return false;
                }
            });
            task.execute(new Void[0]);
        }

        @Override
        public void disconnectCurrentPort(UiExecute execute) {
            PosAsynncTask task = new PosAsynncTask(execute, new BackgroundInit(){

                @Override
                public boolean doinbackground() {
                    PosprinterService.this.mMsg = PosprinterService.this.xPrinterDev.Close();
                    if (PosprinterService.this.mMsg.GetErrorCode().equals((Object)PosPrinterDev.ErrorCode.ClosePortSuccess)) {
                        PosprinterService.this.isConnected = false;
                        if (PosprinterService.this.que != null) {
                            PosprinterService.this.que.clear();
                        }
                        return true;
                    }
                    return false;
                }
            });
            task.execute(new Void[0]);
        }

        @Override
        public void write(final byte[] data, UiExecute execute) {
            PosAsynncTask task = new PosAsynncTask(execute, new BackgroundInit(){

                @Override
                public boolean doinbackground() {
                    if (data != null) {
                        PosprinterService.this.mMsg = PosprinterService.this.xPrinterDev.Write(data);
                        if (PosprinterService.this.mMsg.GetErrorCode().equals((Object)PosPrinterDev.ErrorCode.WriteDataSuccess)) {
                            PosprinterService.this.isConnected = true;
                            return true;
                        }
                        PosprinterService.this.isConnected = false;
                    }
                    return false;
                }
            });
            task.execute(new Void[0]);
        }

        @Override
        public void writeDataByYouself(UiExecute execute, final ProcessData processData) {
            PosAsynncTask task = new PosAsynncTask(execute, new BackgroundInit(){

                @Override
                public boolean doinbackground() {
                    List<byte[]> list = processData.processDataBeforeSend();
                    if (list != null) {
                        int i = 0;
                        while (i < list.size()) {
                            PosprinterService.this.mMsg = PosprinterService.this.xPrinterDev.Write(list.get(i));
                            ++i;
                        }
                        if (PosprinterService.this.mMsg.GetErrorCode().equals((Object)PosPrinterDev.ErrorCode.WriteDataSuccess)) {
                            PosprinterService.this.isConnected = true;
                            return true;
                        }
                        PosprinterService.this.isConnected = false;
                    }
                    return false;
                }
            });
            task.execute(new Void[0]);
        }

        @Override
        public void acceptdatafromprinter(UiExecute execute) {
            PosAsynncTask task = new PosAsynncTask(execute, new BackgroundInit(){

                @Override
                public boolean doinbackground() {
                    PosprinterService.this.que = PosprinterService.this.getinstaceRoundQueue();
                    byte[] buffer = new byte[4];
                    PosprinterService.this.que.clear();
                    Log.i((String)"TAG", (String)PosprinterService.this.xPrinterDev.Read(buffer).GetErrorCode().toString());
                    while (PosprinterService.this.xPrinterDev.Read(buffer).GetErrorCode().equals((Object)PosPrinterDev.ErrorCode.ReadDataSuccess)) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            return false;
                        }
                        PosprinterService.this.que.addLast(buffer);
                    }
                    PosprinterService.this.isConnected = false;
                    return false;
                }
            });
            task.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
        }

        @Override
        public RoundQueue<byte[]> readBuffer() {
            RoundQueue queue = new RoundQueue(500);
            queue = PosprinterService.this.que;
            return queue;
        }

        @Override
        public void clearBuffer() {
            PosprinterService.this.que.clear();
        }

        @Override
        public void checkLinkedState(UiExecute execute) {
            PosAsynncTask task = new PosAsynncTask(execute, new BackgroundInit(){

                @Override
                public boolean doinbackground() {
                    while (PosprinterService.this.isConnected) {
                        PosprinterService.this.isConnected = PosprinterService.this.xPrinterDev.GetPortInfo().PortIsOpen();
                    }
                    return false;
                }
            });
            task.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
        }
    }
}

