/*
 * Decompiled with CFR 0.152.
 */
package net.posprinter.utils;

import android.graphics.Bitmap;
import android.graphics.Matrix;

public class BitmapProcess {
    public static Bitmap compressBmpByPrinterWidth(Bitmap bitmap, PrinterWidth printerWidth) {
        Bitmap bitmapOrg = bitmap;
        Bitmap resizedBitmap = null;
        int width = bitmapOrg.getWidth();
        int height = bitmapOrg.getHeight();
        int w = 576;
        switch (printerWidth) {
            case Pos80: {
                w = 576;
                break;
            }
            case Pos76: {
                w = 508;
                break;
            }
            case Pos58: {
                w = 384;
                break;
            }
            default: {
                w = 576;
            }
        }
        if (width <= w) {
            return bitmapOrg;
        }
        int newWidth = w;
        int newHeight = height * w / width;
        float scaleWidth = (float)newWidth / (float)width;
        float scaleHeight = (float)newHeight / (float)height;
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        resizedBitmap = Bitmap.createBitmap((Bitmap)bitmapOrg, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
        return resizedBitmap;
    }

    public static Bitmap compressBmpByYourWidth(Bitmap bitmap, int w) {
        Bitmap bitmapOrg = bitmap;
        Bitmap resizedBitmap = null;
        int width = bitmapOrg.getWidth();
        int height = bitmapOrg.getHeight();
        if (width <= w) {
            return bitmapOrg;
        }
        int newWidth = w;
        int newHeight = height * w / width;
        float scaleWidth = (float)newWidth / (float)width;
        float scaleHeight = (float)newHeight / (float)height;
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        resizedBitmap = Bitmap.createBitmap((Bitmap)bitmapOrg, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
        return resizedBitmap;
    }

    public static Bitmap rotateBmp(Bitmap bitmap, RotateType rotateType) {
        Bitmap bitmapOrg = bitmap;
        Matrix matrix = new Matrix();
        float degrees = 0.0f;
        switch (rotateType) {
            case Rotate90: {
                degrees = 90.0f;
                break;
            }
            case Rotate180: {
                degrees = 180.0f;
                break;
            }
            case Rotate270: {
                degrees = 270.0f;
                break;
            }
        }
        matrix.postRotate(degrees);
        Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmapOrg, (int)0, (int)0, (int)bitmapOrg.getWidth(), (int)bitmapOrg.getHeight(), (Matrix)matrix, (boolean)true);
        return bitmap2;
    }

    static enum PrinterWidth {
        Pos80,
        Pos76,
        Pos58;

    }

    static enum RotateType {
        Rotate90,
        Rotate180,
        Rotate270;

    }
}

