/*
 * Decompiled with CFR 0.152.
 */
package net.posprinter.utils;

import android.app.PendingIntent;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.util.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Queue;
import java.util.UUID;

public class PosPrinterDev {
    private PortInfo mPortInfo = new PortInfo();
    private PrinterPort mPort = null;

    public PosPrinterDev(PortType portType, Context context) {
        this.mPortInfo.mPortType = portType;
        this.mPortInfo.mContext = context;
    }

    public PosPrinterDev(PortType portType, Context context, String usbPathName) {
        this.mPortInfo.mPortType = portType;
        this.mPortInfo.mContext = context;
        if (usbPathName.equals("") || usbPathName == null) {
            return;
        }
        this.mPortInfo.mUsbPathName = usbPathName;
    }

    public PosPrinterDev(PortType portType, String bluetoothID) {
        this.mPortInfo.mPortType = portType;
        this.mPortInfo.mBluetoothID = bluetoothID;
    }

    public PosPrinterDev(PortType portType, String ethernetIP, int ethernetPort) {
        this.mPortInfo.mPortType = portType;
        this.mPortInfo.mEthernetIP = ethernetIP;
        this.mPortInfo.mEthernetPort = ethernetPort;
    }

    private void ResetPar() {
        if (this.mPortInfo != null) {
            this.mPortInfo = null;
        }
        this.mPortInfo = new PortInfo();
        if (this.mPort != null) {
            this.mPort.ClosePort();
            this.mPort = null;
        }
    }

    public ReturnMessage Open() {
        ReturnMessage retVar = null;
        switch (this.mPortInfo.mPortType) {
            case USB: {
                if (this.mPortInfo.mUsbPathName.equals("")) {
                    retVar = this.Open(this.mPortInfo.mPortType, this.mPortInfo.mContext);
                    break;
                }
                retVar = this.Open(this.mPortInfo.mPortType, this.mPortInfo.mContext, this.mPortInfo.mUsbPathName);
                break;
            }
            case Ethernet: {
                retVar = this.Open(this.mPortInfo.mPortType, this.mPortInfo.mEthernetIP, this.mPortInfo.mEthernetPort);
                break;
            }
            case Bluetooth: {
                retVar = this.Open(this.mPortInfo.mPortType, this.mPortInfo.mBluetoothID);
                break;
            }
            default: {
                retVar = new ReturnMessage();
            }
        }
        return retVar;
    }

    private ReturnMessage Open(PortType portType, Context context) {
        this.ResetPar();
        if (portType != PortType.USB) {
            return new ReturnMessage(ErrorCode.OpenPortFailed, "Port type wrong !\n");
        }
        if (context == null) {
            return new ReturnMessage(ErrorCode.OpenPortFailed, "Context is null !\n");
        }
        this.mPortInfo.mContext = context;
        this.mPortInfo.mPortType = PortType.USB;
        this.mPortInfo.mUsbPathName = "";
        this.mPort = new UsbPort(this.mPortInfo);
        return this.mPort.OpenPort();
    }

    private ReturnMessage Open(PortType portType, Context context, String usbPathName) {
        this.ResetPar();
        if (portType != PortType.USB) {
            return new ReturnMessage(ErrorCode.OpenPortFailed, "Port type wrong !\n");
        }
        if (context == null) {
            return new ReturnMessage(ErrorCode.OpenPortFailed, "Context is null !\n");
        }
        if (usbPathName == null) {
            return new ReturnMessage(ErrorCode.OpenPortFailed, "usbPathName is null !\n");
        }
        this.mPortInfo.mContext = context;
        this.mPortInfo.mPortType = PortType.USB;
        this.mPortInfo.mUsbPathName = usbPathName;
        this.mPort = new UsbPort(this.mPortInfo);
        return this.mPort.OpenPort();
    }

    private ReturnMessage Open(PortType portType, String bluetoothID) {
        this.ResetPar();
        if (portType != PortType.Bluetooth) {
            return new ReturnMessage(ErrorCode.OpenPortFailed, "Port type wrong !\n");
        }
        if (!BluetoothAdapter.checkBluetoothAddress((String)bluetoothID)) {
            return new ReturnMessage(ErrorCode.OpenPortFailed, "BluetoothID wrong !\n");
        }
        this.mPortInfo.mBluetoothID = bluetoothID;
        this.mPortInfo.mPortType = PortType.Bluetooth;
        this.mPort = new BluetoothPort(this.mPortInfo);
        return this.mPort.OpenPort();
    }

    private ReturnMessage Open(PortType portType, String ethernetIP, int ethernetPort) {
        this.ResetPar();
        if (portType != PortType.Ethernet) {
            return new ReturnMessage(ErrorCode.OpenPortFailed, "Port type wrong !\n");
        }
        try {
            Inet4Address.getByName(ethernetIP);
        }
        catch (Exception e) {
            return new ReturnMessage(ErrorCode.OpenPortFailed, "Ethernet ip wrong !\n");
        }
        if (ethernetPort <= 0) {
            return new ReturnMessage(ErrorCode.OpenPortFailed, "Ethernet port wrong !\n");
        }
        this.mPortInfo.mEthernetPort = ethernetPort;
        this.mPortInfo.mEthernetIP = ethernetIP;
        this.mPortInfo.mPortType = PortType.Ethernet;
        this.mPort = new EthernetPort(this.mPortInfo);
        NetConnectThread connectNet = new NetConnectThread(this.mPort);
        connectNet.start();
        while (connectNet.returnMessage == null) {
        }
        return connectNet.returnMessage;
    }

    public ReturnMessage Write(int data) {
        return this.mPort.Write(data &= 0xFF);
    }

    public ReturnMessage Write(byte[] data) {
        return this.mPort.Write(data);
    }

    public ReturnMessage Write(byte[] data, int offset, int count) {
        return this.mPort.Write(data, offset, count);
    }

    public ReturnMessage Read(byte[] buffer) {
        return this.Read(buffer, 0, buffer.length);
    }

    public ReturnMessage Read(byte[] buffer, int offset, int count) {
        ReturnMessage retvar = null;
        switch (this.mPort.mPortInfo.mPortType) {
            case Ethernet: {
                NetReadThread netReadThread = new NetReadThread(this.mPort, buffer, offset, count);
                netReadThread.start();
                while (netReadThread.returnMessage == null) {
                }
                retvar = netReadThread.returnMessage;
                break;
            }
            default: {
                retvar = this.mPort.Read(buffer, offset, count);
            }
        }
        return retvar;
    }

    public int Read() {
        byte[] tem = new byte[1];
        if (this.Read(tem, 0, 1).mErrorCode == ErrorCode.ReadDataSuccess) {
            return tem[0];
        }
        return -1;
    }

    public synchronized ReturnMessage Close() {
        if (this.mPort == null) {
            return new ReturnMessage(ErrorCode.ClosePortFailed, "Not opened port !");
        }
        return this.mPort.ClosePort();
    }

    private static boolean CheckUsbVid(UsbDevice usbDevice) {
        int[] xprinterUsbID = new int[]{1659, 1046, 7358, 1155, 8137, 1003, 11575, 1208};
        int vid = usbDevice.getVendorId();
        int[] nArray = xprinterUsbID;
        int n = xprinterUsbID.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            if (vid == id) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static List<String> GetUsbPathNames(Context context) {
        ArrayList<String> usbNames = new ArrayList<String>();
        UsbManager usbManager = (UsbManager)context.getSystemService("usb");
        HashMap usbList = usbManager.getDeviceList();
        block0: for (UsbDevice device : usbList.values()) {
            int iInterface = 0;
            while (iInterface < device.getInterfaceCount()) {
                if (device.getInterface(iInterface).getInterfaceClass() == 7 && device.getInterface(iInterface).getInterfaceSubclass() == 1 && PosPrinterDev.CheckUsbVid(device)) {
                    usbNames.add(device.getDeviceName());
                    continue block0;
                }
                ++iInterface;
            }
        }
        if (usbNames.size() == 0) {
            usbNames = null;
        }
        return usbNames;
    }

    public PortInfo GetPortInfo() {
        this.mPortInfo.mIsOpened = this.mPort.PortIsOpen();
        return this.mPortInfo;
    }

    private class BluetoothPort
    extends PrinterPort {
        private final UUID SPP_UUID;
        private BluetoothAdapter mBtAdapter;
        private BluetoothDevice mBtDevice;
        private BluetoothSocket mBtSocket;
        private OutputStream mOutPut;
        private InputStream mInPut;

        public BluetoothPort(PortInfo portInfo) {
            super(portInfo);
            this.SPP_UUID = UUID.fromString("00001101-0000-1000-8000-00805F9B34FB");
            this.mBtAdapter = null;
            this.mBtDevice = null;
            this.mBtSocket = null;
            this.mOutPut = null;
            this.mInPut = null;
            if (portInfo.mPortType != PortType.Bluetooth || !BluetoothAdapter.checkBluetoothAddress((String)portInfo.mBluetoothID)) {
                this.mPortInfo.mParIsOK = false;
                return;
            }
            this.mPortInfo.mParIsOK = true;
            this.mBtAdapter = BluetoothAdapter.getDefaultAdapter();
        }

        @Override
        ReturnMessage OpenPort() {
            if (!this.mPortInfo.mParIsOK) {
                return new ReturnMessage(ErrorCode.OpenPortFailed, "PortInfo error !\n");
            }
            try {
                if (this.mBtAdapter == null) {
                    return new ReturnMessage(ErrorCode.OpenPortFailed, "Not Bluetooth adapter !\n");
                }
                if (!this.mBtAdapter.isEnabled()) {
                    return new ReturnMessage(ErrorCode.OpenPortFailed, "Bluetooth adapter was closed !\n");
                }
                this.mBtAdapter.cancelDiscovery();
                this.mBtDevice = this.mBtAdapter.getRemoteDevice(this.mPortInfo.mBluetoothID);
                this.mBtSocket = this.mBtDevice.createRfcommSocketToServiceRecord(this.SPP_UUID);
                this.mBtSocket.connect();
                this.mOutPut = null;
                this.mOutPut = this.mBtSocket.getOutputStream();
                this.mInPut = null;
                this.mInPut = this.mBtSocket.getInputStream();
                this.mIsOpen = true;
            }
            catch (Exception e) {
                return new ReturnMessage(ErrorCode.OpenPortFailed, e.toString());
            }
            return new ReturnMessage(ErrorCode.OpenPortSuccess, "Open bluetooth port success !\n");
        }

        @Override
        ReturnMessage ClosePort() {
            try {
                if (this.mOutPut != null) {
                    this.mOutPut.flush();
                }
                if (this.mBtSocket != null) {
                    this.mBtSocket.close();
                }
                this.mIsOpen = false;
                this.mOutPut = null;
                this.mInPut = null;
            }
            catch (Exception e) {
                return new ReturnMessage(ErrorCode.ClosePortFailed, e.toString());
            }
            return new ReturnMessage(ErrorCode.ClosePortSuccess, "Close bluetooth port success !\n");
        }

        @Override
        ReturnMessage Write(int data) {
            if (this.mIsOpen && this.mBtSocket.isConnected() && this.mOutPut != null) {
                try {
                    this.mOutPut.write(data);
                }
                catch (Exception e) {
                    this.ClosePort();
                    return new ReturnMessage(ErrorCode.WriteDataFailed, e.toString());
                }
            } else {
                return new ReturnMessage(ErrorCode.WriteDataFailed, "bluetooth port was close !\n");
            }
            return new ReturnMessage(ErrorCode.WriteDataSuccess, "Send 1 byte .\n", 1);
        }

        @Override
        ReturnMessage Write(byte[] data) {
            if (this.mIsOpen && this.mBtSocket.isConnected() && this.mOutPut != null) {
                try {
                    this.mOutPut.write(data);
                }
                catch (Exception e) {
                    this.ClosePort();
                    return new ReturnMessage(ErrorCode.WriteDataFailed, e.toString());
                }
            } else {
                return new ReturnMessage(ErrorCode.WriteDataFailed, "bluetooth port was close !\n");
            }
            return new ReturnMessage(ErrorCode.WriteDataSuccess, "Send " + data.length + " bytes .\n", data.length);
        }

        @Override
        ReturnMessage Write(byte[] data, int offset, int count) {
            if (this.mIsOpen && this.mBtSocket.isConnected() && this.mOutPut != null) {
                try {
                    this.mOutPut.write(data, offset, count);
                }
                catch (Exception e) {
                    return new ReturnMessage(ErrorCode.WriteDataFailed, e.toString());
                }
            } else {
                this.ClosePort();
                return new ReturnMessage(ErrorCode.WriteDataFailed, "bluetooth port was close !\n");
            }
            return new ReturnMessage(ErrorCode.WriteDataSuccess, "Send " + count + " bytes .\n", count);
        }

        @Override
        ReturnMessage Read(byte[] buffer, int offset, int count) {
            int readBytes = -1;
            if (this.mIsOpen && this.mBtSocket.isConnected() && this.mInPut != null) {
                try {
                    readBytes = this.mInPut.read(buffer, offset, count);
                }
                catch (Exception e) {
                    return new ReturnMessage(ErrorCode.ReadDataFailed, e.toString());
                }
            } else {
                this.ClosePort();
                return new ReturnMessage(ErrorCode.ReadDataFailed, "bluetooth port was close !\n");
            }
            return new ReturnMessage(ErrorCode.ReadDataSuccess, "Read " + count + " bytes .\n", readBytes);
        }

        @Override
        ReturnMessage Read(byte[] buffer) {
            return this.Read(buffer, 0, buffer.length);
        }

        @Override
        int Read() {
            if (this.mIsOpen && this.mBtSocket.isConnected() && this.mInPut != null) {
                try {
                    return this.mInPut.read();
                }
                catch (Exception e) {
                    return -1;
                }
            }
            return -1;
        }

        @Override
        boolean PortIsOpen() {
            byte[] b = new byte[4];
            ReturnMessage msg = this.Read(b);
            this.mIsOpen = msg.GetReadByteCount() != -1;
            return this.mIsOpen;
        }
    }

    public static enum ErrorCode {
        OpenPortFailed,
        OpenPortSuccess,
        ClosePortFailed,
        ClosePortSuccess,
        WriteDataFailed,
        WriteDataSuccess,
        ReadDataSuccess,
        ReadDataFailed,
        UnknownError;

    }

    private class EthernetPort
    extends PrinterPort {
        private InetAddress mInetAddr;
        private SocketAddress mSocketAddr;
        private Socket mNetSocket;
        private OutputStream mOutput;
        private InputStream mInput;
        private Process p;

        public EthernetPort(PortInfo portInfo) {
            super(portInfo);
            this.mNetSocket = new Socket();
            if (portInfo.mPortType == PortType.Ethernet && portInfo.mEthernetPort > 0) {
                try {
                    this.mInetAddr = Inet4Address.getByName(portInfo.mEthernetIP);
                    this.mPortInfo.mParIsOK = true;
                }
                catch (Exception e) {
                    this.mPortInfo.mParIsOK = false;
                }
            } else {
                this.mPortInfo.mParIsOK = false;
            }
        }

        @Override
        ReturnMessage OpenPort() {
            if (!this.mPortInfo.mParIsOK) {
                return new ReturnMessage(ErrorCode.OpenPortFailed, "PortInfo error !\n");
            }
            try {
                this.mSocketAddr = new InetSocketAddress(this.mInetAddr, this.mPortInfo.mEthernetPort);
                this.mNetSocket.connect(this.mSocketAddr, 3000);
                if (this.mOutput != null) {
                    this.mOutput = null;
                }
                this.mOutput = this.mNetSocket.getOutputStream();
                if (this.mInput != null) {
                    this.mInput = null;
                }
                this.mInput = this.mNetSocket.getInputStream();
                this.mIsOpen = true;
            }
            catch (Exception e) {
                return new ReturnMessage(ErrorCode.OpenPortFailed, e.toString());
            }
            return new ReturnMessage(ErrorCode.OpenPortSuccess, "Open ethernet port success !\n");
        }

        @Override
        ReturnMessage ClosePort() {
            try {
                if (this.mOutput != null) {
                    this.mOutput.flush();
                }
                if (this.mNetSocket != null) {
                    this.mNetSocket.close();
                }
                this.mIsOpen = false;
                this.mOutput = null;
                this.mInput = null;
            }
            catch (Exception e) {
                return new ReturnMessage(ErrorCode.ClosePortFailed, e.toString());
            }
            return new ReturnMessage(ErrorCode.ClosePortSuccess, "Close ethernet port success !\n");
        }

        @Override
        ReturnMessage Write(int data) {
            if (this.mIsOpen && this.mOutput != null && this.mNetSocket.isConnected()) {
                try {
                    this.mOutput.write(data);
                }
                catch (Exception e) {
                    return new ReturnMessage(ErrorCode.WriteDataFailed, e.toString());
                }
            } else {
                return new ReturnMessage(ErrorCode.WriteDataFailed, "Ethernet port was close !\n");
            }
            return new ReturnMessage(ErrorCode.WriteDataSuccess, "Send 1 byte .\n", 1);
        }

        @Override
        ReturnMessage Write(byte[] data) {
            if (this.mIsOpen && this.mOutput != null && this.mNetSocket.isConnected()) {
                try {
                    this.mOutput.write(data);
                }
                catch (Exception e) {
                    return new ReturnMessage(ErrorCode.WriteDataFailed, e.toString());
                }
            } else {
                return new ReturnMessage(ErrorCode.WriteDataFailed, "Ethernet port was close !\n");
            }
            return new ReturnMessage(ErrorCode.WriteDataSuccess, "Send " + data.length + " bytes .\n", data.length);
        }

        @Override
        ReturnMessage Write(byte[] data, int offset, int count) {
            if (this.mIsOpen && this.mOutput != null && this.mNetSocket.isConnected()) {
                try {
                    this.mOutput.write(data, offset, count);
                }
                catch (Exception e) {
                    return new ReturnMessage(ErrorCode.WriteDataFailed, e.toString());
                }
            } else {
                return new ReturnMessage(ErrorCode.WriteDataFailed, "Ethernet port was close !\n");
            }
            return new ReturnMessage(ErrorCode.WriteDataSuccess, "Send " + count + " bytes .\n", count);
        }

        @Override
        ReturnMessage Read(byte[] buffer, int offset, int count) {
            int readBytes;
            block4: {
                readBytes = -1;
                if (this.mIsOpen && this.mInput != null && this.mNetSocket.isConnected()) {
                    try {
                        readBytes = this.mInput.read(buffer, offset, count);
                        if (readBytes == -1) {
                            return new ReturnMessage(ErrorCode.ReadDataFailed, "Ethernet port was close !\n");
                        }
                        break block4;
                    }
                    catch (Exception e) {
                        return new ReturnMessage(ErrorCode.ReadDataFailed, e.toString());
                    }
                }
                return new ReturnMessage(ErrorCode.ReadDataFailed, "Ethernet port was close !\n");
            }
            return new ReturnMessage(ErrorCode.ReadDataSuccess, "Read " + count + " bytes .\n", readBytes);
        }

        @Override
        ReturnMessage Read(byte[] buffer) {
            return this.Read(buffer, 0, buffer.length);
        }

        @Override
        int Read() {
            if (this.mIsOpen && this.mNetSocket.isConnected() && this.mInput != null) {
                try {
                    return this.mInput.read();
                }
                catch (Exception e) {
                    return -1;
                }
            }
            return -1;
        }

        @Override
        boolean PortIsOpen() {
            this.mIsOpen = this.pingHost(this.mPortInfo.mEthernetIP);
            if (!this.mIsOpen) {
                this.mIsOpen = this.pingHost(this.mPortInfo.mEthernetIP);
            }
            return this.mIsOpen;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean pingHost(String str) {
            boolean result = false;
            BufferedReader bufferedReader = null;
            try {
                try {
                    Thread.sleep(2000L);
                    this.p = Runtime.getRuntime().exec("ping -c 1 -w 5 " + str);
                    InputStream ins = this.p.getInputStream();
                    InputStreamReader reader = new InputStreamReader(ins);
                    bufferedReader = new BufferedReader(reader);
                    String line = null;
                    while ((line = bufferedReader.readLine()) != null) {
                    }
                    int status = this.p.waitFor();
                    result = status == 0;
                    return result;
                }
                catch (IOException e) {
                    result = false;
                    if (this.p != null) {
                        this.p.destroy();
                    }
                    if (bufferedReader == null) return result;
                    try {
                        bufferedReader.close();
                        return result;
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    return result;
                }
                catch (InterruptedException e) {
                    result = false;
                    if (this.p != null) {
                        this.p.destroy();
                    }
                    if (bufferedReader == null) return result;
                    try {
                        bufferedReader.close();
                        return result;
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                    return result;
                }
            }
            finally {
                if (this.p != null) {
                    this.p.destroy();
                }
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private class NetConnectThread
    extends Thread {
        public ReturnMessage returnMessage = null;
        private PrinterPort mTemPort = null;

        public NetConnectThread(PrinterPort port) {
            this.mTemPort = port;
        }

        @Override
        public void run() {
            this.returnMessage = this.mTemPort.OpenPort();
        }
    }

    private class NetReadThread
    extends Thread {
        public ReturnMessage returnMessage = null;
        private PrinterPort mTemPort = null;
        public byte[] reBuffer = null;
        public int reOffset = 0;
        public int reCount = 0;

        public NetReadThread(PrinterPort port, byte[] buffer, int offset, int count) {
            this.mTemPort = port;
            this.reBuffer = buffer;
            this.reOffset = offset;
            this.reCount = count;
        }

        @Override
        public void run() {
            this.returnMessage = this.mTemPort.Read(this.reBuffer, this.reOffset, this.reCount);
        }
    }

    public class PortInfo {
        private PortType mPortType = PortType.Unknown;
        private String mUsbPathName = "";
        private int mUsbPid = 0;
        private int mUsbVid = 0;
        private int mEthernetPort = 0;
        private String mEthernetIP = "";
        private String mBluetoothID = "";
        private boolean mParIsOK = false;
        private Context mContext = null;
        private boolean mIsOpened = false;

        public PortType GetPortType() {
            return this.mPortType;
        }

        public String GetPortName() {
            return this.mPortType.name();
        }

        public String GetUsbPathName() {
            return this.mUsbPathName;
        }

        public int GetUsbVid() {
            return this.mUsbVid;
        }

        public int GetUsbPid() {
            return this.mUsbPid;
        }

        public int GetEthernetPort() {
            return this.mEthernetPort;
        }

        public String GetEthernetIP() {
            return this.mEthernetIP;
        }

        public String GetBluetoothID() {
            return this.mBluetoothID;
        }

        public boolean PortIsOpen() {
            return this.mIsOpened;
        }
    }

    public static enum PortType {
        Unknown,
        USB,
        Bluetooth,
        Ethernet;

    }

    private abstract class PrinterPort {
        protected PortInfo mPortInfo = null;
        protected Queue<Byte> mRxdQueue = null;
        protected Queue<Byte> mTxdQueue = null;
        protected boolean mIsOpen = false;

        abstract ReturnMessage OpenPort();

        abstract ReturnMessage ClosePort();

        abstract ReturnMessage Write(int var1);

        abstract ReturnMessage Write(byte[] var1);

        abstract ReturnMessage Write(byte[] var1, int var2, int var3);

        abstract ReturnMessage Read(byte[] var1, int var2, int var3);

        abstract ReturnMessage Read(byte[] var1);

        abstract int Read();

        abstract boolean PortIsOpen();

        public PrinterPort(PortInfo portInfo) {
            this.mPortInfo = portInfo;
        }

        public int GetRxdCount() {
            if (this.mRxdQueue != null) {
                return this.mRxdQueue.size();
            }
            return 0;
        }

        public int GetTxdCount() {
            if (this.mTxdQueue != null) {
                return this.mTxdQueue.size();
            }
            return 0;
        }
    }

    public class ReturnMessage {
        private ErrorCode mErrorCode;
        private String mErrorStrings;
        private int mReadBytes = -1;
        private int mWriteBytes = -1;

        public ReturnMessage() {
            this.mErrorCode = ErrorCode.UnknownError;
            this.mErrorStrings = "Unknown error\n";
            this.mReadBytes = -1;
            this.mWriteBytes = -1;
        }

        private ReturnMessage(ErrorCode ec, String es) {
            this.mErrorCode = ec;
            this.mErrorStrings = es;
        }

        private ReturnMessage(ErrorCode ec, String es, int count) {
            this.mErrorCode = ec;
            this.mErrorStrings = es;
            switch (ec) {
                case WriteDataSuccess: {
                    this.mWriteBytes = count;
                    break;
                }
                case ReadDataSuccess: {
                    this.mReadBytes = count;
                    break;
                }
            }
        }

        public ErrorCode GetErrorCode() {
            return this.mErrorCode;
        }

        public String GetErrorStrings() {
            return this.mErrorStrings;
        }

        public int GetReadByteCount() {
            return this.mReadBytes;
        }

        public int GetWriteByteCount() {
            return this.mWriteBytes;
        }
    }

    private class UsbPort
    extends PrinterPort {
        private UsbManager mUsbManager;
        private UsbDevice mUsbDevice;
        private UsbInterface mUsbInterface;
        private UsbDeviceConnection mUsbDeviceConnection;
        private UsbEndpoint mUsbInEndpoint;
        private UsbEndpoint mUsbOutEndpoint;
        private PendingIntent mPermissionIntent;
        private String mUserUsbName;
        private String ACTION_USB_PERMISSION;
        private boolean mPermissioning;
        private final BroadcastReceiver mUsbReceiver;

        public UsbPort(PortInfo portInfo) {
            super(portInfo);
            this.mUsbManager = null;
            this.mUsbDevice = null;
            this.mUsbInterface = null;
            this.mUsbDeviceConnection = null;
            this.mUsbInEndpoint = null;
            this.mUsbOutEndpoint = null;
            this.mPermissionIntent = null;
            this.mUserUsbName = null;
            this.ACTION_USB_PERMISSION = "net.xprinter.xprintersdk.USB_PERMISSION";
            this.mPermissioning = true;
            this.mUsbReceiver = new BroadcastReceiver(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onReceive(Context context, Intent intent) {
                    String action = intent.getAction();
                    if (UsbPort.this.ACTION_USB_PERMISSION.equals(action)) {
                        Log.d((String)"onReceive id is", (String)("" + Thread.currentThread().getId()));
                        UsbPort.this.mPermissioning = false;
                        1 var4_4 = this;
                        synchronized (var4_4) {
                            UsbDevice device = (UsbDevice)intent.getParcelableExtra("device");
                            if (intent.getBooleanExtra("permission", false) && device != null) {
                                UsbPort.this.mUsbDevice = device;
                            }
                        }
                    }
                }
            };
            if (portInfo.mPortType != PortType.USB && portInfo.mContext != null && portInfo.mUsbPathName.equals("")) {
                this.mPortInfo.mParIsOK = false;
            } else {
                this.mPortInfo.mParIsOK = true;
                if (this.mPortInfo.mUsbPathName != null && !portInfo.mUsbPathName.equals("")) {
                    this.mUserUsbName = this.mPortInfo.mUsbPathName;
                }
            }
        }

        private List<UsbDevice> GetUsbDeviceList() {
            ArrayList<UsbDevice> temList = new ArrayList<UsbDevice>();
            this.mUsbManager = (UsbManager)this.mPortInfo.mContext.getSystemService("usb");
            HashMap deviceList = this.mUsbManager.getDeviceList();
            block0: for (UsbDevice device : deviceList.values()) {
                int iInterface = 0;
                while (iInterface < device.getInterfaceCount()) {
                    if (device.getInterface(iInterface).getInterfaceClass() == 7 && device.getInterface(iInterface).getInterfaceSubclass() == 1 && PosPrinterDev.CheckUsbVid(device)) {
                        temList.add(device);
                        continue block0;
                    }
                    ++iInterface;
                }
            }
            if (temList.size() == 0) {
                return null;
            }
            return temList;
        }

        @Override
        ReturnMessage OpenPort() {
            if (!this.mPortInfo.mParIsOK) {
                return new ReturnMessage(ErrorCode.OpenPortFailed, "PortInfo error !\n");
            }
            List<UsbDevice> temDevList = this.GetUsbDeviceList();
            if (temDevList == null) {
                return new ReturnMessage(ErrorCode.OpenPortFailed, "Not find XPrinter's USB printer !\n");
            }
            this.mUsbDevice = null;
            if (this.mUserUsbName == null) {
                if (this.mUsbManager.hasPermission(temDevList.get(0))) {
                    this.mUsbDevice = temDevList.get(0);
                } else {
                    this.mPermissionIntent = PendingIntent.getBroadcast((Context)this.mPortInfo.mContext, (int)0, (Intent)new Intent(this.ACTION_USB_PERMISSION), (int)0);
                    IntentFilter filter = new IntentFilter(this.ACTION_USB_PERMISSION);
                    filter.addAction("android.hardware.usb.action.USB_DEVICE_ATTACHED");
                    filter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
                    filter.addAction("android.hardware.usb.action.USB_ACCESSORY_ATTACHED");
                    filter.addAction("android.hardware.usb.action.USB_ACCESSORY_DETACHED");
                    this.mPortInfo.mContext.registerReceiver(this.mUsbReceiver, filter);
                    this.mUsbManager.requestPermission(temDevList.get(0), this.mPermissionIntent);
                }
            } else {
                boolean isEq = false;
                for (UsbDevice dev : temDevList) {
                    if (!dev.getDeviceName().equals(this.mUserUsbName)) continue;
                    if (this.mUsbManager.hasPermission(dev)) {
                        this.mUsbDevice = dev;
                    } else {
                        this.mPermissionIntent = PendingIntent.getBroadcast((Context)this.mPortInfo.mContext, (int)0, (Intent)new Intent(this.ACTION_USB_PERMISSION), (int)0);
                        IntentFilter filter = new IntentFilter(this.ACTION_USB_PERMISSION);
                        filter.addAction("android.hardware.usb.action.USB_DEVICE_ATTACHED");
                        filter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
                        filter.addAction("android.hardware.usb.action.USB_ACCESSORY_ATTACHED");
                        filter.addAction("android.hardware.usb.action.USB_ACCESSORY_DETACHED");
                        this.mPortInfo.mContext.registerReceiver(this.mUsbReceiver, filter);
                        this.mUsbManager.requestPermission(dev, this.mPermissionIntent);
                    }
                    isEq = true;
                    break;
                }
                if (!isEq) {
                    return new ReturnMessage(ErrorCode.OpenPortFailed, "Not find " + this.mUserUsbName + " !\n");
                }
            }
            Log.d((String)"open id is", (String)("" + Thread.currentThread().getId()));
            if (this.mUsbDevice == null) {
                return new ReturnMessage(ErrorCode.OpenPortFailed, "Get USB communication permission failed !\n");
            }
            int iInterface = 0;
            while (iInterface < this.mUsbDevice.getInterfaceCount()) {
                if (this.mUsbDevice.getInterface(iInterface).getInterfaceClass() == 7) {
                    int iEndpoint = 0;
                    while (iEndpoint < this.mUsbDevice.getInterface(iInterface).getEndpointCount()) {
                        if (this.mUsbDevice.getInterface(iInterface).getEndpoint(iEndpoint).getType() == 2) {
                            if (this.mUsbDevice.getInterface(iInterface).getEndpoint(iEndpoint).getDirection() == 128) {
                                this.mUsbInEndpoint = this.mUsbDevice.getInterface(iInterface).getEndpoint(iEndpoint);
                            } else {
                                this.mUsbOutEndpoint = this.mUsbDevice.getInterface(iInterface).getEndpoint(iEndpoint);
                            }
                        }
                        if (this.mUsbInEndpoint != null && this.mUsbOutEndpoint != null) break;
                        ++iEndpoint;
                    }
                    this.mUsbInterface = this.mUsbDevice.getInterface(iInterface);
                    break;
                }
                ++iInterface;
            }
            this.mUsbDeviceConnection = this.mUsbManager.openDevice(this.mUsbDevice);
            if (this.mUsbDeviceConnection != null && this.mUsbDeviceConnection.claimInterface(this.mUsbInterface, true)) {
                this.mPortInfo.mUsbPathName = this.mUsbDevice.getDeviceName();
                this.mIsOpen = true;
                return new ReturnMessage(ErrorCode.OpenPortSuccess, "Open USB port success !\n");
            }
            return new ReturnMessage(ErrorCode.OpenPortFailed, "Can't Claims exclusive access to UsbInterface");
        }

        @Override
        ReturnMessage ClosePort() {
            if (this.mUsbDeviceConnection != null) {
                this.mUsbInEndpoint = null;
                this.mUsbOutEndpoint = null;
                this.mUsbDeviceConnection.releaseInterface(this.mUsbInterface);
                this.mUsbDeviceConnection.close();
                this.mUsbDeviceConnection = null;
            }
            this.mIsOpen = false;
            return new ReturnMessage(ErrorCode.ClosePortSuccess, "Close usb connection success !\n");
        }

        @Override
        ReturnMessage Write(int data) {
            byte[] tem = new byte[]{(byte)(data & 0xFF)};
            return this.Write(tem);
        }

        @Override
        ReturnMessage Write(byte[] data) {
            return this.Write(data, 0, data.length);
        }

        @Override
        ReturnMessage Write(byte[] data, int offset, int count) {
            if (!this.mIsOpen) {
                return new ReturnMessage(ErrorCode.WriteDataFailed, "USB port was closed !\n");
            }
            byte[] temData = new byte[count];
            int i = offset;
            while (i < offset + count) {
                temData[i - offset] = data[i];
                ++i;
            }
            int writeCount = this.mUsbDeviceConnection.bulkTransfer(this.mUsbOutEndpoint, temData, temData.length, 3000);
            if (writeCount < 0) {
                return new ReturnMessage(ErrorCode.WriteDataFailed, "usb port write bulkTransfer failed !\n");
            }
            return new ReturnMessage(ErrorCode.WriteDataSuccess, "send " + writeCount + " bytes.\n", writeCount);
        }

        @Override
        ReturnMessage Read(byte[] buffer, int offset, int count) {
            if (!this.mIsOpen) {
                return new ReturnMessage(ErrorCode.ReadDataFailed, "USB port was closed !\n");
            }
            int readBytes = -1;
            byte[] temBuffer = new byte[count];
            readBytes = this.mUsbDeviceConnection.bulkTransfer(this.mUsbInEndpoint, buffer, count, 3000);
            if (readBytes < 0) {
                return new ReturnMessage(ErrorCode.ReadDataFailed, "usb port read bulkTransfer failed !\n");
            }
            int i = offset;
            while (i < offset + readBytes) {
                buffer[i] = temBuffer[i - offset];
                ++i;
            }
            return new ReturnMessage(ErrorCode.ReadDataSuccess, "Read " + readBytes + " bytes.\n", readBytes);
        }

        @Override
        ReturnMessage Read(byte[] buffer) {
            return this.Read(buffer, 0, buffer.length);
        }

        @Override
        int Read() {
            byte[] temBuffer = new byte[1];
            if (this.Read(temBuffer).GetErrorCode() == ErrorCode.OpenPortFailed) {
                return -1;
            }
            return temBuffer[0];
        }

        @Override
        boolean PortIsOpen() {
            if (this.mUsbDevice == null || this.mUsbInEndpoint == null || this.mUsbOutEndpoint == null) {
                this.mIsOpen = false;
                return false;
            }
            List<Object> temStr = new ArrayList();
            temStr = PosPrinterDev.GetUsbPathNames(this.mPortInfo.mContext);
            if (temStr == null || temStr.size() <= 0) {
                this.mIsOpen = false;
                return false;
            }
            for (String string : temStr) {
                if (!string.equals(this.mUsbDevice.getDeviceName())) continue;
                this.mIsOpen = true;
                return true;
            }
            this.mIsOpen = false;
            return false;
        }
    }
}

