/*
 * Decompiled with CFR 0.152.
 */
package com.zxy.tiny.callable;

import android.graphics.Bitmap;
import android.net.Uri;
import com.zxy.tiny.Tiny;
import com.zxy.tiny.callable.BaseFileBatchCompressCallable;
import com.zxy.tiny.callable.BaseFileCompressCallable;
import com.zxy.tiny.common.BatchCompressResult;
import com.zxy.tiny.common.CompressResult;
import com.zxy.tiny.common.TinyException;
import com.zxy.tiny.common.UriUtil;
import com.zxy.tiny.core.CompressKit;
import com.zxy.tiny.core.FileCompressor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileCompressCallableTasks {
    private FileCompressCallableTasks() {
        throw new TinyException.UnsupportedOperationException("can not be a instance");
    }

    private static String[] getBatchOutfilePaths(Tiny.FileCompressOptions options, int length) {
        if (options == null || length <= 0) {
            return null;
        }
        String[] outfilePaths = null;
        if (options instanceof Tiny.BatchFileCompressOptions) {
            Tiny.BatchFileCompressOptions compressOptions = (Tiny.BatchFileCompressOptions)options;
            String[] outfiles = compressOptions.outfiles;
            if (outfiles != null && outfiles.length > 0) {
                outfilePaths = new String[length];
                if (outfiles.length >= length) {
                    System.arraycopy(outfiles, 0, outfilePaths, 0, length);
                } else {
                    for (int i = 0; i < length; ++i) {
                        try {
                            outfilePaths[i] = outfiles[i];
                            continue;
                        }
                        catch (Exception e) {
                            outfilePaths[i] = null;
                        }
                    }
                }
            }
        } else {
            options.outfile = null;
        }
        return outfilePaths;
    }

    public static final class ResourceArrayAsFileCallable
    extends BaseFileBatchCompressCallable {
        private int[] mResIds;

        public ResourceArrayAsFileCallable(Tiny.FileCompressOptions options, boolean withBitmap, int[] resIds) {
            super(options, withBitmap);
            this.mResIds = resIds;
        }

        @Override
        public BatchCompressResult call() throws Exception {
            if (this.mResIds == null) {
                return null;
            }
            BatchCompressResult result = new BatchCompressResult();
            result.results = new CompressResult[this.mResIds.length];
            String[] outfilePaths = FileCompressCallableTasks.getBatchOutfilePaths(this.mCompressOptions, this.mResIds.length);
            for (int i = 0; i < this.mResIds.length; ++i) {
                CompressResult compressResult;
                Bitmap bitmap = FileCompressor.shouldKeepSampling(this.mResIds[i], this.mCompressOptions);
                if (this.mCompressOptions != null && outfilePaths != null && outfilePaths.length == this.mResIds.length) {
                    this.mCompressOptions.outfile = outfilePaths[i];
                }
                if ((compressResult = FileCompressor.compress(bitmap, this.mCompressOptions, this.shouldReturnBitmap, true)) != null) {
                    result.success = true;
                }
                result.results[i] = compressResult;
            }
            return result;
        }
    }

    public static final class UriArrayAsFileCallable
    extends BaseFileBatchCompressCallable {
        private Uri[] mUris;

        public UriArrayAsFileCallable(Tiny.FileCompressOptions options, boolean withBitmap, Uri[] uris) {
            super(options, withBitmap);
            this.mUris = uris;
        }

        @Override
        public BatchCompressResult call() throws Exception {
            if (this.mUris == null) {
                return null;
            }
            BatchCompressResult result = new BatchCompressResult();
            result.results = new CompressResult[this.mUris.length];
            String[] outfilePaths = FileCompressCallableTasks.getBatchOutfilePaths(this.mCompressOptions, this.mUris.length);
            for (int i = 0; i < this.mUris.length; ++i) {
                CompressResult compressResult;
                Uri uri = this.mUris[i];
                if (uri == null) {
                    result.results[i] = null;
                    continue;
                }
                if (this.mCompressOptions != null && outfilePaths != null && outfilePaths.length == this.mUris.length) {
                    this.mCompressOptions.outfile = outfilePaths[i];
                }
                if ((compressResult = new UriAsFileCallable(this.mCompressOptions, this.shouldReturnBitmap, uri).call()) != null) {
                    result.success = true;
                }
                result.results[i] = compressResult;
            }
            return result;
        }
    }

    public static final class BitmapArrayAsFileCallable
    extends BaseFileBatchCompressCallable {
        private Bitmap[] mBitmaps;

        public BitmapArrayAsFileCallable(Tiny.FileCompressOptions options, boolean withBitmap, Bitmap[] bitmaps) {
            super(options, withBitmap);
            this.mBitmaps = bitmaps;
        }

        @Override
        public BatchCompressResult call() throws Exception {
            if (this.mBitmaps == null) {
                return null;
            }
            BatchCompressResult result = new BatchCompressResult();
            result.results = new CompressResult[this.mBitmaps.length];
            String[] outfilePaths = FileCompressCallableTasks.getBatchOutfilePaths(this.mCompressOptions, this.mBitmaps.length);
            for (int i = 0; i < this.mBitmaps.length; ++i) {
                CompressResult compressResult;
                Bitmap bitmap = FileCompressor.shouldKeepSampling(this.mBitmaps[i], this.mCompressOptions);
                if (this.mCompressOptions != null && outfilePaths != null && outfilePaths.length == this.mBitmaps.length) {
                    this.mCompressOptions.outfile = outfilePaths[i];
                }
                if ((compressResult = FileCompressor.compress(bitmap, this.mCompressOptions, this.shouldReturnBitmap, false)) != null) {
                    result.success = true;
                }
                result.results[i] = compressResult;
            }
            return result;
        }
    }

    public static final class FileArrayAsFileCallable
    extends BaseFileBatchCompressCallable {
        private File[] mFiles;

        public FileArrayAsFileCallable(Tiny.FileCompressOptions options, boolean withBitmap, File[] files) {
            super(options, withBitmap);
            this.mFiles = files;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BatchCompressResult call() throws Exception {
            if (this.mFiles == null) {
                return null;
            }
            BatchCompressResult result = new BatchCompressResult();
            result.results = new CompressResult[this.mFiles.length];
            String[] outfilePaths = FileCompressCallableTasks.getBatchOutfilePaths(this.mCompressOptions, this.mFiles.length);
            for (int i = 0; i < this.mFiles.length; ++i) {
                File file = this.mFiles[i];
                if (file == null) {
                    result.results[i] = null;
                    continue;
                }
                CompressResult compressResult = null;
                FileInputStream fis = null;
                try {
                    if (this.mCompressOptions != null) {
                        if (outfilePaths != null && outfilePaths.length == this.mFiles.length) {
                            this.mCompressOptions.outfile = outfilePaths[i];
                        }
                        if (this.mCompressOptions.overrideSource) {
                            this.mCompressOptions.outfile = file.getAbsolutePath();
                        }
                    }
                    fis = new FileInputStream(file);
                    compressResult = FileCompressor.compress(CompressKit.transformToByteArray(fis), this.mCompressOptions, this.shouldReturnBitmap, true);
                }
                finally {
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
                if (compressResult != null) {
                    result.success = true;
                }
                result.results[i] = compressResult;
            }
            return result;
        }
    }

    public static final class ResourceAsFileCallable
    extends BaseFileCompressCallable {
        private int mResId;

        public ResourceAsFileCallable(Tiny.FileCompressOptions options, boolean withBitmap, int resId) {
            super(options, withBitmap);
            this.mResId = resId;
        }

        @Override
        public CompressResult call() throws Exception {
            Bitmap bitmap = FileCompressor.shouldKeepSampling(this.mResId, this.mCompressOptions);
            return FileCompressor.compress(bitmap, this.mCompressOptions, this.shouldReturnBitmap, true);
        }
    }

    public static final class ByteArrayAsFileCallable
    extends BaseFileCompressCallable {
        private byte[] mBytes;

        public ByteArrayAsFileCallable(Tiny.FileCompressOptions options, boolean withBitmap, byte[] bytes) {
            super(options, withBitmap);
            this.mBytes = bytes;
        }

        @Override
        public CompressResult call() throws Exception {
            return FileCompressor.compress(this.mBytes, this.mCompressOptions, this.shouldReturnBitmap, true);
        }
    }

    public static final class UriAsFileCallable
    extends BaseFileCompressCallable {
        private Uri mUri;

        public UriAsFileCallable(Tiny.FileCompressOptions options, boolean withBitmap, Uri uri) {
            super(options, withBitmap);
            this.mUri = uri;
        }

        @Override
        public CompressResult call() throws Exception {
            Bitmap bitmap = FileCompressor.shouldKeepSampling(this.mUri, this.mCompressOptions);
            if (this.mCompressOptions != null && this.mCompressOptions.overrideSource && (UriUtil.isLocalContentUri(this.mUri) || UriUtil.isLocalFileUri(this.mUri))) {
                this.mCompressOptions.outfile = UriUtil.getRealPathFromUri(this.mUri);
            }
            return FileCompressor.compress(bitmap, this.mCompressOptions, this.shouldReturnBitmap, true);
        }
    }

    public static final class FileAsFileCallable
    extends BaseFileCompressCallable {
        private File mFile;

        public FileAsFileCallable(Tiny.FileCompressOptions options, boolean withBitmap, File file) {
            super(options, withBitmap);
            this.mFile = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CompressResult call() throws Exception {
            CompressResult result = null;
            FileInputStream fis = null;
            try {
                if (this.mCompressOptions != null && this.mCompressOptions.overrideSource) {
                    this.mCompressOptions.outfile = this.mFile.getAbsolutePath();
                }
                fis = new FileInputStream(this.mFile);
                result = FileCompressor.compress(CompressKit.transformToByteArray(fis), this.mCompressOptions, this.shouldReturnBitmap, true);
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException iOException) {}
            }
            return result;
        }
    }

    public static final class BitmapAsFileCallable
    extends BaseFileCompressCallable {
        private Bitmap mBitmap;

        public BitmapAsFileCallable(Tiny.FileCompressOptions options, boolean withBitmap, Bitmap bitmap) {
            super(options, withBitmap);
            this.mBitmap = bitmap;
        }

        @Override
        public CompressResult call() throws Exception {
            Bitmap bitmap = FileCompressor.shouldKeepSampling(this.mBitmap, this.mCompressOptions);
            return FileCompressor.compress(bitmap, this.mCompressOptions, this.shouldReturnBitmap, false);
        }
    }

    public static final class InputStreamAsFileCallable
    extends BaseFileCompressCallable {
        private InputStream mInputStream;

        public InputStreamAsFileCallable(Tiny.FileCompressOptions options, boolean withBitmap, InputStream is) {
            super(options, withBitmap);
            this.mInputStream = is;
        }

        @Override
        public CompressResult call() throws Exception {
            return FileCompressor.compress(CompressKit.transformToByteArray(this.mInputStream), this.mCompressOptions, this.shouldReturnBitmap, true);
        }
    }
}

