/*
 * Decompiled with CFR 0.152.
 */
package com.zxy.tiny.callback;

import android.graphics.Bitmap;
import com.zxy.tiny.callback.BitmapBatchCallback;
import com.zxy.tiny.callback.BitmapCallback;
import com.zxy.tiny.callback.Callback;
import com.zxy.tiny.callback.CallbackDispatcher;
import com.zxy.tiny.callback.FileBatchCallback;
import com.zxy.tiny.callback.FileCallback;
import com.zxy.tiny.callback.FileWithBitmapBatchCallback;
import com.zxy.tiny.callback.FileWithBitmapCallback;
import com.zxy.tiny.common.BatchCompressResult;
import com.zxy.tiny.common.CompressResult;

public class DefaultCallbackDispatcher<T>
implements CallbackDispatcher<T> {
    private Callback mCallback;

    public DefaultCallbackDispatcher(Callback callback) {
        this.mCallback = callback;
    }

    @Override
    public void dispatch(T t, Throwable tr) {
        if (this.mCallback == null) {
            return;
        }
        if (this.mCallback instanceof BitmapCallback) {
            if (t != null && t instanceof Bitmap) {
                ((BitmapCallback)this.mCallback).callback(true, (Bitmap)t, null);
                return;
            }
            ((BitmapCallback)this.mCallback).callback(false, null, tr);
        } else if (this.mCallback instanceof BitmapBatchCallback) {
            if (t != null && t instanceof Bitmap[]) {
                ((BitmapBatchCallback)this.mCallback).callback(true, (Bitmap[])t, null);
                return;
            }
            ((BitmapBatchCallback)this.mCallback).callback(false, null, tr);
        } else if (this.mCallback instanceof FileCallback) {
            if (t != null && t instanceof CompressResult) {
                ((FileCallback)this.mCallback).callback(((CompressResult)t).success, ((CompressResult)t).outfile, ((CompressResult)t).throwable);
                return;
            }
            ((FileCallback)this.mCallback).callback(false, null, tr);
        } else if (this.mCallback instanceof FileWithBitmapCallback) {
            if (t != null && t instanceof CompressResult) {
                ((FileWithBitmapCallback)this.mCallback).callback(((CompressResult)t).success, ((CompressResult)t).bitmap, ((CompressResult)t).outfile, ((CompressResult)t).throwable);
                return;
            }
            ((FileWithBitmapCallback)this.mCallback).callback(false, null, null, tr);
        } else if (this.mCallback instanceof FileBatchCallback) {
            CompressResult[] result;
            if (t != null && t instanceof BatchCompressResult && (result = ((BatchCompressResult)t).results) != null) {
                String[] outfile = new String[result.length];
                for (int i = 0; i < result.length; ++i) {
                    CompressResult cr = result[i];
                    outfile[i] = cr == null ? null : cr.outfile;
                }
                ((FileBatchCallback)this.mCallback).callback(((BatchCompressResult)t).success, outfile, ((BatchCompressResult)t).throwable);
                return;
            }
            ((FileBatchCallback)this.mCallback).callback(false, null, tr);
        } else if (this.mCallback instanceof FileWithBitmapBatchCallback) {
            CompressResult[] result;
            if (t != null && t instanceof BatchCompressResult && (result = ((BatchCompressResult)t).results) != null) {
                Bitmap[] bitmaps = new Bitmap[result.length];
                String[] outfile = new String[result.length];
                for (int i = 0; i < result.length; ++i) {
                    CompressResult cr = result[i];
                    bitmaps[i] = cr == null ? null : cr.bitmap;
                    outfile[i] = cr == null ? null : cr.outfile;
                }
                ((FileWithBitmapBatchCallback)this.mCallback).callback(((BatchCompressResult)t).success, bitmaps, outfile, ((BatchCompressResult)t).throwable);
                return;
            }
            ((FileWithBitmapBatchCallback)this.mCallback).callback(false, null, null, tr);
        }
    }
}

