/*
 * Decompiled with CFR 0.152.
 */
package com.zxy.tiny.common;

import android.database.Cursor;
import android.net.Uri;
import com.zxy.tiny.Tiny;

public final class UriUtil {
    public static final String HTTP_SCHEME = "http";
    public static final String HTTPS_SCHEME = "https";
    public static final String LOCAL_FILE_SCHEME = "file";
    public static final String LOCAL_CONTENT_SCHEME = "content";
    public static final String LOCAL_ASSET_SCHEME = "asset";
    public static final String LOCAL_RESOURCE_SCHEME = "res";
    public static final String DATA_SCHEME = "data";

    public static boolean isNetworkUri(Uri uri) {
        String scheme = UriUtil.getSchemeOrNull(uri);
        return HTTPS_SCHEME.equals(scheme) || HTTP_SCHEME.equals(scheme);
    }

    public static boolean isLocalFileUri(Uri uri) {
        String scheme = UriUtil.getSchemeOrNull(uri);
        return LOCAL_FILE_SCHEME.equals(scheme);
    }

    public static boolean isLocalContentUri(Uri uri) {
        String scheme = UriUtil.getSchemeOrNull(uri);
        return LOCAL_CONTENT_SCHEME.equals(scheme);
    }

    public static boolean isLocalAssetUri(Uri uri) {
        String scheme = UriUtil.getSchemeOrNull(uri);
        return LOCAL_ASSET_SCHEME.equals(scheme);
    }

    public static boolean isLocalResourceUri(Uri uri) {
        String scheme = UriUtil.getSchemeOrNull(uri);
        return LOCAL_RESOURCE_SCHEME.equals(scheme);
    }

    public static boolean isDataUri(Uri uri) {
        return DATA_SCHEME.equals(UriUtil.getSchemeOrNull(uri));
    }

    public static String getSchemeOrNull(Uri uri) {
        return uri == null ? null : uri.getScheme();
    }

    public static Uri parseUriOrNull(String uriAsString) {
        return uriAsString != null ? Uri.parse((String)uriAsString) : null;
    }

    public static String getRealPathFromUri(Uri srcUri) {
        String result = null;
        if (UriUtil.isLocalContentUri(srcUri)) {
            Cursor cursor = Tiny.getInstance().getApplication().getContentResolver().query(srcUri, null, null, null, null);
            if (cursor != null) {
                cursor.moveToFirst();
                int idx = cursor.getColumnIndex("_data");
                result = cursor.getString(idx);
                cursor.close();
            }
        } else if (UriUtil.isLocalFileUri(srcUri)) {
            result = srcUri.getPath();
        }
        return result;
    }
}

