/*
 * Decompiled with CFR 0.152.
 */
package com.zxy.tiny.core;

import android.graphics.Bitmap;
import android.net.Uri;
import com.zxy.tiny.Tiny;
import com.zxy.tiny.callable.BitmapCompressCallableTasks;
import com.zxy.tiny.callback.BitmapBatchCallback;
import com.zxy.tiny.callback.Callback;
import com.zxy.tiny.callback.DefaultCallbackDispatcher;
import com.zxy.tiny.common.BitmapBatchResult;
import com.zxy.tiny.core.CompressEngine;
import com.zxy.tiny.core.CompressExecutor;
import com.zxy.tiny.core.CompressFutureTask;
import com.zxy.tiny.core.CompressKit;
import java.io.File;
import java.util.Arrays;

public class BitmapBatchCompressEngine
extends CompressEngine {
    private Tiny.BitmapCompressOptions mCompressOptions;

    public BitmapBatchCompressEngine withOptions(Tiny.BitmapCompressOptions options) {
        options.config = CompressKit.filterConfig(options.config);
        this.mCompressOptions = options;
        return this;
    }

    public void batchCompress(BitmapBatchCallback callback) {
        this.impl(callback);
    }

    public BitmapBatchResult batchCompressSync() {
        return this.implSync();
    }

    private BitmapBatchResult implSync() {
        BitmapBatchResult result;
        block22: {
            result = new BitmapBatchResult();
            if (this.mSource == null) {
                result.success = false;
                result.throwable = new RuntimeException("the source is null!");
                return result;
            }
            if (this.mCompressOptions == null) {
                this.mCompressOptions = new Tiny.BitmapCompressOptions();
            }
            if (this.mSourceType == CompressEngine.SourceType.FILE_ARRAY) {
                File[] file = (File[])this.mSource;
                try {
                    Bitmap[] bitmaps = new BitmapCompressCallableTasks.FileArrayAsBitmapCallable(this.mCompressOptions, file).call();
                    if (bitmaps == null || bitmaps.length == 0) {
                        result.bitmaps = null;
                        result.success = false;
                        result.throwable = new RuntimeException("the compress result is null!");
                        break block22;
                    }
                    result.bitmaps = Arrays.asList(bitmaps);
                    result.success = true;
                }
                catch (Exception e) {
                    result.success = false;
                    result.throwable = e;
                }
            } else if (this.mSourceType == CompressEngine.SourceType.BITMAP_ARRAY) {
                try {
                    Bitmap[] bitmaps = new BitmapCompressCallableTasks.BitmapArrayAsBitmapCallable(this.mCompressOptions, (Bitmap[])this.mSource).call();
                    if (bitmaps == null || bitmaps.length == 0) {
                        result.bitmaps = null;
                        result.success = false;
                        result.throwable = new RuntimeException("the compress result is null!");
                        break block22;
                    }
                    result.bitmaps = Arrays.asList(bitmaps);
                    result.success = true;
                }
                catch (Exception e) {
                    result.success = false;
                    result.throwable = e;
                }
            } else if (this.mSourceType == CompressEngine.SourceType.URI_ARRAY) {
                Uri[] uris = (Uri[])this.mSource;
                try {
                    Bitmap[] bitmaps = new BitmapCompressCallableTasks.UriArrayAsBitmapCallable(this.mCompressOptions, uris).call();
                    if (bitmaps == null || bitmaps.length == 0) {
                        result.bitmaps = null;
                        result.success = false;
                        result.throwable = new RuntimeException("the compress result is null!");
                        break block22;
                    }
                    result.bitmaps = Arrays.asList(bitmaps);
                    result.success = true;
                }
                catch (Exception e) {
                    result.success = false;
                    result.throwable = e;
                }
            } else if (this.mSourceType == CompressEngine.SourceType.RES_ID_ARRAY) {
                int[] resIds = (int[])this.mSource;
                try {
                    Bitmap[] bitmaps = new BitmapCompressCallableTasks.ResourceArrayAsBitmapCallable(this.mCompressOptions, resIds).call();
                    if (bitmaps == null || bitmaps.length == 0) {
                        result.bitmaps = null;
                        result.success = false;
                        result.throwable = new RuntimeException("the compress result is null!");
                    } else {
                        result.bitmaps = Arrays.asList(bitmaps);
                        result.success = true;
                    }
                }
                catch (Exception e) {
                    result.success = false;
                    result.throwable = e;
                }
            }
        }
        return result;
    }

    private void impl(Callback callback) {
        if (this.mSource == null) {
            if (callback instanceof BitmapBatchCallback) {
                ((BitmapBatchCallback)callback).callback(false, null, new RuntimeException("the source is null!"));
            }
            return;
        }
        if (this.mCompressOptions == null) {
            this.mCompressOptions = new Tiny.BitmapCompressOptions();
        }
        if (this.mSourceType == CompressEngine.SourceType.FILE_ARRAY) {
            File[] file = (File[])this.mSource;
            CompressExecutor.getExecutor().execute(new CompressFutureTask<Bitmap[]>(new BitmapCompressCallableTasks.FileArrayAsBitmapCallable(this.mCompressOptions, file), new DefaultCallbackDispatcher(callback)));
        } else if (this.mSourceType == CompressEngine.SourceType.BITMAP_ARRAY) {
            Bitmap[] bitmaps = (Bitmap[])this.mSource;
            CompressExecutor.getExecutor().execute(new CompressFutureTask<Bitmap[]>(new BitmapCompressCallableTasks.BitmapArrayAsBitmapCallable(this.mCompressOptions, bitmaps), new DefaultCallbackDispatcher(callback)));
        } else if (this.mSourceType == CompressEngine.SourceType.URI_ARRAY) {
            Uri[] uris = (Uri[])this.mSource;
            CompressExecutor.getExecutor().execute(new CompressFutureTask<Bitmap[]>(new BitmapCompressCallableTasks.UriArrayAsBitmapCallable(this.mCompressOptions, uris), new DefaultCallbackDispatcher(callback)));
        } else if (this.mSourceType == CompressEngine.SourceType.RES_ID_ARRAY) {
            int[] resIds = (int[])this.mSource;
            CompressExecutor.getExecutor().execute(new CompressFutureTask<Bitmap[]>(new BitmapCompressCallableTasks.ResourceArrayAsBitmapCallable(this.mCompressOptions, resIds), new DefaultCallbackDispatcher(callback)));
        }
    }
}

