/*
 * Decompiled with CFR 0.152.
 */
package com.zxy.tiny.core;

import android.graphics.Bitmap;
import android.net.Uri;
import com.zxy.tiny.Tiny;
import com.zxy.tiny.callable.BitmapCompressCallableTasks;
import com.zxy.tiny.callback.BitmapCallback;
import com.zxy.tiny.callback.Callback;
import com.zxy.tiny.callback.DefaultCallbackDispatcher;
import com.zxy.tiny.common.BitmapResult;
import com.zxy.tiny.core.CompressEngine;
import com.zxy.tiny.core.CompressExecutor;
import com.zxy.tiny.core.CompressFutureTask;
import com.zxy.tiny.core.CompressKit;
import java.io.File;
import java.io.InputStream;

public class BitmapCompressEngine
extends CompressEngine {
    private Tiny.BitmapCompressOptions mCompressOptions;

    public BitmapCompressEngine withOptions(Tiny.BitmapCompressOptions options) {
        options.config = CompressKit.filterConfig(options.config);
        this.mCompressOptions = options;
        return this;
    }

    public void compress(BitmapCallback callback) {
        this.impl(callback);
    }

    public BitmapResult compressSync() {
        return this.implSync();
    }

    private BitmapResult implSync() {
        BitmapResult result = new BitmapResult();
        if (this.mSource == null) {
            result.success = false;
            result.throwable = new RuntimeException("the source is null!");
            return result;
        }
        if (this.mCompressOptions == null) {
            this.mCompressOptions = new Tiny.BitmapCompressOptions();
        }
        if (this.mSourceType == CompressEngine.SourceType.FILE) {
            File file = (File)this.mSource;
            try {
                result.bitmap = new BitmapCompressCallableTasks.FileAsBitmapCallable(this.mCompressOptions, file).call();
                result.success = true;
            }
            catch (Exception e) {
                result.success = false;
                result.throwable = e;
            }
        } else if (this.mSourceType == CompressEngine.SourceType.BITMAP) {
            Bitmap bitmap = (Bitmap)this.mSource;
            try {
                result.bitmap = new BitmapCompressCallableTasks.BitmapAsBitmapCallable(this.mCompressOptions, bitmap).call();
                result.success = true;
            }
            catch (Exception e) {
                result.success = false;
                result.throwable = e;
            }
        } else if (this.mSourceType == CompressEngine.SourceType.URI) {
            Uri uri = (Uri)this.mSource;
            try {
                result.bitmap = new BitmapCompressCallableTasks.UriAsBitmapCallable(this.mCompressOptions, uri).call();
                result.success = true;
            }
            catch (Exception e) {
                result.success = false;
                result.throwable = e;
            }
        } else if (this.mSourceType == CompressEngine.SourceType.BYTE_ARRAY) {
            byte[] bytes = (byte[])this.mSource;
            try {
                result.bitmap = new BitmapCompressCallableTasks.ByteArrayAsBitmapCallable(this.mCompressOptions, bytes).call();
                result.success = true;
            }
            catch (Exception e) {
                result.success = false;
                result.throwable = e;
            }
        } else if (this.mSourceType == CompressEngine.SourceType.INPUT_STREAM) {
            InputStream is = (InputStream)this.mSource;
            try {
                result.bitmap = new BitmapCompressCallableTasks.InputStreamAsBitmapCallable(this.mCompressOptions, is).call();
                result.success = true;
            }
            catch (Exception e) {
                result.success = false;
                result.throwable = e;
            }
        } else if (this.mSourceType == CompressEngine.SourceType.RES_ID) {
            int resId = (Integer)this.mSource;
            try {
                result.bitmap = new BitmapCompressCallableTasks.ResourceAsBitmapCallable(this.mCompressOptions, resId).call();
                result.success = true;
            }
            catch (Exception e) {
                result.success = false;
                result.throwable = e;
            }
        }
        return result;
    }

    private void impl(Callback callback) {
        if (this.mSource == null) {
            if (callback instanceof BitmapCallback) {
                ((BitmapCallback)callback).callback(false, null, new RuntimeException("the source is null!"));
            }
            return;
        }
        if (this.mCompressOptions == null) {
            this.mCompressOptions = new Tiny.BitmapCompressOptions();
        }
        if (this.mSourceType == CompressEngine.SourceType.FILE) {
            File file = (File)this.mSource;
            CompressExecutor.getExecutor().execute(new CompressFutureTask<Bitmap>(new BitmapCompressCallableTasks.FileAsBitmapCallable(this.mCompressOptions, file), new DefaultCallbackDispatcher(callback)));
        } else if (this.mSourceType == CompressEngine.SourceType.BITMAP) {
            Bitmap bitmap = (Bitmap)this.mSource;
            CompressExecutor.getExecutor().execute(new CompressFutureTask<Bitmap>(new BitmapCompressCallableTasks.BitmapAsBitmapCallable(this.mCompressOptions, bitmap), new DefaultCallbackDispatcher(callback)));
        } else if (this.mSourceType == CompressEngine.SourceType.URI) {
            Uri uri = (Uri)this.mSource;
            CompressExecutor.getExecutor().execute(new CompressFutureTask<Bitmap>(new BitmapCompressCallableTasks.UriAsBitmapCallable(this.mCompressOptions, uri), new DefaultCallbackDispatcher(callback)));
        } else if (this.mSourceType == CompressEngine.SourceType.BYTE_ARRAY) {
            byte[] bytes = (byte[])this.mSource;
            CompressExecutor.getExecutor().execute(new CompressFutureTask<Bitmap>(new BitmapCompressCallableTasks.ByteArrayAsBitmapCallable(this.mCompressOptions, bytes), new DefaultCallbackDispatcher(callback)));
        } else if (this.mSourceType == CompressEngine.SourceType.INPUT_STREAM) {
            InputStream is = (InputStream)this.mSource;
            CompressExecutor.getExecutor().execute(new CompressFutureTask<Bitmap>(new BitmapCompressCallableTasks.InputStreamAsBitmapCallable(this.mCompressOptions, is), new DefaultCallbackDispatcher(callback)));
        } else if (this.mSourceType == CompressEngine.SourceType.RES_ID) {
            int resId = (Integer)this.mSource;
            CompressExecutor.getExecutor().execute(new CompressFutureTask<Bitmap>(new BitmapCompressCallableTasks.ResourceAsBitmapCallable(this.mCompressOptions, resId), new DefaultCallbackDispatcher(callback)));
        }
    }
}

