/*
 * Decompiled with CFR 0.152.
 */
package com.zxy.tiny.core;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.os.Build;
import android.util.Pair;
import android.util.TypedValue;
import com.zxy.tiny.Tiny;
import com.zxy.tiny.common.Conditions;
import com.zxy.tiny.common.TinyException;
import com.zxy.tiny.core.CompressKit;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class BitmapKit {
    private static final int ALPHA_8_BYTES_PER_PIXEL = 1;
    private static final int ARGB_4444_BYTES_PER_PIXEL = 2;
    private static final int ARGB_8888_BYTES_PER_PIXEL = 4;
    private static final int RGB_565_BYTES_PER_PIXEL = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<Integer, Integer> decodeDimensions(String filePath) throws Exception {
        boolean isExist = Conditions.fileIsExist(filePath);
        if (!isExist) {
            return null;
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(filePath);
            Pair<Integer, Integer> pair = BitmapKit.decodeDimensions(CompressKit.transformToByteArray(is));
            return pair;
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static Pair<Integer, Integer> decodeDimensions(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        BitmapFactory.Options options = CompressKit.getDefaultDecodeBoundsOptions();
        BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length, (BitmapFactory.Options)options);
        return options.outWidth == -1 || options.outHeight == -1 ? null : Pair.create((Object)options.outWidth, (Object)options.outHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<Integer, Integer> decodeDimensions(int resId) throws Exception {
        InputStream is = null;
        Resources resources = Tiny.getInstance().getApplication().getResources();
        try {
            is = resources.openRawResource(resId, new TypedValue());
            BitmapFactory.Options options = CompressKit.getDefaultDecodeBoundsOptions();
            BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
            Pair pair = options.outWidth == -1 || options.outHeight == -1 ? null : Pair.create((Object)options.outWidth, (Object)options.outHeight);
            return pair;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static Pair<Integer, Integer> decodeDimensions(FileDescriptor fd) {
        if (fd == null) {
            return null;
        }
        BitmapFactory.Options options = CompressKit.getDefaultDecodeBoundsOptions();
        BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, null, (BitmapFactory.Options)options);
        return options.outWidth == -1 || options.outHeight == -1 ? null : Pair.create((Object)options.outWidth, (Object)options.outHeight);
    }

    public static long getSizeInBytes(Bitmap bitmap) {
        if (bitmap == null) {
            return 0L;
        }
        if (Build.VERSION.SDK_INT > 19) {
            try {
                return bitmap.getAllocationByteCount();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bitmap.getByteCount();
    }

    public static long getBitmapSizeInBytes(Bitmap bitmap) {
        if (bitmap == null || bitmap.isRecycled()) {
            return 0L;
        }
        Bitmap.Config config = bitmap.getConfig();
        switch (config) {
            case ARGB_8888: {
                return 4L * BitmapKit.getSizeInBytes(bitmap);
            }
            case ALPHA_8: {
                return 1L * BitmapKit.getSizeInBytes(bitmap);
            }
            case ARGB_4444: {
                return 2L * BitmapKit.getSizeInBytes(bitmap);
            }
            case RGB_565: {
                return 2L * BitmapKit.getSizeInBytes(bitmap);
            }
        }
        throw new TinyException.UnsupportedParamException("this bitmap config is not supported!");
    }

    public static Bitmap rotateBitmap(Bitmap bitmap, int degree) {
        if (bitmap == null || bitmap.isRecycled()) {
            return bitmap;
        }
        if (degree != 90 && degree != 180 && degree != 270) {
            return bitmap;
        }
        float pointX = bitmap.getWidth() / 2;
        float pointY = bitmap.getHeight() / 2;
        Matrix matrix = new Matrix();
        matrix.setRotate((float)degree, pointX, pointY);
        Bitmap result = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        bitmap.recycle();
        return result;
    }
}

