/*
 * Decompiled with CFR 0.152.
 */
package com.zxy.tiny.core;

import android.graphics.Bitmap;
import android.net.Uri;
import com.zxy.tiny.core.BitmapBatchCompressEngine;
import com.zxy.tiny.core.BitmapCompressEngine;
import com.zxy.tiny.core.CompressEngineFactory;
import com.zxy.tiny.core.FileBatchCompressEngine;
import com.zxy.tiny.core.FileCompressEngine;
import java.io.File;
import java.io.InputStream;

public class CompressEngine {
    SourceType mSourceType;
    Object mSource;

    public CompressEngine source(File file) {
        this.mSourceType = SourceType.FILE;
        this.mSource = file;
        return this;
    }

    public CompressEngine source(Bitmap bitmap) {
        this.mSourceType = SourceType.BITMAP;
        this.mSource = bitmap;
        return this;
    }

    public CompressEngine source(Uri uri) {
        this.mSourceType = SourceType.URI;
        this.mSource = uri;
        return this;
    }

    public CompressEngine source(byte[] bytes) {
        this.mSourceType = SourceType.BYTE_ARRAY;
        this.mSource = bytes;
        return this;
    }

    public CompressEngine source(InputStream is) {
        this.mSourceType = SourceType.INPUT_STREAM;
        this.mSource = is;
        return this;
    }

    public CompressEngine source(int resId) {
        this.mSourceType = SourceType.RES_ID;
        this.mSource = resId;
        return this;
    }

    public CompressEngine source(File[] files) {
        this.mSourceType = SourceType.FILE_ARRAY;
        this.mSource = files;
        return this;
    }

    public CompressEngine source(Bitmap[] bitmaps) {
        this.mSourceType = SourceType.BITMAP_ARRAY;
        this.mSource = bitmaps;
        return this;
    }

    public CompressEngine source(Uri[] uris) {
        this.mSourceType = SourceType.URI_ARRAY;
        this.mSource = uris;
        return this;
    }

    public CompressEngine source(int[] resIds) {
        this.mSourceType = SourceType.RES_ID_ARRAY;
        this.mSource = resIds;
        return this;
    }

    public BitmapCompressEngine asBitmap() {
        return CompressEngineFactory.buildBitmapCompressEngine(this.mSource, this.mSourceType);
    }

    public FileCompressEngine asFile() {
        return CompressEngineFactory.buildFileCompressEngine(this.mSource, this.mSourceType);
    }

    public BitmapBatchCompressEngine batchAsBitmap() {
        return CompressEngineFactory.buildBitmapBatchCompressEngine(this.mSource, this.mSourceType);
    }

    public FileBatchCompressEngine batchAsFile() {
        return CompressEngineFactory.buildFileBatchCompressEngine(this.mSource, this.mSourceType);
    }

    static enum SourceType {
        FILE(1),
        BITMAP(2),
        URI(3),
        BYTE_ARRAY(4),
        INPUT_STREAM(5),
        RES_ID(6),
        FILE_ARRAY(7),
        BITMAP_ARRAY(8),
        URI_ARRAY(9),
        RES_ID_ARRAY(10);

        int value;

        private SourceType(int value) {
        }

        public int getValue() {
            return this.value;
        }
    }
}

