/*
 * Decompiled with CFR 0.152.
 */
package com.zxy.tiny.core;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Pair;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public final class CompressKit {
    public static final int DEFAULT_QUALITY = 76;
    public static final Bitmap.Config DEFAULT_CONFIG = Bitmap.Config.ARGB_8888;
    public static final int DEFAULT_MAX_COMPRESS_SIZE = 1280;
    private static final int DEFAULT_DECODE_BUFFER_SIZE = 16384;

    public static int getBaseline(int baseline) {
        return baseline <= 0 ? 1280 : baseline;
    }

    public static BitmapFactory.Options getDefaultDecodeBoundsOptions() {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        options.inTempStorage = new byte[16384];
        return options;
    }

    public static BitmapFactory.Options getDefaultDecodeOptions() {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = false;
        options.inScaled = true;
        options.inMutable = true;
        options.inTempStorage = new byte[16384];
        if (Build.VERSION.SDK_INT < 21) {
            if (Build.VERSION.SDK_INT < 19) {
                options.inPurgeable = true;
                options.inInputShareable = true;
            } else {
                options.inPurgeable = false;
                options.inInputShareable = false;
            }
        }
        if (Build.VERSION.SDK_INT < 24) {
            options.inDither = true;
        }
        return options;
    }

    public static Pair<Integer, Integer> getDeviceScreenSizeInPixels() {
        DisplayMetrics dm = Resources.getSystem().getDisplayMetrics();
        return Pair.create((Object)dm.widthPixels, (Object)dm.heightPixels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] transformToByteArray(InputStream is) {
        if (is == null) {
            return new byte[0];
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int len = -1;
        try {
            while ((len = is.read(buffer)) != -1) {
                bos.write(buffer, 0, len);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            byte[] byArray = new byte[]{};
            return byArray;
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException iOException) {}
        }
        return bos.toByteArray();
    }

    public static Bitmap.Config filterConfig(Bitmap.Config config) {
        if (config == null) {
            return DEFAULT_CONFIG;
        }
        switch (config) {
            case ARGB_8888: 
            case ARGB_4444: 
            case ALPHA_8: {
                config = Bitmap.Config.ARGB_8888;
                break;
            }
            case RGB_565: {
                config = Bitmap.Config.RGB_565;
            }
        }
        return config;
    }
}

