/*
 * Decompiled with CFR 0.152.
 */
package com.zxy.tiny.core;

import android.graphics.Bitmap;
import android.net.Uri;
import android.text.TextUtils;
import com.zxy.tiny.Tiny;
import com.zxy.tiny.callable.FileCompressCallableTasks;
import com.zxy.tiny.callback.Callback;
import com.zxy.tiny.callback.DefaultCallbackDispatcher;
import com.zxy.tiny.callback.FileBatchCallback;
import com.zxy.tiny.callback.FileWithBitmapBatchCallback;
import com.zxy.tiny.common.BatchCompressResult;
import com.zxy.tiny.common.CompressResult;
import com.zxy.tiny.common.FileBatchResult;
import com.zxy.tiny.common.FileWithBitmapBatchResult;
import com.zxy.tiny.common.FileWithBitmapResult;
import com.zxy.tiny.core.CompressEngine;
import com.zxy.tiny.core.CompressExecutor;
import com.zxy.tiny.core.CompressFutureTask;
import com.zxy.tiny.core.CompressKit;
import java.io.File;
import java.util.ArrayList;

public class FileBatchCompressEngine
extends CompressEngine {
    private Tiny.FileCompressOptions mCompressOptions;

    public FileBatchCompressEngine withOptions(Tiny.FileCompressOptions options) {
        options.config = CompressKit.filterConfig(options.config);
        this.mCompressOptions = options;
        return this;
    }

    public void batchCompress(FileBatchCallback callback) {
        this.impl(callback);
    }

    public void batchCompress(FileWithBitmapBatchCallback callback) {
        this.impl(callback);
    }

    public FileBatchResult batchCompressSync() {
        return this.implSync();
    }

    public FileWithBitmapBatchResult batchCompressWithReturnBitmapResult() {
        return this.implWithReturnBitmapSync();
    }

    private FileBatchResult implSync() {
        FileBatchResult result = new FileBatchResult();
        if (this.mSource == null) {
            result.success = false;
            result.throwable = new RuntimeException("the source is null!");
            return result;
        }
        boolean shouldReturnBitmap = false;
        if (this.mCompressOptions == null) {
            this.mCompressOptions = new Tiny.FileCompressOptions();
        }
        if (this.mSourceType == CompressEngine.SourceType.FILE_ARRAY) {
            File[] files = (File[])this.mSource;
            try {
                BatchCompressResult compressResult = new FileCompressCallableTasks.FileArrayAsFileCallable(this.mCompressOptions, shouldReturnBitmap, files).call();
                ArrayList<String> fileResults = new ArrayList<String>();
                if (compressResult != null && compressResult.results != null) {
                    for (int i = 0; i < compressResult.results.length; ++i) {
                        CompressResult tmp = compressResult.results[i];
                        if (tmp == null || TextUtils.isEmpty((CharSequence)tmp.outfile)) continue;
                        fileResults.add(tmp.outfile);
                    }
                    result.success = compressResult.success;
                } else {
                    result.success = false;
                    result.throwable = new RuntimeException("the compress result is null!");
                }
                result.outfiles = fileResults;
            }
            catch (Exception e) {
                result.success = false;
                result.throwable = e;
            }
        } else if (this.mSourceType == CompressEngine.SourceType.BITMAP_ARRAY) {
            Bitmap[] bitmaps = (Bitmap[])this.mSource;
            try {
                BatchCompressResult compressResult = new FileCompressCallableTasks.BitmapArrayAsFileCallable(this.mCompressOptions, shouldReturnBitmap, bitmaps).call();
                ArrayList<String> fileResults = new ArrayList<String>();
                if (compressResult != null && compressResult.results != null) {
                    for (int i = 0; i < compressResult.results.length; ++i) {
                        CompressResult tmp = compressResult.results[i];
                        if (tmp == null || TextUtils.isEmpty((CharSequence)tmp.outfile)) continue;
                        fileResults.add(tmp.outfile);
                    }
                    result.success = compressResult.success;
                } else {
                    result.success = false;
                    result.throwable = new RuntimeException("the compress result is null!");
                }
                result.outfiles = fileResults;
            }
            catch (Exception e) {
                result.success = false;
                result.throwable = e;
            }
        } else if (this.mSourceType == CompressEngine.SourceType.URI_ARRAY) {
            Uri[] uris = (Uri[])this.mSource;
            try {
                BatchCompressResult compressResult = new FileCompressCallableTasks.UriArrayAsFileCallable(this.mCompressOptions, shouldReturnBitmap, uris).call();
                ArrayList<String> fileResults = new ArrayList<String>();
                if (compressResult != null && compressResult.results != null) {
                    for (int i = 0; i < compressResult.results.length; ++i) {
                        CompressResult tmp = compressResult.results[i];
                        if (tmp == null || TextUtils.isEmpty((CharSequence)tmp.outfile)) continue;
                        fileResults.add(tmp.outfile);
                    }
                    result.success = compressResult.success;
                } else {
                    result.success = false;
                    result.throwable = new RuntimeException("the compress result is null!");
                }
                result.outfiles = fileResults;
            }
            catch (Exception e) {
                result.success = false;
                result.throwable = e;
            }
        } else if (this.mSourceType == CompressEngine.SourceType.RES_ID_ARRAY) {
            int[] resIds = (int[])this.mSource;
            try {
                BatchCompressResult compressResult = new FileCompressCallableTasks.ResourceArrayAsFileCallable(this.mCompressOptions, shouldReturnBitmap, resIds).call();
                ArrayList<String> fileResults = new ArrayList<String>();
                if (compressResult != null && compressResult.results != null) {
                    for (int i = 0; i < compressResult.results.length; ++i) {
                        CompressResult tmp = compressResult.results[i];
                        if (tmp == null || TextUtils.isEmpty((CharSequence)tmp.outfile)) continue;
                        fileResults.add(tmp.outfile);
                    }
                    result.success = compressResult.success;
                } else {
                    result.success = false;
                    result.throwable = new RuntimeException("the compress result is null!");
                }
                result.outfiles = fileResults;
            }
            catch (Exception e) {
                result.success = false;
                result.throwable = e;
            }
        }
        return result;
    }

    private FileWithBitmapBatchResult implWithReturnBitmapSync() {
        FileWithBitmapBatchResult result = new FileWithBitmapBatchResult();
        if (this.mSource == null) {
            result.success = false;
            result.throwable = new RuntimeException("the source is null!");
            return result;
        }
        boolean shouldReturnBitmap = true;
        if (this.mCompressOptions == null) {
            this.mCompressOptions = new Tiny.FileCompressOptions();
        }
        if (this.mSourceType == CompressEngine.SourceType.FILE_ARRAY) {
            File[] files = (File[])this.mSource;
            try {
                BatchCompressResult compressResult = new FileCompressCallableTasks.FileArrayAsFileCallable(this.mCompressOptions, shouldReturnBitmap, files).call();
                ArrayList<FileWithBitmapResult> fileWithBitmapResults = new ArrayList<FileWithBitmapResult>();
                if (compressResult != null && compressResult.results != null) {
                    for (int i = 0; i < compressResult.results.length; ++i) {
                        CompressResult tmp = compressResult.results[i];
                        if (tmp == null) continue;
                        FileWithBitmapResult value = new FileWithBitmapResult();
                        value.outfile = tmp.outfile;
                        value.bitmap = tmp.bitmap;
                        fileWithBitmapResults.add(value);
                    }
                    result.success = compressResult.success;
                } else {
                    result.success = false;
                    result.throwable = new RuntimeException("the compress result is null!");
                }
                result.results = fileWithBitmapResults;
            }
            catch (Exception e) {
                result.success = false;
                result.throwable = e;
            }
        } else if (this.mSourceType == CompressEngine.SourceType.BITMAP_ARRAY) {
            Bitmap[] bitmaps = (Bitmap[])this.mSource;
            try {
                BatchCompressResult compressResult = new FileCompressCallableTasks.BitmapArrayAsFileCallable(this.mCompressOptions, shouldReturnBitmap, bitmaps).call();
                ArrayList<FileWithBitmapResult> fileWithBitmapResults = new ArrayList<FileWithBitmapResult>();
                if (compressResult != null && compressResult.results != null) {
                    for (int i = 0; i < compressResult.results.length; ++i) {
                        CompressResult tmp = compressResult.results[i];
                        if (tmp == null) continue;
                        FileWithBitmapResult value = new FileWithBitmapResult();
                        value.outfile = tmp.outfile;
                        value.bitmap = tmp.bitmap;
                        fileWithBitmapResults.add(value);
                    }
                    result.success = compressResult.success;
                } else {
                    result.success = false;
                    result.throwable = new RuntimeException("the compress result is null!");
                }
                result.results = fileWithBitmapResults;
            }
            catch (Exception e) {
                result.success = false;
                result.throwable = e;
            }
        } else if (this.mSourceType == CompressEngine.SourceType.URI_ARRAY) {
            Uri[] uris = (Uri[])this.mSource;
            try {
                BatchCompressResult compressResult = new FileCompressCallableTasks.UriArrayAsFileCallable(this.mCompressOptions, shouldReturnBitmap, uris).call();
                ArrayList<FileWithBitmapResult> fileWithBitmapResults = new ArrayList<FileWithBitmapResult>();
                if (compressResult != null && compressResult.results != null) {
                    for (int i = 0; i < compressResult.results.length; ++i) {
                        CompressResult tmp = compressResult.results[i];
                        if (tmp == null) continue;
                        FileWithBitmapResult value = new FileWithBitmapResult();
                        value.outfile = tmp.outfile;
                        value.bitmap = tmp.bitmap;
                        fileWithBitmapResults.add(value);
                    }
                    result.success = compressResult.success;
                } else {
                    result.success = false;
                    result.throwable = new RuntimeException("the compress result is null!");
                }
                result.results = fileWithBitmapResults;
            }
            catch (Exception e) {
                result.success = false;
                result.throwable = e;
            }
        } else if (this.mSourceType == CompressEngine.SourceType.RES_ID_ARRAY) {
            int[] resIds = (int[])this.mSource;
            try {
                BatchCompressResult compressResult = new FileCompressCallableTasks.ResourceArrayAsFileCallable(this.mCompressOptions, shouldReturnBitmap, resIds).call();
                ArrayList<FileWithBitmapResult> fileWithBitmapResults = new ArrayList<FileWithBitmapResult>();
                if (compressResult != null && compressResult.results != null) {
                    for (int i = 0; i < compressResult.results.length; ++i) {
                        CompressResult tmp = compressResult.results[i];
                        if (tmp == null) continue;
                        FileWithBitmapResult value = new FileWithBitmapResult();
                        value.outfile = tmp.outfile;
                        value.bitmap = tmp.bitmap;
                        fileWithBitmapResults.add(value);
                    }
                    result.success = compressResult.success;
                } else {
                    result.success = false;
                    result.throwable = new RuntimeException("the compress result is null!");
                }
                result.results = fileWithBitmapResults;
            }
            catch (Exception e) {
                result.success = false;
                result.throwable = e;
            }
        }
        return result;
    }

    private void impl(Callback callback) {
        if (this.mSource == null) {
            if (callback instanceof FileBatchCallback) {
                ((FileBatchCallback)callback).callback(false, null, new RuntimeException("the source is null!"));
            } else if (callback instanceof FileWithBitmapBatchCallback) {
                ((FileWithBitmapBatchCallback)callback).callback(false, null, null, new RuntimeException("the source is null!"));
            }
            return;
        }
        boolean shouldReturnBitmap = false;
        if (callback != null && callback instanceof FileWithBitmapBatchCallback) {
            shouldReturnBitmap = true;
        }
        if (this.mCompressOptions == null) {
            this.mCompressOptions = new Tiny.FileCompressOptions();
        }
        if (this.mSourceType == CompressEngine.SourceType.FILE_ARRAY) {
            File[] files = (File[])this.mSource;
            CompressExecutor.getExecutor().execute(new CompressFutureTask<BatchCompressResult>(new FileCompressCallableTasks.FileArrayAsFileCallable(this.mCompressOptions, shouldReturnBitmap, files), new DefaultCallbackDispatcher(callback)));
        } else if (this.mSourceType == CompressEngine.SourceType.BITMAP_ARRAY) {
            Bitmap[] bitmaps = (Bitmap[])this.mSource;
            CompressExecutor.getExecutor().execute(new CompressFutureTask<BatchCompressResult>(new FileCompressCallableTasks.BitmapArrayAsFileCallable(this.mCompressOptions, shouldReturnBitmap, bitmaps), new DefaultCallbackDispatcher(callback)));
        } else if (this.mSourceType == CompressEngine.SourceType.URI_ARRAY) {
            Uri[] uris = (Uri[])this.mSource;
            CompressExecutor.getExecutor().execute(new CompressFutureTask<BatchCompressResult>(new FileCompressCallableTasks.UriArrayAsFileCallable(this.mCompressOptions, shouldReturnBitmap, uris), new DefaultCallbackDispatcher(callback)));
        } else if (this.mSourceType == CompressEngine.SourceType.RES_ID_ARRAY) {
            int[] resIds = (int[])this.mSource;
            CompressExecutor.getExecutor().execute(new CompressFutureTask<BatchCompressResult>(new FileCompressCallableTasks.ResourceArrayAsFileCallable(this.mCompressOptions, shouldReturnBitmap, resIds), new DefaultCallbackDispatcher(callback)));
        }
    }
}

