/*
 * Decompiled with CFR 0.152.
 */
package com.zxy.tiny.core;

import android.graphics.Bitmap;
import android.net.Uri;
import com.zxy.tiny.Tiny;
import com.zxy.tiny.callable.FileCompressCallableTasks;
import com.zxy.tiny.callback.Callback;
import com.zxy.tiny.callback.DefaultCallbackDispatcher;
import com.zxy.tiny.callback.FileCallback;
import com.zxy.tiny.callback.FileWithBitmapCallback;
import com.zxy.tiny.common.CompressResult;
import com.zxy.tiny.common.FileResult;
import com.zxy.tiny.common.FileWithBitmapResult;
import com.zxy.tiny.core.CompressEngine;
import com.zxy.tiny.core.CompressExecutor;
import com.zxy.tiny.core.CompressFutureTask;
import com.zxy.tiny.core.CompressKit;
import java.io.File;
import java.io.InputStream;

public class FileCompressEngine
extends CompressEngine {
    private Tiny.FileCompressOptions mCompressOptions;

    public FileCompressEngine withOptions(Tiny.FileCompressOptions options) {
        options.config = CompressKit.filterConfig(options.config);
        this.mCompressOptions = options;
        return this;
    }

    public void compress(FileCallback callback) {
        this.impl(callback);
    }

    public void compress(FileWithBitmapCallback callback) {
        this.impl(callback);
    }

    public FileResult compressSync() {
        return this.implSync();
    }

    public FileWithBitmapResult compressWithReturnBitmapSync() {
        return this.implWithReturnBitmapSync();
    }

    private FileResult implSync() {
        FileResult result = new FileResult();
        if (this.mSource == null) {
            result.success = false;
            result.throwable = new RuntimeException("the source is null!");
            return result;
        }
        boolean shouldReturnBitmap = false;
        if (this.mCompressOptions == null) {
            this.mCompressOptions = new Tiny.FileCompressOptions();
        }
        if (this.mSourceType == CompressEngine.SourceType.FILE) {
            File file = (File)this.mSource;
            try {
                CompressResult compressResult = new FileCompressCallableTasks.FileAsFileCallable(this.mCompressOptions, shouldReturnBitmap, file).call();
                result.outfile = compressResult.outfile;
                result.success = compressResult.success;
            }
            catch (Exception e) {
                result.success = false;
                result.throwable = e;
            }
        } else if (this.mSourceType == CompressEngine.SourceType.BITMAP) {
            Bitmap bitmap = (Bitmap)this.mSource;
            try {
                CompressResult compressResult = new FileCompressCallableTasks.BitmapAsFileCallable(this.mCompressOptions, shouldReturnBitmap, bitmap).call();
                result.outfile = compressResult.outfile;
                result.success = compressResult.success;
            }
            catch (Exception e) {
                result.success = false;
                result.throwable = e;
            }
        } else if (this.mSourceType == CompressEngine.SourceType.URI) {
            Uri uri = (Uri)this.mSource;
            try {
                CompressResult compressResult = new FileCompressCallableTasks.UriAsFileCallable(this.mCompressOptions, shouldReturnBitmap, uri).call();
                result.outfile = compressResult.outfile;
                result.success = compressResult.success;
            }
            catch (Exception e) {
                result.success = false;
                result.throwable = e;
            }
        } else if (this.mSourceType == CompressEngine.SourceType.BYTE_ARRAY) {
            byte[] bytes = (byte[])this.mSource;
            try {
                CompressResult compressResult = new FileCompressCallableTasks.ByteArrayAsFileCallable(this.mCompressOptions, shouldReturnBitmap, bytes).call();
                result.outfile = compressResult.outfile;
                result.success = compressResult.success;
            }
            catch (Exception e) {
                result.success = false;
                result.throwable = e;
            }
        } else if (this.mSourceType == CompressEngine.SourceType.INPUT_STREAM) {
            InputStream is = (InputStream)this.mSource;
            try {
                CompressResult compressResult = new FileCompressCallableTasks.InputStreamAsFileCallable(this.mCompressOptions, shouldReturnBitmap, is).call();
                result.outfile = compressResult.outfile;
                result.success = compressResult.success;
            }
            catch (Exception e) {
                result.success = false;
                result.throwable = e;
            }
        } else if (this.mSourceType == CompressEngine.SourceType.RES_ID) {
            int resId = (Integer)this.mSource;
            try {
                CompressResult compressResult = new FileCompressCallableTasks.ResourceAsFileCallable(this.mCompressOptions, shouldReturnBitmap, resId).call();
                result.outfile = compressResult.outfile;
                result.success = compressResult.success;
            }
            catch (Exception e) {
                result.success = false;
                result.throwable = e;
            }
        }
        return result;
    }

    private FileWithBitmapResult implWithReturnBitmapSync() {
        FileWithBitmapResult result = new FileWithBitmapResult();
        if (this.mSource == null) {
            result.success = false;
            result.throwable = new RuntimeException("the source is null!");
            return result;
        }
        boolean shouldReturnBitmap = true;
        if (this.mCompressOptions == null) {
            this.mCompressOptions = new Tiny.FileCompressOptions();
        }
        if (this.mSourceType == CompressEngine.SourceType.FILE) {
            File file = (File)this.mSource;
            try {
                CompressResult compressResult = new FileCompressCallableTasks.FileAsFileCallable(this.mCompressOptions, shouldReturnBitmap, file).call();
                result.bitmap = compressResult.bitmap;
                result.outfile = compressResult.outfile;
                result.success = compressResult.success;
            }
            catch (Exception e) {
                result.success = false;
                result.throwable = e;
            }
        } else if (this.mSourceType == CompressEngine.SourceType.BITMAP) {
            Bitmap bitmap = (Bitmap)this.mSource;
            try {
                CompressResult compressResult = new FileCompressCallableTasks.BitmapAsFileCallable(this.mCompressOptions, shouldReturnBitmap, bitmap).call();
                result.bitmap = compressResult.bitmap;
                result.outfile = compressResult.outfile;
                result.success = compressResult.success;
            }
            catch (Exception e) {
                result.success = false;
                result.throwable = e;
            }
        } else if (this.mSourceType == CompressEngine.SourceType.URI) {
            Uri uri = (Uri)this.mSource;
            try {
                CompressResult compressResult = new FileCompressCallableTasks.UriAsFileCallable(this.mCompressOptions, shouldReturnBitmap, uri).call();
                result.bitmap = compressResult.bitmap;
                result.outfile = compressResult.outfile;
                result.success = compressResult.success;
            }
            catch (Exception e) {
                result.success = false;
                result.throwable = e;
            }
        } else if (this.mSourceType == CompressEngine.SourceType.BYTE_ARRAY) {
            byte[] bytes = (byte[])this.mSource;
            try {
                CompressResult compressResult = new FileCompressCallableTasks.ByteArrayAsFileCallable(this.mCompressOptions, shouldReturnBitmap, bytes).call();
                result.bitmap = compressResult.bitmap;
                result.outfile = compressResult.outfile;
                result.success = compressResult.success;
            }
            catch (Exception e) {
                result.success = false;
                result.throwable = e;
            }
        } else if (this.mSourceType == CompressEngine.SourceType.INPUT_STREAM) {
            InputStream is = (InputStream)this.mSource;
            try {
                CompressResult compressResult = new FileCompressCallableTasks.InputStreamAsFileCallable(this.mCompressOptions, shouldReturnBitmap, is).call();
                result.bitmap = compressResult.bitmap;
                result.outfile = compressResult.outfile;
                result.success = compressResult.success;
            }
            catch (Exception e) {
                result.success = false;
                result.throwable = e;
            }
        } else if (this.mSourceType == CompressEngine.SourceType.RES_ID) {
            int resId = (Integer)this.mSource;
            try {
                CompressResult compressResult = new FileCompressCallableTasks.ResourceAsFileCallable(this.mCompressOptions, shouldReturnBitmap, resId).call();
                result.bitmap = compressResult.bitmap;
                result.outfile = compressResult.outfile;
                result.success = compressResult.success;
            }
            catch (Exception e) {
                result.success = false;
                result.throwable = e;
            }
        }
        return result;
    }

    private void impl(Callback callback) {
        if (this.mSource == null) {
            if (callback instanceof FileCallback) {
                ((FileCallback)callback).callback(false, null, new RuntimeException("the source is null!"));
            } else if (callback instanceof FileWithBitmapCallback) {
                ((FileWithBitmapCallback)callback).callback(false, null, null, new RuntimeException("the source is null!"));
            }
            return;
        }
        boolean shouldReturnBitmap = false;
        if (callback != null && callback instanceof FileWithBitmapCallback) {
            shouldReturnBitmap = true;
        }
        if (this.mCompressOptions == null) {
            this.mCompressOptions = new Tiny.FileCompressOptions();
        }
        if (this.mSourceType == CompressEngine.SourceType.FILE) {
            File file = (File)this.mSource;
            CompressExecutor.getExecutor().execute(new CompressFutureTask<CompressResult>(new FileCompressCallableTasks.FileAsFileCallable(this.mCompressOptions, shouldReturnBitmap, file), new DefaultCallbackDispatcher(callback)));
        } else if (this.mSourceType == CompressEngine.SourceType.BITMAP) {
            Bitmap bitmap = (Bitmap)this.mSource;
            CompressExecutor.getExecutor().execute(new CompressFutureTask<CompressResult>(new FileCompressCallableTasks.BitmapAsFileCallable(this.mCompressOptions, shouldReturnBitmap, bitmap), new DefaultCallbackDispatcher(callback)));
        } else if (this.mSourceType == CompressEngine.SourceType.URI) {
            Uri uri = (Uri)this.mSource;
            CompressExecutor.getExecutor().execute(new CompressFutureTask<CompressResult>(new FileCompressCallableTasks.UriAsFileCallable(this.mCompressOptions, shouldReturnBitmap, uri), new DefaultCallbackDispatcher(callback)));
        } else if (this.mSourceType == CompressEngine.SourceType.BYTE_ARRAY) {
            byte[] bytes = (byte[])this.mSource;
            CompressExecutor.getExecutor().execute(new CompressFutureTask<CompressResult>(new FileCompressCallableTasks.ByteArrayAsFileCallable(this.mCompressOptions, shouldReturnBitmap, bytes), new DefaultCallbackDispatcher(callback)));
        } else if (this.mSourceType == CompressEngine.SourceType.INPUT_STREAM) {
            InputStream is = (InputStream)this.mSource;
            CompressExecutor.getExecutor().execute(new CompressFutureTask<CompressResult>(new FileCompressCallableTasks.InputStreamAsFileCallable(this.mCompressOptions, shouldReturnBitmap, is), new DefaultCallbackDispatcher(callback)));
        } else if (this.mSourceType == CompressEngine.SourceType.RES_ID) {
            int resId = (Integer)this.mSource;
            CompressExecutor.getExecutor().execute(new CompressFutureTask<CompressResult>(new FileCompressCallableTasks.ResourceAsFileCallable(this.mCompressOptions, shouldReturnBitmap, resId), new DefaultCallbackDispatcher(callback)));
        }
    }
}

