/*
 * Decompiled with CFR 0.152.
 */
package com.zxy.tiny.core;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.util.TypedValue;
import com.zxy.libjpegturbo.JpegTurboCompressor;
import com.zxy.tiny.Tiny;
import com.zxy.tiny.common.CompressResult;
import com.zxy.tiny.common.Conditions;
import com.zxy.tiny.common.Logger;
import com.zxy.tiny.common.UriUtil;
import com.zxy.tiny.core.BitmapCompressor;
import com.zxy.tiny.core.CompressKit;
import com.zxy.tiny.core.FileKit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileCompressor {
    public static CompressResult compress(byte[] bytes, Tiny.FileCompressOptions options, boolean withBitmap, boolean recycle) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        if (options == null) {
            options = new Tiny.FileCompressOptions();
        }
        CompressResult result = null;
        Bitmap bitmap = FileCompressor.shouldKeepSampling(bytes, options);
        result = FileCompressor.compress(bitmap, options, withBitmap, recycle);
        return result;
    }

    public static CompressResult compress(Bitmap bitmap, Tiny.FileCompressOptions options, boolean withBitmap, boolean recycle) {
        if (bitmap == null || bitmap.isRecycled()) {
            return null;
        }
        CompressResult result = new CompressResult();
        if (options == null) {
            options = new Tiny.FileCompressOptions();
        }
        int quality = options.quality;
        String outfile = options.outfile;
        float size = options.size;
        String compressDirectory = options.compressDirectory;
        if (quality < 0 || quality > 100) {
            quality = 76;
        }
        if (Conditions.isDirectory(outfile)) {
            outfile = FileKit.generateCompressOutfileFormatJPEG(compressDirectory).getAbsolutePath();
        }
        if (!Conditions.isJpegFormat(outfile)) {
            outfile = FileKit.generateCompressOutfileFormatJPEG(compressDirectory).getAbsolutePath();
        }
        if (bitmap.hasAlpha()) {
            outfile = FileKit.generateCompressOutfileFormatPNG(compressDirectory).getAbsolutePath();
        }
        boolean isSuccess = false;
        try {
            isSuccess = FileCompressor.compress(bitmap, outfile, quality);
        }
        catch (FileNotFoundException e) {
            result.throwable = e;
            e.printStackTrace();
        }
        catch (Exception e) {
            result.throwable = e;
            e.printStackTrace();
        }
        if (size > 0.0f && isSuccess) {
            float outfileSize = (float)FileKit.getSizeInBytes(outfile) / 1024.0f;
            while (outfileSize > size && quality > 25) {
                quality -= 5;
                try {
                    isSuccess = FileCompressor.compress(bitmap, outfile, quality);
                }
                catch (FileNotFoundException e) {
                    result.throwable = e;
                    e.printStackTrace();
                }
                catch (Exception e) {
                    result.throwable = e;
                    e.printStackTrace();
                }
                if (!isSuccess) break;
                outfileSize = (float)FileKit.getSizeInBytes(outfile) / 1024.0f;
            }
        }
        Logger.e("compress quality: " + quality);
        result.outfile = outfile;
        result.success = isSuccess;
        if (withBitmap) {
            result.bitmap = bitmap;
        } else if (recycle) {
            result.bitmap = null;
            bitmap.recycle();
            bitmap = null;
        }
        return result;
    }

    private static boolean compress(Bitmap bitmap, String outfile, int quality) throws FileNotFoundException {
        if (bitmap == null || bitmap.isRecycled()) {
            return false;
        }
        if (bitmap.hasAlpha()) {
            return CompatCompressor.compress(bitmap, outfile, quality, Bitmap.CompressFormat.PNG);
        }
        if (Build.VERSION.SDK_INT < 24) {
            return JpegTurboCompressor.compress(bitmap, outfile, quality);
        }
        return CompatCompressor.compress(bitmap, outfile, quality, Bitmap.CompressFormat.JPEG);
    }

    public static Bitmap shouldKeepSampling(byte[] bytes, Tiny.FileCompressOptions options) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        if (options == null) {
            options = new Tiny.FileCompressOptions();
        }
        Bitmap result = null;
        if (options.isKeepSampling) {
            BitmapFactory.Options decodeOptions = CompressKit.getDefaultDecodeOptions();
            decodeOptions.inPreferredConfig = options.config;
            result = BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length, (BitmapFactory.Options)decodeOptions);
        } else {
            result = BitmapCompressor.compress(bytes, (Tiny.BitmapCompressOptions)options, false);
        }
        return result;
    }

    public static Bitmap shouldKeepSampling(Bitmap bitmap, Tiny.FileCompressOptions options) {
        if (bitmap == null || bitmap.isRecycled()) {
            return null;
        }
        if (options == null) {
            options = new Tiny.FileCompressOptions();
        }
        Bitmap result = null;
        result = options.isKeepSampling ? bitmap : BitmapCompressor.compress(bitmap, (Tiny.BitmapCompressOptions)options, false);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap shouldKeepSampling(int resId, Tiny.FileCompressOptions options) throws Exception {
        if (options == null) {
            options = new Tiny.FileCompressOptions();
        }
        Bitmap result = null;
        if (options.isKeepSampling) {
            InputStream is = null;
            Resources resources = Tiny.getInstance().getApplication().getResources();
            try {
                is = resources.openRawResource(resId, new TypedValue());
                BitmapFactory.Options decodeOptions = CompressKit.getDefaultDecodeOptions();
                decodeOptions.inPreferredConfig = options.config;
                Bitmap bitmap = BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)decodeOptions);
                return bitmap;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        result = BitmapCompressor.compress(resId, (Tiny.BitmapCompressOptions)options, false);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap shouldKeepSampling(Uri uri, Tiny.FileCompressOptions options) throws Exception {
        if (uri == null) {
            return null;
        }
        Bitmap[] result = new Bitmap[]{null};
        if (UriUtil.isLocalContentUri(uri) || UriUtil.isLocalFileUri(uri)) {
            String filePath = UriUtil.getRealPathFromUri(uri);
            if (TextUtils.isEmpty((CharSequence)filePath)) {
                return null;
            }
            if (Conditions.fileIsExist(filePath) && Conditions.fileCanRead(filePath)) {
                FileInputStream fis = null;
                File file = new File(filePath);
                try {
                    fis = new FileInputStream(file);
                    byte[] decodeBytes = CompressKit.transformToByteArray(fis);
                    if (options.isKeepSampling) {
                        BitmapFactory.Options decodeOptions = CompressKit.getDefaultDecodeOptions();
                        decodeOptions.inPreferredConfig = options.config;
                        result[0] = BitmapFactory.decodeByteArray((byte[])decodeBytes, (int)0, (int)decodeBytes.length, (BitmapFactory.Options)decodeOptions);
                    } else {
                        result[0] = BitmapCompressor.compress(decodeBytes, (Tiny.BitmapCompressOptions)options, true);
                    }
                }
                finally {
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return result[0];
    }

    private static final class CompatCompressor {
        private CompatCompressor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static boolean compress(Bitmap bitmap, String outfile, int quality, Bitmap.CompressFormat format) throws FileNotFoundException {
            boolean isSuccess = false;
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(outfile);
                isSuccess = bitmap.compress(format, quality, (OutputStream)fos);
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            return isSuccess;
        }
    }
}

