/*
 * Decompiled with CFR 0.152.
 */
package com.externaldisplay;

import android.content.Context;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import com.externaldisplay.ExternalDisplayHelper;
import com.externaldisplay.ExternalDisplayScreen;
import com.facebook.react.ReactRootView;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactContext;
import java.util.ArrayList;

public class RNExternalDisplayView
extends ReactRootView
implements LifecycleEventListener {
    Context context;
    private boolean fallbackInMainScreen = false;
    private ExternalDisplayHelper helper;
    private ExternalDisplayScreen displayScreen;
    private int screen = -1;
    private ArrayList<View> subviews = new ArrayList();
    private ReactRootView wrap;
    private boolean pausedWithDisplayScreen = false;

    public RNExternalDisplayView(Context context, ExternalDisplayHelper helper) {
        super(context);
        ((ReactContext)context).addLifecycleEventListener((LifecycleEventListener)this);
        this.context = context;
        this.helper = helper;
    }

    public void addView(View child, int index) {
        this.subviews.add(index, child);
        this.updateScreen();
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
    }

    public int getChildCount() {
        return this.subviews.size();
    }

    public View getChildAt(int index) {
        return this.subviews.get(index);
    }

    public void removeView(View view) {
        super.removeView(view);
    }

    public void removeViewAt(int index) {
        View child = this.getChildAt(index);
        super.removeView(child);
        this.subviews.remove(index);
        if (this.wrap != null) {
            for (int i = 0; i < this.wrap.getChildCount(); ++i) {
                if (i != index) continue;
                this.wrap.removeViewAt(i);
            }
        }
    }

    public void onDropInstance() {
        ((ReactContext)this.getContext()).removeLifecycleEventListener((LifecycleEventListener)this);
        if (this.wrap != null && this.wrap.getChildCount() > 0) {
            for (int i = 0; i < this.wrap.getChildCount(); ++i) {
                this.wrap.removeViewAt(i);
            }
        }
        this.destroyScreen();
    }

    public void addChildrenForAccessibility(ArrayList<View> outChildren) {
    }

    public void onHostResume() {
        if (this.displayScreen == null && !this.pausedWithDisplayScreen) {
            return;
        }
        this.pausedWithDisplayScreen = false;
        this.updateScreen();
    }

    public void onHostPause() {
        if (this.displayScreen == null) {
            return;
        }
        this.pausedWithDisplayScreen = true;
        if (this.wrap != null) {
            for (int i = 0; i < this.wrap.getChildCount(); ++i) {
                this.wrap.removeViewAt(i);
            }
        }
        this.destroyScreen();
    }

    public void onHostDestroy() {
        this.onDropInstance();
    }

    public void updateScreen() {
        Display display;
        if (this.getChildCount() == 0) {
            return;
        }
        if (this.screen > 0 && (display = this.helper.getDisplay(this.screen)) != null) {
            int i;
            if (this.displayScreen == null) {
                this.displayScreen = new ExternalDisplayScreen(this.context, display);
                this.wrap = new ReactRootView(this.context);
            } else if (this.wrap.getChildCount() > 0) {
                for (i = 0; i < this.wrap.getChildCount(); ++i) {
                    this.wrap.removeViewAt(i);
                }
            }
            for (i = 0; i < this.subviews.size(); ++i) {
                View subview = this.subviews.get(i);
                if (subview.getParent() != null) {
                    ((ViewGroup)subview.getParent()).removeView(subview);
                }
                this.wrap.addView(subview, i);
            }
            this.displayScreen.setContentView((View)this.wrap);
            this.displayScreen.show();
            return;
        }
        if (this.fallbackInMainScreen) {
            if (this.wrap != null) {
                for (int i = 0; i < this.wrap.getChildCount(); ++i) {
                    this.wrap.removeViewAt(i);
                }
            }
            for (int i = 0; i < this.subviews.size(); ++i) {
                View subview = this.subviews.get(i);
                if (subview.getParent() != null) {
                    ((ViewGroup)subview.getParent()).removeView(subview);
                }
                super.addView(subview, i);
            }
        }
    }

    private void destroyScreen() {
        if (this.displayScreen != null) {
            this.displayScreen.hide();
            this.displayScreen.dismiss();
            this.displayScreen = null;
            this.wrap = null;
        }
    }

    public void setScreen(String screen) {
        if (this.getChildCount() > 0 && this.wrap != null && this.wrap.getChildCount() > 0) {
            for (int i = 0; i < this.wrap.getChildCount(); ++i) {
                this.wrap.removeViewAt(i);
            }
        } else {
            for (View subview : this.subviews) {
                this.removeView(subview);
            }
        }
        try {
            int nextScreen = Integer.parseInt(screen);
            if (nextScreen != this.screen) {
                this.destroyScreen();
            }
            this.screen = nextScreen;
        }
        catch (NumberFormatException e) {
            this.destroyScreen();
            this.screen = -1;
        }
        this.updateScreen();
    }

    public int getScreen() {
        return this.screen;
    }

    public void setFallbackInMainScreen(boolean value) {
        this.fallbackInMainScreen = value;
    }
}

