/*
 * Decompiled with CFR 0.152.
 */
package com.externaldisplay;

import android.annotation.TargetApi;
import android.content.Context;
import android.hardware.display.DisplayManager;
import android.util.DisplayMetrics;
import android.view.Display;
import java.util.HashMap;
import java.util.Map;

@TargetApi(value=17)
class ExternalDisplayHelper
implements DisplayManager.DisplayListener {
    private Listener listener = null;
    private DisplayManager dm = null;
    private Display displays = null;

    public static Map<String, Object> getScreenInfo(Display[] displays) {
        HashMap<String, Object> info = new HashMap<String, Object>();
        for (Display display : displays) {
            int displayId = display.getDisplayId();
            if (display.getDisplayId() == 0 || (display.getFlags() & 8) == 0) continue;
            HashMap<String, Integer> data = new HashMap<String, Integer>();
            DisplayMetrics displayMetrics = new DisplayMetrics();
            display.getMetrics(displayMetrics);
            data.put("id", displayId);
            data.put("width", displayMetrics.widthPixels);
            data.put("height", displayMetrics.heightPixels);
            info.put(String.valueOf(display.getDisplayId()), data);
        }
        return info;
    }

    public ExternalDisplayHelper(Context context, Listener listener) {
        this.listener = listener;
        this.dm = (DisplayManager)context.getSystemService("display");
        this.dm.registerDisplayListener((DisplayManager.DisplayListener)this, null);
    }

    public Display getDisplay(int displayId) {
        return this.dm.getDisplay(displayId);
    }

    public Display[] getDisplays() {
        return this.dm.getDisplays("android.hardware.display.category.PRESENTATION");
    }

    public void onDisplayAdded(int displayId) {
        this.listener.onDisplayAdded(this.getDisplays(), displayId);
    }

    public void onDisplayChanged(int displayId) {
        this.listener.onDisplayChanged(this.getDisplays(), displayId);
    }

    public void onDisplayRemoved(int displayId) {
        this.listener.onDisplayRemoved(this.getDisplays(), displayId);
    }

    public static interface Listener {
        public void onDisplayAdded(Display[] var1, int var2);

        public void onDisplayChanged(Display[] var1, int var2);

        public void onDisplayRemoved(Display[] var1, int var2);
    }
}

