/*
 * Decompiled with CFR 0.152.
 */
package com.externaldisplay;

import android.content.Context;
import android.view.Display;
import android.view.View;
import com.externaldisplay.ExternalDisplayHelper;
import com.externaldisplay.RNExternalDisplayView;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.annotations.ReactProp;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class RNExternalDisplayManager
extends ViewGroupManager<RNExternalDisplayView>
implements ExternalDisplayHelper.Listener {
    public static final String REACT_CLASS = "RNExternalDisplay";
    private ExternalDisplayHelper helper;
    private ReactApplicationContext reactContext;
    private Map<RNExternalDisplayView, RNExternalDisplayView> views = new HashMap<RNExternalDisplayView, RNExternalDisplayView>();

    public RNExternalDisplayManager(ReactApplicationContext reactContext) {
        this.reactContext = reactContext;
    }

    public String getName() {
        return REACT_CLASS;
    }

    public RNExternalDisplayView createViewInstance(ThemedReactContext context) {
        if (this.helper == null) {
            this.helper = new ExternalDisplayHelper((Context)this.reactContext, this);
        }
        RNExternalDisplayView view = new RNExternalDisplayView((Context)context, this.helper);
        this.views.put(view, view);
        return view;
    }

    public void onDropViewInstance(RNExternalDisplayView view) {
        this.views.remove((Object)view);
        super.onDropViewInstance((View)view);
        view.onDropInstance();
    }

    private void checkScreen() {
        int screenId = -1;
        for (RNExternalDisplayView view : this.views.values()) {
            int viewScreenId = view.getScreen();
            if (viewScreenId > 0 && screenId == viewScreenId) {
                FLog.e((String)"ReactNative", (String)("Detected two or more RNExternalDisplayView to register the same screen id: " + screenId));
            }
            if (viewScreenId <= 0) continue;
            screenId = viewScreenId;
        }
    }

    @ReactProp(name="screen")
    public void setScreen(RNExternalDisplayView view, @Nullable String screen) {
        view.setScreen(screen);
        this.checkScreen();
    }

    @ReactProp(name="fallbackInMainScreen", defaultBoolean=false)
    public void setFallbackInMainScreen(RNExternalDisplayView view, boolean fallbackInMainScreen) {
        view.setFallbackInMainScreen(fallbackInMainScreen);
    }

    private void sendEvent(String eventName, @Nullable WritableMap params) {
        ((DeviceEventManagerModule.RCTDeviceEventEmitter)this.reactContext.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class)).emit(eventName, (Object)params);
    }

    @Override
    public void onDisplayAdded(Display[] displays, int displayId) {
        this.sendEvent("@RNExternalDisplay_screenDidConnect", (WritableMap)Arguments.makeNativeMap(ExternalDisplayHelper.getScreenInfo(displays)));
    }

    @Override
    public void onDisplayChanged(Display[] displays, int displayId) {
        this.sendEvent("@RNExternalDisplay_screenDidChange", (WritableMap)Arguments.makeNativeMap(ExternalDisplayHelper.getScreenInfo(displays)));
    }

    @Override
    public void onDisplayRemoved(Display[] displays, int displayId) {
        this.sendEvent("@RNExternalDisplay_screenDidDisconnect", (WritableMap)Arguments.makeNativeMap(ExternalDisplayHelper.getScreenInfo(displays)));
    }
}

