/*
 * Decompiled with CFR 0.152.
 */
package com.reactnativefacetec;

import android.content.Context;
import android.util.Log;
import androidx.annotation.Nullable;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.facetec.sdk.FaceTecSDK;
import com.reactnativefacetec.ZoomProcessors.AuthenticateProcessor;
import com.reactnativefacetec.ZoomProcessors.EnrollmentProcessor;
import com.reactnativefacetec.ZoomProcessors.LivenessCheckProcessor;
import com.reactnativefacetec.ZoomProcessors.NetworkingHelpers;
import com.reactnativefacetec.ZoomProcessors.PhotoIDMatchProcessor;
import com.reactnativefacetec.ZoomProcessors.Processor;
import com.reactnativefacetec.ZoomProcessors.ThemeHelpers;
import com.reactnativefacetec.ZoomProcessors.ZoomGlobalState;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;
import okhttp3.Request;
import okhttp3.Response;
import org.json.JSONException;
import org.json.JSONObject;

public class FacetecModule
extends ReactContextBaseJavaModule {
    public static final String REACT_CLASS = "Facetec";
    private static ReactApplicationContext reactContext = null;
    public Processor latestProcessor;
    String sesstionToken;
    Callback onSuccess;
    Callback onFail;
    Processor.SessionTokenErrorCallback sessionTokenErrorCallback = new Processor.SessionTokenErrorCallback(){

        @Override
        public void onError(String msg) {
        }
    };
    Processor.SessionTokenSuccessCallback sessionTokenSuccessCallback = new Processor.SessionTokenSuccessCallback(){

        @Override
        public void onSuccess(String msg) {
            FacetecModule.this.onSuccess.invoke(new Object[]{msg});
        }
    };

    public FacetecModule(ReactApplicationContext context) {
        super(context);
        reactContext = context;
        ThemeHelpers themeHelpers = new ThemeHelpers((Context)context);
        themeHelpers.setAppTheme("Sample Bank");
    }

    public String getName() {
        return REACT_CLASS;
    }

    public Map<String, Object> getConstants() {
        HashMap<String, Object> constants = new HashMap<String, Object>();
        constants.put("EXAMPLE_CONSTANT", "example");
        return constants;
    }

    private static void emitDeviceEvent(String eventName, @Nullable WritableMap eventData) {
        ((DeviceEventManagerModule.RCTDeviceEventEmitter)reactContext.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class)).emit(eventName, (Object)eventData);
    }

    @ReactMethod
    public void Init(final Callback onSuccess, final Callback onFail) {
        this.onSuccess = onSuccess;
        this.onFail = onFail;
        FaceTecSDK.initializeInProductionMode((Context)reactContext, (String)ZoomGlobalState.ProductionKeyText, (String)ZoomGlobalState.DeviceLicenseKeyIdentifier, (String)ZoomGlobalState.PublicFaceMapEncryptionKey, (FaceTecSDK.InitializeCallback)new FaceTecSDK.InitializeCallback(){

            public void onCompletion(boolean b) {
                WritableMap params = Arguments.createMap();
                try {
                    params.putString("initState", b + "");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (b) {
                    params.putBoolean("successful", true);
                    onSuccess.invoke(new Object[]{params});
                } else {
                    onFail.invoke(new Object[]{params});
                    params.putBoolean("successful", false);
                }
            }
        });
    }

    @ReactMethod
    public void Enroll(final String id, Callback onSuccess, final Callback onFail) {
        Request request = new Request.Builder().header("X-Device-Key", ZoomGlobalState.DeviceLicenseKeyIdentifier).url(ZoomGlobalState.ZoomServerBaseURL + "/session-token").get().build();
        NetworkingHelpers.getApiClient().newCall(request).enqueue(new okhttp3.Callback(){

            public void onFailure(Call call, IOException e) {
                e.printStackTrace();
                Log.d((String)"FaceTecSDKSampleApp", (String)"Exception raised while attempting HTTPS call.");
                if (!e.getMessage().equals(NetworkingHelpers.OK_HTTP_RESPONSE_CANCELED)) {
                    onFail.invoke(new Object[]{"Exception raised while attempting HTTPS call"});
                }
            }

            public void onResponse(Call call, Response response) throws IOException {
                String responseString = response.body().string();
                response.body().close();
                try {
                    JSONObject responseJSON = new JSONObject(responseString);
                    if (responseJSON.has("sessionToken")) {
                        FacetecModule.this.sesstionToken = responseJSON.getString("sessionToken");
                        FacetecModule.this.latestProcessor = new EnrollmentProcessor(id, responseJSON.getString("sessionToken"), (Context)FacetecModule.this.getCurrentActivity(), FacetecModule.this.sessionTokenErrorCallback, FacetecModule.this.sessionTokenSuccessCallback);
                    } else {
                        onFail.invoke(new Object[]{"sessionToken invalid"});
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Log.d((String)"FaceTecSDKSampleApp", (String)"Exception raised while attempting to parse JSON result.");
                    onFail.invoke(new Object[]{"Exception raised while attempting to parse JSON result."});
                }
            }
        });
        this.onSuccess = onSuccess;
        this.onFail = onFail;
    }

    @ReactMethod
    public void AuthenticateUser(final String id, Callback onSuccess, final Callback onFail) {
        this.onSuccess = onSuccess;
        this.onFail = onFail;
        Request request = new Request.Builder().header("X-Device-Key", ZoomGlobalState.DeviceLicenseKeyIdentifier).url(ZoomGlobalState.ZoomServerBaseURL + "/session-token").get().build();
        NetworkingHelpers.getApiClient().newCall(request).enqueue(new okhttp3.Callback(){

            public void onFailure(Call call, IOException e) {
                e.printStackTrace();
                Log.d((String)"FaceTecSDKSampleApp", (String)"Exception raised while attempting HTTPS call.");
                if (!e.getMessage().equals(NetworkingHelpers.OK_HTTP_RESPONSE_CANCELED)) {
                    onFail.invoke(new Object[]{"Exception raised while attempting HTTPS call"});
                }
            }

            public void onResponse(Call call, Response response) throws IOException {
                String responseString = response.body().string();
                response.body().close();
                try {
                    JSONObject responseJSON = new JSONObject(responseString);
                    if (responseJSON.has("sessionToken")) {
                        FacetecModule.this.sesstionToken = responseJSON.getString("sessionToken");
                        FacetecModule.this.latestProcessor = new AuthenticateProcessor(FacetecModule.this.sesstionToken, id, (Context)FacetecModule.this.getCurrentActivity(), FacetecModule.this.sessionTokenErrorCallback, FacetecModule.this.sessionTokenSuccessCallback);
                    } else {
                        onFail.invoke(new Object[]{"sessionToken invalid"});
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Log.d((String)"FaceTecSDKSampleApp", (String)"Exception raised while attempting to parse JSON result.");
                    onFail.invoke(new Object[]{"Exception raised while attempting to parse JSON result."});
                }
            }
        });
    }

    @ReactMethod
    public void LivenessCheck(Callback onSuccess, Callback onFail) {
        this.onSuccess = onSuccess;
        this.onFail = onFail;
        this.latestProcessor = new LivenessCheckProcessor(this.sesstionToken, (Context)this.getCurrentActivity());
    }

    @ReactMethod
    public void CheckId(final String id, Callback onSuccess, final Callback onFail) {
        this.onSuccess = onSuccess;
        this.onFail = onFail;
        Request request = new Request.Builder().header("X-Device-Key", ZoomGlobalState.DeviceLicenseKeyIdentifier).url(ZoomGlobalState.ZoomServerBaseURL + "/session-token").get().build();
        NetworkingHelpers.getApiClient().newCall(request).enqueue(new okhttp3.Callback(){

            public void onFailure(Call call, IOException e) {
                e.printStackTrace();
                Log.d((String)"FaceTecSDKSampleApp", (String)"Exception raised while attempting HTTPS call.");
                if (!e.getMessage().equals(NetworkingHelpers.OK_HTTP_RESPONSE_CANCELED)) {
                    onFail.invoke(new Object[]{"Exception raised while attempting HTTPS call"});
                }
            }

            public void onResponse(Call call, Response response) throws IOException {
                String responseString = response.body().string();
                response.body().close();
                try {
                    JSONObject responseJSON = new JSONObject(responseString);
                    if (responseJSON.has("sessionToken")) {
                        FacetecModule.this.sesstionToken = responseJSON.getString("sessionToken");
                        FacetecModule.this.latestProcessor = new PhotoIDMatchProcessor(id, FacetecModule.this.sesstionToken, (Context)FacetecModule.this.getCurrentActivity(), FacetecModule.this.sessionTokenErrorCallback, FacetecModule.this.sessionTokenSuccessCallback);
                    } else {
                        onFail.invoke(new Object[]{"sessionToken invalid"});
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Log.d((String)"FaceTecSDKSampleApp", (String)"Exception raised while attempting to parse JSON result.");
                    onFail.invoke(new Object[]{"Exception raised while attempting to parse JSON result."});
                }
            }
        });
    }
}

