/*
 * Decompiled with CFR 0.152.
 */
package com.reactnativefacetec.ZoomProcessors;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.facetec.sdk.FaceTecCustomization;
import com.facetec.sdk.FaceTecFaceScanProcessor;
import com.facetec.sdk.FaceTecFaceScanResultCallback;
import com.facetec.sdk.FaceTecSDK;
import com.facetec.sdk.FaceTecSessionActivity;
import com.facetec.sdk.FaceTecSessionResult;
import com.facetec.sdk.FaceTecSessionStatus;
import com.reactnativefacetec.ZoomProcessors.NetworkingHelpers;
import com.reactnativefacetec.ZoomProcessors.Processor;
import com.reactnativefacetec.ZoomProcessors.ProgressRequestBody;
import com.reactnativefacetec.ZoomProcessors.ZoomGlobalState;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONException;
import org.json.JSONObject;

public class AuthenticateProcessor
extends Processor
implements FaceTecFaceScanProcessor {
    private boolean _isSuccess = false;
    Processor.SessionTokenSuccessCallback sessionTokenSuccessCallback;
    Processor.SessionTokenErrorCallback sessionTokenErrorCallback;
    String id;

    public AuthenticateProcessor(String sessionToken, Context context) {
        FaceTecSessionActivity.createAndLaunchSession((Context)context, (FaceTecFaceScanProcessor)this, (String)sessionToken);
    }

    public AuthenticateProcessor(String token, String id, Context context, Processor.SessionTokenErrorCallback sessionTokenErrorCallback, Processor.SessionTokenSuccessCallback sessionTokenSuccessCallback) {
        this.sessionTokenSuccessCallback = sessionTokenSuccessCallback;
        this.sessionTokenErrorCallback = sessionTokenErrorCallback;
        FaceTecSessionActivity.createAndLaunchSession((Context)context, (FaceTecFaceScanProcessor)this, (String)token);
        this.id = id;
    }

    public void processSessionWhileFaceTecSDKWaits(FaceTecSessionResult sessionResult, final FaceTecFaceScanResultCallback faceScanResultCallback) {
        if (sessionResult.getStatus() != FaceTecSessionStatus.SESSION_COMPLETED_SUCCESSFULLY) {
            NetworkingHelpers.cancelPendingRequests();
            faceScanResultCallback.cancel();
            return;
        }
        JSONObject parameters = new JSONObject();
        try {
            parameters.put("faceScan", (Object)sessionResult.getFaceScanBase64());
            parameters.put("auditTrailImage", (Object)sessionResult.getAuditTrailCompressedBase64()[0]);
            parameters.put("lowQualityAuditTrailImage", (Object)sessionResult.getLowQualityAuditTrailCompressedBase64()[0]);
            parameters.put("externalDatabaseRefID", (Object)this.id);
        }
        catch (JSONException e) {
            e.printStackTrace();
            Log.d((String)"FaceTecSDKSampleApp", (String)"Exception raised while attempting to create JSON payload for upload.");
        }
        Request request = new Request.Builder().url(ZoomGlobalState.ZoomServerBaseURL + "/match-3d-3d").header("Content-Type", "application/json").header("X-Device-Key", ZoomGlobalState.DeviceLicenseKeyIdentifier).header("User-Agent", FaceTecSDK.createFaceTecAPIUserAgentString((String)sessionResult.getSessionId())).post((RequestBody)new ProgressRequestBody(RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)parameters.toString()), new ProgressRequestBody.Listener(){

            @Override
            public void onUploadProgressChanged(long bytesWritten, long totalBytes) {
                float uploadProgressPercent = (float)bytesWritten / (float)totalBytes;
                faceScanResultCallback.uploadProgress(uploadProgressPercent);
            }
        })).build();
        NetworkingHelpers.getApiClient().newCall(request).enqueue(new Callback(){

            public void onResponse(Call call, Response response) throws IOException {
                String responseString = response.body().string();
                response.body().close();
                try {
                    JSONObject responseJSON = new JSONObject(responseString);
                    boolean didSucceed = responseJSON.getBoolean("success");
                    if (didSucceed) {
                        AuthenticateProcessor.this._isSuccess = true;
                        FaceTecCustomization.overrideResultScreenSuccessMessage = "Authenticated";
                        faceScanResultCallback.succeed();
                        AuthenticateProcessor.this.sessionTokenSuccessCallback.onSuccess(responseJSON.toString());
                    } else if (!didSucceed) {
                        faceScanResultCallback.retry();
                        AuthenticateProcessor.this.sessionTokenErrorCallback.onError("AuthenticateProcessor");
                    } else {
                        faceScanResultCallback.cancel();
                        AuthenticateProcessor.this.sessionTokenErrorCallback.onError("AuthenticateProcessor");
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    AuthenticateProcessor.this.sessionTokenErrorCallback.onError("AuthenticateProcessor");
                    Log.d((String)"FaceTecSDKSampleApp", (String)"Exception raised while attempting to parse JSON result.");
                    faceScanResultCallback.cancel();
                }
            }

            public void onFailure(Call call, IOException e) {
                Log.d((String)"FaceTecSDKSampleApp", (String)"Exception raised while attempting HTTPS call.");
                AuthenticateProcessor.this.sessionTokenErrorCallback.onError("AuthenticateProcessor");
                faceScanResultCallback.cancel();
            }
        });
        new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

            @Override
            public void run() {
                if (faceScanResultCallback == null) {
                    return;
                }
                faceScanResultCallback.uploadMessageOverride("Still Uploading...");
            }
        }, 6000L);
    }

    @Override
    public boolean isSuccess() {
        return this._isSuccess;
    }
}

