/*
 * Decompiled with CFR 0.152.
 */
package com.reactnativefacetec.ZoomProcessors;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.facetec.sdk.FaceTecCustomization;
import com.facetec.sdk.FaceTecFaceScanProcessor;
import com.facetec.sdk.FaceTecFaceScanResultCallback;
import com.facetec.sdk.FaceTecSDK;
import com.facetec.sdk.FaceTecSessionActivity;
import com.facetec.sdk.FaceTecSessionResult;
import com.facetec.sdk.FaceTecSessionStatus;
import com.reactnativefacetec.ZoomProcessors.NetworkingHelpers;
import com.reactnativefacetec.ZoomProcessors.Processor;
import com.reactnativefacetec.ZoomProcessors.ProgressRequestBody;
import com.reactnativefacetec.ZoomProcessors.ZoomGlobalState;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONException;
import org.json.JSONObject;

public class LivenessCheckProcessor
extends Processor
implements FaceTecFaceScanProcessor {
    Processor.SessionTokenSuccessCallback sessionTokenSuccessCallback;
    private boolean _isSuccess = false;

    public LivenessCheckProcessor(String sessionToken, Context context) {
        FaceTecSessionActivity.createAndLaunchSession((Context)context, (FaceTecFaceScanProcessor)this, (String)sessionToken);
    }

    @Override
    public boolean isSuccess() {
        return this._isSuccess;
    }

    public void processSessionWhileFaceTecSDKWaits(FaceTecSessionResult sessionResult, final FaceTecFaceScanResultCallback faceScanResultCallback) {
        if (sessionResult.getStatus() != FaceTecSessionStatus.SESSION_COMPLETED_SUCCESSFULLY) {
            NetworkingHelpers.cancelPendingRequests();
            faceScanResultCallback.cancel();
            return;
        }
        JSONObject parameters = new JSONObject();
        try {
            parameters.put("faceScan", (Object)sessionResult.getFaceScanBase64());
            parameters.put("auditTrailImage", (Object)sessionResult.getAuditTrailCompressedBase64()[0]);
            parameters.put("lowQualityAuditTrailImage", (Object)sessionResult.getLowQualityAuditTrailCompressedBase64()[0]);
        }
        catch (JSONException e) {
            e.printStackTrace();
            Log.d((String)"FaceTecSDKSampleApp", (String)"Exception raised while attempting to create JSON payload for upload.");
        }
        Request request = new Request.Builder().url(ZoomGlobalState.ZoomServerBaseURL + "/liveness-3d").header("Content-Type", "application/json").header("X-Device-Key", ZoomGlobalState.DeviceLicenseKeyIdentifier).header("User-Agent", FaceTecSDK.createFaceTecAPIUserAgentString((String)sessionResult.getSessionId())).post((RequestBody)new ProgressRequestBody(RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)parameters.toString()), new ProgressRequestBody.Listener(){

            @Override
            public void onUploadProgressChanged(long bytesWritten, long totalBytes) {
                float uploadProgressPercent = (float)bytesWritten / (float)totalBytes;
                faceScanResultCallback.uploadProgress(uploadProgressPercent);
            }
        })).build();
        NetworkingHelpers.getApiClient().newCall(request).enqueue(new Callback(){

            public void onResponse(Call call, Response response) throws IOException {
                String responseString = response.body().string();
                response.body().close();
                try {
                    JSONObject responseJSON = new JSONObject(responseString);
                    boolean didSucceed = responseJSON.getBoolean("success");
                    if (didSucceed) {
                        LivenessCheckProcessor.this._isSuccess = true;
                        FaceTecCustomization.overrideResultScreenSuccessMessage = "Liveness\nConfirmed";
                        faceScanResultCallback.succeed();
                    } else if (!didSucceed) {
                        faceScanResultCallback.retry();
                    } else {
                        faceScanResultCallback.cancel();
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Log.d((String)"FaceTecSDKSampleApp", (String)"Exception raised while attempting to parse JSON result.");
                    faceScanResultCallback.cancel();
                }
            }

            public void onFailure(Call call, IOException e) {
                Log.d((String)"FaceTecSDKSampleApp", (String)"Exception raised while attempting HTTPS call.");
                faceScanResultCallback.cancel();
            }
        });
        new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

            @Override
            public void run() {
                if (faceScanResultCallback == null) {
                    return;
                }
                faceScanResultCallback.uploadMessageOverride("Still Uploading...");
            }
        }, 6000L);
    }
}

