/*
 * Decompiled with CFR 0.152.
 */
package com.reactnativefacetec.ZoomProcessors;

import android.os.Build;
import com.reactnativefacetec.ZoomProcessors.TLSSocketFactory;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocketFactory;
import okhttp3.Call;
import okhttp3.OkHttpClient;

public class NetworkingHelpers {
    private static OkHttpClient _apiClient = null;
    public static String OK_HTTP_BUILDER_TAG = "APIRequest";
    public static String OK_HTTP_RESPONSE_CANCELED = "Canceled";

    private static OkHttpClient createApiClient() {
        OkHttpClient client = new OkHttpClient.Builder().connectTimeout(60L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).writeTimeout(60L, TimeUnit.SECONDS).build();
        if (Build.VERSION.SDK_INT < 21) {
            try {
                client = new OkHttpClient.Builder().sslSocketFactory((SSLSocketFactory)new TLSSocketFactory()).build();
            }
            catch (KeyManagementException e) {
                e.printStackTrace();
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            return client;
        }
        return client;
    }

    public static synchronized OkHttpClient getApiClient() {
        if (_apiClient == null) {
            _apiClient = NetworkingHelpers.createApiClient();
        }
        return _apiClient;
    }

    public static void cancelPendingRequests() {
        OkHttpClient client = NetworkingHelpers.getApiClient();
        for (Call call : client.dispatcher().queuedCalls()) {
            if (!Objects.equals(call.request().tag(), OK_HTTP_BUILDER_TAG)) continue;
            call.cancel();
        }
        for (Call call : client.dispatcher().runningCalls()) {
            if (!Objects.equals(call.request().tag(), OK_HTTP_BUILDER_TAG)) continue;
            call.cancel();
        }
    }
}

