/*
 * Decompiled with CFR 0.152.
 */
package com.reactnativefacetec.ZoomProcessors;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.facetec.sdk.FaceTecCustomization;
import com.facetec.sdk.FaceTecFaceScanProcessor;
import com.facetec.sdk.FaceTecFaceScanResultCallback;
import com.facetec.sdk.FaceTecIDScanProcessor;
import com.facetec.sdk.FaceTecIDScanResult;
import com.facetec.sdk.FaceTecIDScanResultCallback;
import com.facetec.sdk.FaceTecIDScanRetryMode;
import com.facetec.sdk.FaceTecIDScanStatus;
import com.facetec.sdk.FaceTecSDK;
import com.facetec.sdk.FaceTecSessionActivity;
import com.facetec.sdk.FaceTecSessionResult;
import com.facetec.sdk.FaceTecSessionStatus;
import com.reactnativefacetec.ZoomProcessors.NetworkingHelpers;
import com.reactnativefacetec.ZoomProcessors.Processor;
import com.reactnativefacetec.ZoomProcessors.ProgressRequestBody;
import com.reactnativefacetec.ZoomProcessors.ZoomGlobalState;
import java.io.IOException;
import java.util.ArrayList;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONException;
import org.json.JSONObject;

public class PhotoIDMatchProcessor
extends Processor
implements FaceTecFaceScanProcessor,
FaceTecIDScanProcessor {
    private boolean _isSuccess = false;
    Processor.SessionTokenSuccessCallback sessionTokenSuccessCallback;
    Processor.SessionTokenErrorCallback sessionTokenErrorCallback;
    String id;
    ArrayList<String> frontImagesCompressedBase64;
    ArrayList<String> backImagesCompressedBase64;

    public PhotoIDMatchProcessor(String userId, String id, Context context, Processor.SessionTokenErrorCallback sessionTokenErrorCallback, Processor.SessionTokenSuccessCallback sessionTokenSuccessCallback) {
        this.sessionTokenSuccessCallback = sessionTokenSuccessCallback;
        this.sessionTokenErrorCallback = sessionTokenErrorCallback;
        this.id = userId;
        FaceTecSessionActivity.createAndLaunchSession((Context)context, (FaceTecFaceScanProcessor)this, (FaceTecIDScanProcessor)this, (String)id);
    }

    @Override
    public boolean isSuccess() {
        return this._isSuccess;
    }

    public void processSessionWhileFaceTecSDKWaits(FaceTecSessionResult sessionResult, final FaceTecFaceScanResultCallback faceScanResultCallback) {
        if (sessionResult.getStatus() != FaceTecSessionStatus.SESSION_COMPLETED_SUCCESSFULLY) {
            NetworkingHelpers.cancelPendingRequests();
            faceScanResultCallback.cancel();
            this.sessionTokenErrorCallback.onError("PhotoIDMatchProcessor");
            return;
        }
        JSONObject parameters = new JSONObject();
        try {
            parameters.put("faceScan", (Object)sessionResult.getFaceScanBase64());
            parameters.put("auditTrailImage", (Object)sessionResult.getAuditTrailCompressedBase64()[0]);
            parameters.put("lowQualityAuditTrailImage", (Object)sessionResult.getLowQualityAuditTrailCompressedBase64()[0]);
            parameters.put("externalDatabaseRefID", (Object)this.id);
        }
        catch (JSONException e) {
            e.printStackTrace();
            Log.d((String)"FaceTecSDKSampleApp", (String)"Exception raised while attempting to create JSON payload for upload.");
        }
        Request request = new Request.Builder().url(ZoomGlobalState.ZoomServerBaseURL + "/enrollment-3d").header("Content-Type", "application/json").header("X-Device-Key", ZoomGlobalState.DeviceLicenseKeyIdentifier).header("User-Agent", FaceTecSDK.createFaceTecAPIUserAgentString((String)sessionResult.getSessionId())).post((RequestBody)new ProgressRequestBody(RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)parameters.toString()), new ProgressRequestBody.Listener(){

            @Override
            public void onUploadProgressChanged(long bytesWritten, long totalBytes) {
                float uploadProgressPercent = (float)bytesWritten / (float)totalBytes;
                faceScanResultCallback.uploadProgress(uploadProgressPercent);
            }
        })).build();
        NetworkingHelpers.getApiClient().newCall(request).enqueue(new Callback(){

            public void onResponse(Call call, Response response) throws IOException {
                String responseString = response.body().string();
                response.body().close();
                try {
                    JSONObject responseJSON = new JSONObject(responseString);
                    boolean didSucceed = responseJSON.getBoolean("success");
                    String message = responseJSON.getString("errorMessage");
                    if (didSucceed) {
                        FaceTecCustomization.overrideResultScreenSuccessMessage = "Liveness\nConfirmed";
                        faceScanResultCallback.succeed();
                    } else if (message.contains("already")) {
                        FaceTecCustomization.overrideResultScreenSuccessMessage = "Liveness\nConfirmed";
                        faceScanResultCallback.succeed();
                    } else if (!didSucceed) {
                        faceScanResultCallback.retry();
                    } else {
                        faceScanResultCallback.cancel();
                        PhotoIDMatchProcessor.this.sessionTokenErrorCallback.onError("PhotoIDMatchProcessor");
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Log.d((String)"FaceTecSDKSampleApp", (String)"Exception raised while attempting to parse JSON result.");
                    faceScanResultCallback.cancel();
                    PhotoIDMatchProcessor.this.sessionTokenErrorCallback.onError("PhotoIDMatchProcessor");
                }
            }

            public void onFailure(Call call, IOException e) {
                Log.d((String)"FaceTecSDKSampleApp", (String)"Exception raised while attempting HTTPS call.");
                faceScanResultCallback.cancel();
                PhotoIDMatchProcessor.this.sessionTokenErrorCallback.onError("PhotoIDMatchProcessor");
            }
        });
        new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

            @Override
            public void run() {
                if (faceScanResultCallback == null) {
                    return;
                }
                faceScanResultCallback.uploadMessageOverride("Still Uploading...");
            }
        }, 6000L);
    }

    public void processIDScanWhileFaceTecSDKWaits(FaceTecIDScanResult idScanResult, final FaceTecIDScanResultCallback idScanResultCallback) {
        if (idScanResult.getStatus() != FaceTecIDScanStatus.SUCCESS) {
            NetworkingHelpers.cancelPendingRequests();
            idScanResultCallback.cancel();
            this.sessionTokenErrorCallback.onError("PhotoIDMatchProcessor");
            return;
        }
        int minMatchLevel = 3;
        JSONObject parameters = new JSONObject();
        try {
            parameters.put("externalDatabaseRefID", (Object)this.id);
            parameters.put("idScan", (Object)idScanResult.getIDScanBase64());
            parameters.put("minMatchLevel", 3);
            this.frontImagesCompressedBase64 = idScanResult.getFrontImagesCompressedBase64();
            this.backImagesCompressedBase64 = idScanResult.getBackImagesCompressedBase64();
            if (this.frontImagesCompressedBase64.size() > 0) {
                parameters.put("idScanFrontImage", (Object)this.frontImagesCompressedBase64.get(0));
            }
            if (this.backImagesCompressedBase64.size() > 0) {
                parameters.put("idScanBackImage", (Object)this.backImagesCompressedBase64.get(0));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            this.sessionTokenErrorCallback.onError("PhotoIDMatchProcessor");
            Log.d((String)"FaceTecSDKSampleApp", (String)"Exception raised while attempting to create JSON payload for upload.");
        }
        Request request = new Request.Builder().url(ZoomGlobalState.ZoomServerBaseURL + "/match-3d-2d-idscan").header("Content-Type", "application/json").header("X-Device-Key", ZoomGlobalState.DeviceLicenseKeyIdentifier).header("User-Agent", FaceTecSDK.createFaceTecAPIUserAgentString((String)idScanResult.getSessionId())).post((RequestBody)new ProgressRequestBody(RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)parameters.toString()), new ProgressRequestBody.Listener(){

            @Override
            public void onUploadProgressChanged(long bytesWritten, long totalBytes) {
                float uploadProgressPercent = (float)bytesWritten / (float)totalBytes;
                idScanResultCallback.uploadProgress(uploadProgressPercent);
            }
        })).build();
        NetworkingHelpers.getApiClient().newCall(request).enqueue(new Callback(){

            public void onResponse(Call call, Response response) throws IOException {
                String responseString = response.body().string();
                response.body().close();
                try {
                    JSONObject responseJSON = new JSONObject(responseString);
                    boolean didSucceed = responseJSON.getBoolean("success");
                    int fullIDStatusEnumInt = responseJSON.getInt("fullIDStatusEnumInt");
                    int digitalIDSpoofStatusEnumInt = responseJSON.getInt("digitalIDSpoofStatusEnumInt");
                    if (didSucceed) {
                        PhotoIDMatchProcessor.this._isSuccess = true;
                        FaceTecCustomization.overrideResultScreenSuccessMessage = "Your 3D Face\nMatched Your ID";
                        idScanResultCallback.succeed();
                        JSONObject obj = new JSONObject();
                        try {
                            obj.put("responseJSON", (Object)responseJSON.toString());
                            obj.put("FrontImagesCompressedBase64", (Object)PhotoIDMatchProcessor.this.frontImagesCompressedBase64.toString());
                            obj.put("BackImagesCompressedBase64", (Object)PhotoIDMatchProcessor.this.backImagesCompressedBase64.toString());
                            PhotoIDMatchProcessor.this.sessionTokenSuccessCallback.onSuccess(obj.toString());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            obj.put("responseJSON", (Object)responseJSON.getJSONObject("data").toString());
                            PhotoIDMatchProcessor.this.sessionTokenSuccessCallback.onSuccess(obj.toString());
                        }
                    } else if (!didSucceed) {
                        if (fullIDStatusEnumInt == 1 || digitalIDSpoofStatusEnumInt == 1) {
                            idScanResultCallback.retry(FaceTecIDScanRetryMode.FRONT, "Photo ID\nNot Fully Visible");
                        } else {
                            idScanResultCallback.retry(FaceTecIDScanRetryMode.FRONT);
                        }
                        PhotoIDMatchProcessor.this.sessionTokenErrorCallback.onError("PhotoIDMatchProcessor");
                    } else {
                        idScanResultCallback.cancel();
                        PhotoIDMatchProcessor.this.sessionTokenErrorCallback.onError("PhotoIDMatchProcessor");
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Log.d((String)"FaceTecSDKSampleApp", (String)"Exception raised while attempting to parse JSON result.");
                    idScanResultCallback.cancel();
                    PhotoIDMatchProcessor.this.sessionTokenErrorCallback.onError("PhotoIDMatchProcessor");
                }
            }

            public void onFailure(Call call, IOException e) {
                Log.d((String)"FaceTecSDKSampleApp", (String)"Exception raised while attempting HTTPS call.");
                idScanResultCallback.cancel();
                PhotoIDMatchProcessor.this.sessionTokenErrorCallback.onError("PhotoIDMatchProcessor");
            }
        });
        new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

            @Override
            public void run() {
                if (idScanResultCallback == null) {
                    return;
                }
                idScanResultCallback.uploadMessageOverride("Still Uploading...");
            }
        }, 6000L);
    }
}

