/*
 * Decompiled with CFR 0.152.
 */
package com.reactnativefacetec.ZoomProcessors;

import androidx.annotation.NonNull;
import java.io.IOException;
import java.io.OutputStream;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;

class ProgressRequestBody
extends RequestBody {
    private final RequestBody requestBody;
    private Listener listener;

    ProgressRequestBody(RequestBody requestBody, Listener listener) {
        this.requestBody = requestBody;
        this.listener = listener;
    }

    public MediaType contentType() {
        return this.requestBody.contentType();
    }

    public long contentLength() throws IOException {
        return this.requestBody.contentLength();
    }

    public void writeTo(BufferedSink sink) throws IOException {
        ProgressStream progressStream = new ProgressStream(sink.outputStream(), this.contentLength());
        BufferedSink progressSink = Okio.buffer((Sink)Okio.sink((OutputStream)progressStream));
        this.requestBody.writeTo(progressSink);
        progressSink.flush();
    }

    static interface Listener {
        public void onUploadProgressChanged(long var1, long var3);
    }

    protected final class ProgressStream
    extends OutputStream {
        private final OutputStream stream;
        private long totalBytes;
        private long bytesSent;

        ProgressStream(OutputStream stream, long totalBytes) {
            this.stream = stream;
            this.totalBytes = totalBytes;
        }

        @Override
        public void write(@NonNull byte[] b, int off, int len) throws IOException {
            this.stream.write(b, off, len);
            this.bytesSent = len < b.length ? (this.bytesSent += (long)len) : (this.bytesSent += (long)b.length);
            ProgressRequestBody.this.listener.onUploadProgressChanged(this.bytesSent, this.totalBytes);
        }

        @Override
        public void write(int b) throws IOException {
            this.stream.write(b);
            ++this.bytesSent;
            ProgressRequestBody.this.listener.onUploadProgressChanged(this.bytesSent, this.totalBytes);
        }
    }
}

