/*
 * Decompiled with CFR 0.152.
 */
package com.freshchat.consumer.sdk.react;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapKeySetIterator;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.bridge.WritableNativeMap;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.freshchat.consumer.sdk.ConversationOptions;
import com.freshchat.consumer.sdk.Event;
import com.freshchat.consumer.sdk.FaqOptions;
import com.freshchat.consumer.sdk.Freshchat;
import com.freshchat.consumer.sdk.FreshchatCallbackStatus;
import com.freshchat.consumer.sdk.FreshchatConfig;
import com.freshchat.consumer.sdk.FreshchatMessage;
import com.freshchat.consumer.sdk.FreshchatNotificationConfig;
import com.freshchat.consumer.sdk.FreshchatUser;
import com.freshchat.consumer.sdk.FreshchatUserInteractionListener;
import com.freshchat.consumer.sdk.FreshchatWebViewListener;
import com.freshchat.consumer.sdk.JwtTokenStatus;
import com.freshchat.consumer.sdk.LinkHandler;
import com.freshchat.consumer.sdk.UnreadCountCallback;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class RNFreshchatSdk
extends ReactContextBaseJavaModule {
    private static final String LOG_TAG = "RNFreshchatSdk";
    private static final String FRESHCHAT_ACTION_USER_INTERACTION = "com.freshchat.consumer.sdk.reactnative.actions.UserInteraction";
    private static final String ACTION_OPEN_LINKS = "ACTION_OPEN_LINKS";
    private static final String ACTION_LOCALE_CHANGED_BY_WEBVIEW = "ACTION_LOCALE_CHANGED_BY_WEBVIEW";
    private final FreshchatSDKBroadcastReceiver restoreIdUpdatesReceiver;
    private final FreshchatSDKBroadcastReceiver messageCountUpdatesReceiver;
    private final FreshchatSDKBroadcastReceiver userActionsReceiver;
    private final FreshchatSDKBroadcastReceiver notificationClickReceiver;
    private final FreshchatSDKBroadcastReceiver jwtRefreshEventReceiver;
    private FreshchatUserInteractionListener userInteractionListener = new FreshchatUserInteractionListener(){

        public void onUserInteraction() {
            RNFreshchatSdk.this.emitEvent(RNFreshchatSdk.this.getReactApplicationContext(), RNFreshchatSdk.FRESHCHAT_ACTION_USER_INTERACTION, null);
        }

        public void onUserLeaveHint() {
            RNFreshchatSdk.this.emitEvent(RNFreshchatSdk.this.getReactApplicationContext(), RNFreshchatSdk.FRESHCHAT_ACTION_USER_INTERACTION, null);
        }
    };
    private LinkHandler linkHandler = new LinkHandler(){

        public boolean handleLink(@NonNull String url, @Nullable Bundle bundle) {
            WritableNativeMap map = new WritableNativeMap();
            map.putString("url", url);
            RNFreshchatSdk.this.emitEvent(RNFreshchatSdk.this.getReactApplicationContext(), RNFreshchatSdk.ACTION_OPEN_LINKS, (WritableMap)map);
            return true;
        }
    };
    private FreshchatWebViewListener webviewListener = new FreshchatWebViewListener(){

        public void onLocaleChangedByWebView(@NonNull WeakReference<Context> activityContext) {
            WritableNativeMap map = new WritableNativeMap();
            RNFreshchatSdk.this.emitEvent(RNFreshchatSdk.this.getReactApplicationContext(), RNFreshchatSdk.ACTION_LOCALE_CHANGED_BY_WEBVIEW, (WritableMap)map);
        }
    };

    public RNFreshchatSdk(@NonNull ReactApplicationContext reactcontext) {
        super(reactcontext);
        this.restoreIdUpdatesReceiver = new FreshchatSDKBroadcastReceiver(reactcontext, "com.freshchat.consumer.sdk.UserRestoreIdGenerated");
        this.messageCountUpdatesReceiver = new FreshchatSDKBroadcastReceiver(reactcontext, "com.freshchat.consumer.sdk.MessageCountChanged");
        this.userActionsReceiver = new FreshchatSDKBroadcastReceiver(reactcontext, "com.freshchat.consumer.sdk.FreshchatEvents");
        this.notificationClickReceiver = new FreshchatSDKBroadcastReceiver(reactcontext, "com.freshchat.consumer.sdk.FreshchatNotificationIntercepted");
        this.jwtRefreshEventReceiver = new FreshchatSDKBroadcastReceiver(reactcontext, "com.freshchat.consumer.sdk.actions.SetTokenToRefreshDeviceProperties");
    }

    public Map<String, Object> getConstants() {
        HashMap<String, Object> constants = new HashMap<String, Object>();
        HashMap<String, Integer> notificationPriorityMap = new HashMap<String, Integer>();
        notificationPriorityMap.put("PRIORITY_DEFAULT", 0);
        notificationPriorityMap.put("PRIORITY_HIGH", 1);
        notificationPriorityMap.put("PRIORITY_LOW", -1);
        notificationPriorityMap.put("PRIORITY_MAX", 2);
        notificationPriorityMap.put("PRIORITY_MIN", -2);
        HashMap<String, Integer> notificationImportanceMap = new HashMap<String, Integer>();
        notificationImportanceMap.put("NONE", 0);
        notificationImportanceMap.put("MIN", 1);
        notificationImportanceMap.put("LOW", 2);
        notificationImportanceMap.put("DEFAULT", 3);
        notificationImportanceMap.put("HIGH", 4);
        notificationImportanceMap.put("MAX", 5);
        HashMap<String, String> FilterType2 = new HashMap<String, String>();
        FilterType2.put("ARTICLE", "article");
        FilterType2.put("CATEGORY", "category");
        constants.put("NotificationPriority", notificationPriorityMap);
        constants.put("NotificationImportance", notificationImportanceMap);
        constants.put("FilterType", FilterType2);
        constants.put("ACTION_USER_RESTORE_ID_GENERATED", "com.freshchat.consumer.sdk.UserRestoreIdGenerated");
        constants.put("ACTION_UNREAD_MESSAGE_COUNT_CHANGED", "com.freshchat.consumer.sdk.MessageCountChanged");
        constants.put("ACTION_USER_INTERACTION", FRESHCHAT_ACTION_USER_INTERACTION);
        constants.put("ACTION_FRESHCHAT_EVENTS", "com.freshchat.consumer.sdk.FreshchatEvents");
        constants.put(ACTION_OPEN_LINKS, ACTION_OPEN_LINKS);
        constants.put(ACTION_LOCALE_CHANGED_BY_WEBVIEW, ACTION_LOCALE_CHANGED_BY_WEBVIEW);
        constants.put("FRESHCHAT_ACTION_NOTIFICATION_CLICK_LISTENER", "com.freshchat.consumer.sdk.FreshchatNotificationIntercepted");
        constants.put("ACTION_SET_TOKEN_TO_REFRESH_DEVICE_PROPERTIES", "com.freshchat.consumer.sdk.actions.SetTokenToRefreshDeviceProperties");
        return constants;
    }

    public String getName() {
        return LOG_TAG;
    }

    public Bundle jsonToBundle(@NonNull ReadableMap readableMap) {
        Bundle bundle = new Bundle();
        ReadableMapKeySetIterator iterator = readableMap.keySetIterator();
        HashMap params = readableMap.toHashMap();
        if (params.size() == 0) {
            return bundle;
        }
        while (iterator.hasNextKey()) {
            String key = iterator.nextKey();
            ReadableType type = readableMap.getType(key);
            try {
                switch (type) {
                    case Null: {
                        bundle.putString(key, null);
                        break;
                    }
                    case Boolean: {
                        bundle.putBoolean(key, readableMap.getBoolean(key));
                        break;
                    }
                    case Number: {
                        bundle.putDouble(key, readableMap.getDouble(key));
                        break;
                    }
                    case String: {
                        bundle.putString(key, readableMap.getString(key));
                        break;
                    }
                    default: {
                        bundle.putString(key, readableMap.getString(key));
                        break;
                    }
                }
            }
            catch (Exception e) {
                Log.w((String)LOG_TAG, (String)e.toString());
            }
        }
        return bundle;
    }

    @ReactMethod
    public void init(@NonNull ReadableMap initArgs) {
        try {
            if (initArgs == null || initArgs.toHashMap().size() == 0) {
                Log.e((String)LOG_TAG, (String)"Please provide parameters to init()");
                return;
            }
            if (!initArgs.hasKey("appId") || !initArgs.hasKey("appKey")) {
                Log.e((String)LOG_TAG, (String)"appId and appKey are mandatory parameters");
                return;
            }
            String appId = initArgs.getString("appId");
            String appKey = initArgs.getString("appKey");
            FreshchatConfig freshchatConfig = new FreshchatConfig(appId, appKey);
            if (initArgs.hasKey("domain")) {
                freshchatConfig.setDomain(initArgs.getString("domain"));
            }
            if (initArgs.hasKey("cameraCaptureEnabled")) {
                freshchatConfig.setCameraCaptureEnabled(initArgs.getBoolean("cameraCaptureEnabled"));
            }
            if (initArgs.hasKey("gallerySelectionEnabled")) {
                freshchatConfig.setGallerySelectionEnabled(initArgs.getBoolean("gallerySelectionEnabled"));
            }
            if (initArgs.hasKey("fileSelectionEnabled")) {
                freshchatConfig.setFileSelectionEnabled(initArgs.getBoolean("fileSelectionEnabled"));
            }
            if (initArgs.hasKey("teamMemberInfoVisible")) {
                freshchatConfig.setTeamMemberInfoVisible(initArgs.getBoolean("teamMemberInfoVisible"));
            }
            if (initArgs.hasKey("responseExpectationEnabled")) {
                freshchatConfig.setResponseExpectationEnabled(initArgs.getBoolean("responseExpectationEnabled"));
            }
            Freshchat.getInstance((Context)this.getContext()).init(freshchatConfig);
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)e.toString());
        }
    }

    @ReactMethod
    public void showFAQs() {
        Freshchat.showFAQs((Context)this.getContext());
    }

    @ReactMethod
    public void showFAQsWithOptions(@NonNull ReadableMap faqArgs) {
        try {
            ReadableArray contactusTags;
            ReadableArray readableArray;
            if (faqArgs == null) {
                return;
            }
            FaqOptions faqOptions = new FaqOptions();
            if (faqArgs.hasKey("showFaqCategoriesAsGrid")) {
                faqOptions.showFaqCategoriesAsGrid(faqArgs.getBoolean("showFaqCategoriesAsGrid"));
            }
            if (faqArgs.hasKey("showContactUsOnAppBar")) {
                faqOptions.showContactUsOnAppBar(faqArgs.getBoolean("showContactUsOnAppBar"));
            }
            if (faqArgs.hasKey("showContactUsOnFaqScreens")) {
                faqOptions.showContactUsOnFaqScreens(faqArgs.getBoolean("showContactUsOnFaqScreens"));
            }
            if (faqArgs.hasKey("showContactUsOnFaqNotHelpful")) {
                faqOptions.showContactUsOnFaqNotHelpful(faqArgs.getBoolean("showContactUsOnFaqNotHelpful"));
            }
            ArrayList<String> tagsList = new ArrayList<String>();
            if (faqArgs.hasKey("tags") && (readableArray = faqArgs.getArray("tags")) != null) {
                for (int i = 0; i < readableArray.size(); ++i) {
                    tagsList.add(readableArray.getString(i));
                }
                String title = faqArgs.getString("filteredViewTitle");
                if ("category".equals(faqArgs.getString("filterType"))) {
                    faqOptions.filterByTags(tagsList, title, FaqOptions.FilterType.CATEGORY);
                } else {
                    faqOptions.filterByTags(tagsList, title, FaqOptions.FilterType.ARTICLE);
                }
            }
            ArrayList<String> contactusTagsList = new ArrayList<String>();
            if (faqArgs.hasKey("contactusFilterTags") && (contactusTags = faqArgs.getArray("contactusFilterTags")) != null) {
                for (int i = 0; i < contactusTags.size(); ++i) {
                    contactusTagsList.add(contactusTags.getString(i));
                }
                String contactusFilterTitle = faqArgs.getString("contactusFilterTitle");
                faqOptions.filterContactUsByTags(contactusTagsList, contactusFilterTitle);
            }
            Freshchat.showFAQs((Context)this.getContext(), (FaqOptions)faqOptions);
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)e.toString());
        }
    }

    @ReactMethod
    public void showConversations() {
        Freshchat.showConversations((Context)this.getContext());
    }

    @ReactMethod
    public void showConversationsWithOptions(@NonNull ReadableMap conversationArgs) {
        ConversationOptions conversationOptions = new ConversationOptions();
        ArrayList<String> tagsList = new ArrayList<String>();
        if (conversationArgs.hasKey("tags")) {
            try {
                ReadableArray tags = conversationArgs.getArray("tags");
                if (tags != null) {
                    for (int i = 0; i < tags.size(); ++i) {
                        tagsList.add(tags.getString(i));
                    }
                }
                String title = conversationArgs.getString("filteredViewTitle");
                conversationOptions.filterByTags(tagsList, title);
            }
            catch (Exception e) {
                Log.e((String)LOG_TAG, (String)"Please provide parameters to update a user");
            }
        }
        Freshchat.showConversations((Context)this.getContext(), (ConversationOptions)conversationOptions);
    }

    @ReactMethod
    public void resetUser() {
        Freshchat.resetUser((Context)this.getContext());
    }

    @ReactMethod
    public void setUser(@NonNull ReadableMap args, @Nullable Callback errorCallback) {
        if (args == null || args.toHashMap().size() == 0) {
            Log.e((String)LOG_TAG, (String)"Please provide parameters to setUser");
            return;
        }
        try {
            FreshchatUser freshchatUser = Freshchat.getInstance((Context)this.getContext()).getUser();
            freshchatUser.setFirstName(args.getString("firstName"));
            freshchatUser.setLastName(args.getString("lastName"));
            freshchatUser.setEmail(args.getString("email"));
            freshchatUser.setPhone(args.getString("phoneCountryCode"), args.getString("phone"));
            Freshchat.getInstance((Context)this.getContext()).setUser(freshchatUser);
        }
        catch (Exception e) {
            String errorMessage = e.toString();
            Log.e((String)LOG_TAG, (String)errorMessage);
            this.postError(errorCallback, "setUser", errorMessage);
        }
    }

    @ReactMethod
    public void setUserWithIdToken(@NonNull String jwt, @Nullable Callback errorCallback) {
        try {
            Freshchat.getInstance((Context)this.getContext()).setUser(jwt);
        }
        catch (Exception e) {
            this.postError(errorCallback, "setUserWithIdToken", e.toString());
        }
    }

    @ReactMethod
    public void setUserProperties(@NonNull ReadableMap readableMap, @Nullable Callback errorCallback) {
        if (readableMap == null) {
            Log.e((String)LOG_TAG, (String)"Please provide user properties to update the user");
            return;
        }
        try {
            HashMap params = readableMap.toHashMap();
            HashMap<String, String> userMeta = new HashMap<String, String>();
            ReadableMapKeySetIterator iterator = readableMap.keySetIterator();
            while (iterator.hasNextKey()) {
                String key = iterator.nextKey();
                ReadableType type = readableMap.getType(key);
                userMeta.put(key, readableMap.getString(key));
            }
            Freshchat.getInstance((Context)this.getContext()).setUserProperties(userMeta);
        }
        catch (Exception e) {
            String errorMessage = e.toString();
            Log.e((String)LOG_TAG, (String)errorMessage);
            this.postError(errorCallback, "setUserProperties", errorMessage);
        }
    }

    @ReactMethod
    public void setBotVariables(@NonNull ReadableMap readableMapVariables, @NonNull ReadableMap botSpecificReadableMapVariables) {
        HashMap variables = readableMapVariables.toHashMap();
        HashMap botVariables = botSpecificReadableMapVariables.toHashMap();
        HashMap<String, HashMap> botSpecificVariables = new HashMap<String, HashMap>();
        for (Map.Entry entry : botVariables.entrySet()) {
            String key = (String)entry.getKey();
            HashMap value = (HashMap)entry.getValue();
            botSpecificVariables.put(key, value);
        }
        Freshchat.getInstance((Context)this.getContext()).setBotVariables((Map)variables, botSpecificVariables);
    }

    @ReactMethod
    public void getUnreadCountAsync(final @NonNull Callback callback) {
        Freshchat.getInstance((Context)this.getContext()).getUnreadCountAsync(new UnreadCountCallback(){

            public void onResult(FreshchatCallbackStatus freshchatCallbackStatus, int count) {
                boolean status = freshchatCallbackStatus == FreshchatCallbackStatus.STATUS_SUCCESS;
                WritableNativeMap map = new WritableNativeMap();
                map.putBoolean("status", status);
                map.putInt("count", count);
                callback.invoke(new Object[]{map});
            }
        });
    }

    @ReactMethod
    public void getUnreadCountAsyncForTags(@NonNull ReadableMap readableMap, final @NonNull Callback callback) {
        ArrayList<String> tagsList = new ArrayList<String>();
        if (readableMap != null && readableMap.toHashMap().size() > 0) {
            ReadableArray readableArray;
            HashMap params = readableMap.toHashMap();
            if (readableMap.hasKey("tags") && (readableArray = readableMap.getArray("tags")) != null) {
                for (int i = 0; i < readableArray.size(); ++i) {
                    tagsList.add(readableArray.getString(i));
                }
            }
        }
        Freshchat.getInstance((Context)this.getContext()).getUnreadCountAsync(new UnreadCountCallback(){

            public void onResult(FreshchatCallbackStatus freshchatCallbackStatus, int count) {
                boolean status = freshchatCallbackStatus == FreshchatCallbackStatus.STATUS_SUCCESS;
                WritableNativeMap map = new WritableNativeMap();
                map.putBoolean("status", status);
                map.putInt("count", count);
                callback.invoke(new Object[]{map});
            }
        }, tagsList);
    }

    @ReactMethod
    public void getSDKVersionCode(@NonNull Callback successCallback) {
        Freshchat.getInstance((Context)this.getContext());
        int versionNumber = Freshchat.getSDKVersionCode();
        successCallback.invoke(new Object[]{versionNumber});
    }

    @ReactMethod
    public void getUser(@NonNull Callback userCallback) {
        FreshchatUser freshchatUser = Freshchat.getInstance((Context)this.getContext()).getUser();
        WritableNativeMap map = new WritableNativeMap();
        if (freshchatUser != null) {
            map.putString("email", freshchatUser.getEmail());
            map.putString("firstName", freshchatUser.getFirstName());
            map.putString("lastName", freshchatUser.getLastName());
            map.putString("phone", freshchatUser.getPhone());
            map.putString("phoneCountryCode", freshchatUser.getPhoneCountryCode());
            map.putString("externalId", freshchatUser.getExternalId());
            map.putString("restoreId", freshchatUser.getRestoreId());
        }
        userCallback.invoke(new Object[]{map});
    }

    @ReactMethod
    public void isFreshchatNotification(@NonNull ReadableMap readableMap, @NonNull Callback callback) {
        HashMap params = readableMap.toHashMap();
        if (params.size() == 0) {
            callback.invoke(new Object[]{0});
        } else {
            Bundle bundle = this.jsonToBundle(readableMap);
            Freshchat.getInstance((Context)this.getContext());
            if (Freshchat.isFreshchatNotification((Bundle)bundle)) {
                callback.invoke(new Object[]{1});
            } else {
                callback.invoke(new Object[]{0});
            }
        }
    }

    @ReactMethod
    public void handlePushNotification(@NonNull ReadableMap readableMap) {
        if (readableMap == null || readableMap.toHashMap().size() == 0) {
            Log.e((String)LOG_TAG, (String)"Please provide values to handlePushNotification");
            return;
        }
        HashMap params = readableMap.toHashMap();
        Bundle bundle = this.jsonToBundle(readableMap);
        Freshchat.handleFcmMessage((Context)this.getContext(), (Object)bundle);
    }

    @ReactMethod
    public void identifyUser(@NonNull String externalId, @NonNull String restoreId, @Nullable Callback errorCallback) {
        try {
            Freshchat.getInstance((Context)this.getContext()).identifyUser(externalId, restoreId);
        }
        catch (Exception e) {
            String errorMessage = e.toString();
            Log.e((String)LOG_TAG, (String)errorMessage);
            this.postError(errorCallback, "identifyUser", errorMessage);
        }
    }

    @ReactMethod
    public void restoreUser(@NonNull String jwt, @Nullable Callback errorCallback) {
        try {
            Freshchat.getInstance((Context)this.getContext()).restoreUser(jwt);
        }
        catch (Exception e) {
            this.postError(errorCallback, "setUserWithIdToken", e.toString());
        }
    }

    @ReactMethod
    public void sendMessage(@NonNull ReadableMap readableMap) {
        HashMap params = readableMap.toHashMap();
        if (params.size() < 2) {
            Log.e((String)LOG_TAG, (String)"Please provide valid field to sendMessage");
            return;
        }
        FreshchatMessage freshchatMessage = new FreshchatMessage();
        freshchatMessage.setTag(readableMap.getString("tag")).setMessage(readableMap.getString("message"));
        Freshchat.getInstance((Context)this.getContext());
        Freshchat.sendMessage((Context)this.getContext(), (FreshchatMessage)freshchatMessage);
    }

    @ReactMethod
    public void setPushRegistrationToken(@NonNull String token) {
        Freshchat.getInstance((Context)this.getContext()).setPushRegistrationToken(token);
    }

    @ReactMethod
    public void dismissFreshchatViews() {
        Intent intent = new Intent("com.freshchat.consumer.sdk.actions.DismissFreshchatScreens");
        LocalBroadcastManager.getInstance((Context)this.getContext().getApplicationContext()).sendBroadcast(intent);
    }

    @ReactMethod
    public void setNotificationConfig(@NonNull ReadableMap readableMap) {
        try {
            int iconId;
            String iconName;
            HashMap params = readableMap.toHashMap();
            FreshchatNotificationConfig notificationConfig = new FreshchatNotificationConfig();
            if (readableMap.hasKey("notificationSoundEnabled")) {
                notificationConfig.setNotificationSoundEnabled(readableMap.getBoolean("notificationSoundEnabled"));
            }
            try {
                if (readableMap.hasKey("smallIcon")) {
                    iconName = readableMap.getString("smallIcon");
                    iconId = this.getContext().getResources().getIdentifier(iconName, "drawable", this.getContext().getPackageName());
                    notificationConfig.setSmallIcon(iconId);
                }
            }
            catch (Exception e) {
                Log.i((String)LOG_TAG, (String)"smallIcon parsing failed");
            }
            try {
                if (readableMap.hasKey("largeIcon")) {
                    iconName = readableMap.getString("largeIcon");
                    iconId = this.getContext().getResources().getIdentifier(iconName, "drawable", this.getContext().getPackageName());
                    notificationConfig.setLargeIcon(iconId);
                }
            }
            catch (Exception e) {
                Log.i((String)LOG_TAG, (String)"largeIcon parsing failed");
            }
            if (readableMap.hasKey("activityToLaunchOnFinish")) {
                notificationConfig.launchActivityOnFinish(readableMap.getString("activityToLaunchOnFinish"));
            }
            if (readableMap.hasKey("priority")) {
                notificationConfig.setPriority(readableMap.getInt("priority"));
            }
            if (readableMap.hasKey("importance")) {
                notificationConfig.setImportance(readableMap.getInt("importance"));
            }
            if (readableMap.hasKey("overrideNotificationClickListener")) {
                notificationConfig.setNotificationInterceptionEnabled(readableMap.getBoolean("overrideNotificationClickListener"));
            }
            Freshchat.getInstance((Context)this.getContext()).setNotificationConfig(notificationConfig);
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("setNotificationConfig error: " + e.toString()));
        }
    }

    @ReactMethod
    public void registerForRestoreIdUpdates(boolean register) {
        Log.i((String)LOG_TAG, (String)("enableRegisterForRestoreIdUpdates: " + register));
        if (register) {
            this.registerBroadcastReceiver(this.restoreIdUpdatesReceiver, "com.freshchat.consumer.sdk.UserRestoreIdGenerated");
        } else {
            this.unregisterBroadcastReceiver(this.restoreIdUpdatesReceiver);
        }
    }

    @ReactMethod
    public void registerForMessageCountUpdates(boolean register) {
        Log.i((String)LOG_TAG, (String)("enableRegisterForMessageCountUpdates: " + register));
        if (register) {
            this.registerBroadcastReceiver(this.messageCountUpdatesReceiver, "com.freshchat.consumer.sdk.MessageCountChanged");
        } else {
            this.unregisterBroadcastReceiver(this.messageCountUpdatesReceiver);
        }
    }

    @ReactMethod
    public void registerUserInteractionListerner(boolean register) {
        Log.i((String)LOG_TAG, (String)("registerUserInteractionListerner: " + register));
        if (register) {
            Freshchat.getInstance((Context)this.getContext()).setFreshchatUserInteractionListener(this.userInteractionListener);
        } else {
            Freshchat.getInstance((Context)this.getContext()).setFreshchatUserInteractionListener(null);
        }
    }

    @ReactMethod
    public void openFreshchatDeeplink(String link) {
        Log.i((String)LOG_TAG, (String)("openFreshchatDeeplink: " + link));
        if (this.getContext() instanceof Activity) {
            Log.i((String)LOG_TAG, (String)"openFreshchatDeeplink: React: Activity Context");
        } else {
            Log.i((String)LOG_TAG, (String)"openFreshchatDeeplink: React: Application Context");
        }
        Freshchat.openFreshchatDeeplink((Context)this.getContext(), (String)link);
    }

    @ReactMethod
    public void registerForOpeningLink(boolean register) {
        Log.i((String)LOG_TAG, (String)("registerForOpeningLink: " + register));
        if (register) {
            Freshchat.getInstance((Context)this.getContext()).setCustomLinkHandler(this.linkHandler);
        } else {
            Freshchat.getInstance((Context)this.getContext()).setCustomLinkHandler(null);
        }
    }

    @ReactMethod
    public void registerForLocaleChangedByWebview(boolean register) {
        Log.i((String)LOG_TAG, (String)("registerForLocaleChangedByWebview: " + register));
        if (register) {
            Freshchat.getInstance((Context)this.getContext()).setWebviewListener(this.webviewListener);
        } else {
            Freshchat.getInstance((Context)this.getContext()).setWebviewListener(null);
        }
    }

    @ReactMethod
    public void registerForUserActions(boolean register) {
        Log.i((String)LOG_TAG, (String)("registerForUserActions: " + register));
        if (register) {
            this.registerBroadcastReceiver(this.userActionsReceiver, "com.freshchat.consumer.sdk.FreshchatEvents");
        } else {
            this.unregisterBroadcastReceiver(this.userActionsReceiver);
        }
    }

    @ReactMethod
    public void registerNotificationClickListener(boolean register) {
        Log.i((String)LOG_TAG, (String)("registerNotificationClickListener: " + register));
        if (register) {
            this.registerBroadcastReceiver(this.notificationClickReceiver, "com.freshchat.consumer.sdk.FreshchatNotificationIntercepted");
        } else {
            this.unregisterBroadcastReceiver(this.notificationClickReceiver);
        }
    }

    @ReactMethod
    public void registerForJWTRefresh(boolean register) {
        Log.i((String)LOG_TAG, (String)("registerForJWTRefresh: " + register));
        if (register) {
            this.registerBroadcastReceiver(this.jwtRefreshEventReceiver, "com.freshchat.consumer.sdk.actions.SetTokenToRefreshDeviceProperties");
        } else {
            this.unregisterBroadcastReceiver(this.jwtRefreshEventReceiver);
        }
    }

    @ReactMethod
    public void getUserIdTokenStatus(@NonNull Callback callback) {
        JwtTokenStatus tokenStatus = Freshchat.getInstance((Context)this.getContext()).getUserIdTokenStatus();
        WritableNativeMap map = new WritableNativeMap();
        map.putString("user_id_token_status", tokenStatus.name());
        callback.invoke(new Object[]{map});
    }

    @ReactMethod
    public void getFreshchatUserId(@NonNull Callback callback) {
        String alias = Freshchat.getInstance((Context)this.getContext()).getFreshchatUserId();
        callback.invoke(new Object[]{alias});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ReactMethod
    public void trackEvent(@NonNull String name, @NonNull ReadableMap readableMap) {
        HashMap params = null;
        try {
            params = readableMap.toHashMap();
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)e.toString());
        }
        finally {
            if (params == null) {
                params = new HashMap();
            }
        }
        Freshchat.trackEvent((Context)this.getContext(), (String)name, params);
    }

    @ReactMethod
    public void notifyAppLocaleChange() {
        Freshchat.notifyAppLocaleChange((Context)this.getContext());
    }

    private void registerBroadcastReceiver(@NonNull FreshchatSDKBroadcastReceiver receiver, @NonNull String action) {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction(action);
        LocalBroadcastManager.getInstance((Context)this.getContext()).registerReceiver((BroadcastReceiver)receiver, intentFilter);
    }

    private void unregisterBroadcastReceiver(@NonNull FreshchatSDKBroadcastReceiver receiver) {
        LocalBroadcastManager.getInstance((Context)this.getContext()).unregisterReceiver((BroadcastReceiver)receiver);
    }

    private void emitEvent(@NonNull ReactApplicationContext reactApplicationContext, @NonNull String eventName, @Nullable WritableMap params) {
        if (params == null) {
            params = new WritableNativeMap();
        }
        ((DeviceEventManagerModule.RCTDeviceEventEmitter)reactApplicationContext.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class)).emit(eventName, (Object)params);
    }

    @NonNull
    private void postError(@Nullable Callback errorCallback, @NonNull String module, @NonNull String errorMessage) {
        if (errorCallback != null) {
            WritableNativeMap map = new WritableNativeMap();
            map.putString("module", module);
            map.putString("errorMessage", errorMessage);
            errorCallback.invoke(new Object[]{map});
        }
    }

    private Context getContext() {
        Activity activity = this.getCurrentActivity();
        if (activity != null) {
            Log.d((String)LOG_TAG, (String)"Using Activity Context");
            return activity;
        }
        Log.d((String)LOG_TAG, (String)"Using React Application Context");
        return this.getReactApplicationContext();
    }

    private class FreshchatSDKBroadcastReceiver
    extends BroadcastReceiver {
        private final ReactApplicationContext reactApplicationContext;
        private final String eventName;

        public FreshchatSDKBroadcastReceiver(@NonNull ReactApplicationContext reactApplicationContext, String eventName) {
            this.reactApplicationContext = reactApplicationContext;
            this.eventName = eventName;
        }

        public void onReceive(@NonNull Context context, @NonNull Intent intent) {
            String action = intent.getAction();
            Log.i((String)RNFreshchatSdk.LOG_TAG, (String)("Broadcast triggered: " + action));
            if (this.reactApplicationContext == null) {
                Log.e((String)RNFreshchatSdk.LOG_TAG, (String)"reactContext is null. Broadcast dropped.");
                return;
            }
            WritableNativeMap map = new WritableNativeMap();
            if (intent.getExtras() != null) {
                if ("com.freshchat.consumer.sdk.FreshchatEvents".equals(this.eventName)) {
                    Event event = Freshchat.getEventFromBundle((Bundle)intent.getExtras());
                    if (event != null) {
                        map.putString("event_name", event.getEventName().getName());
                        WritableNativeMap propertiesMap = new WritableNativeMap();
                        if (event.getProperties() != null && event.getProperties().size() > 0) {
                            for (Event.Property property : event.getProperties().keySet()) {
                                propertiesMap.putString(property.getName(), String.valueOf(event.getProperties().get(property)));
                            }
                        }
                        map.putMap("properties", (ReadableMap)propertiesMap);
                    }
                } else if ("com.freshchat.consumer.sdk.FreshchatNotificationIntercepted".equals(this.eventName)) {
                    map.putString("url", intent.getExtras().getString("FRESHCHAT_DEEPLINK"));
                }
            }
            RNFreshchatSdk.this.emitEvent(this.reactApplicationContext, this.eventName, (WritableMap)map);
        }
    }
}

