/*
 * Decompiled with CFR 0.152.
 */
package com.getui.gtc.base.db;

import android.content.Context;
import com.getui.gtc.base.db.AbstractDb;
import com.getui.gtc.base.db.AbstractTable;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DbManager {
    private static final Map<Class<? extends AbstractDb>, AbstractDb> dbMap = new ConcurrentHashMap<Class<? extends AbstractDb>, AbstractDb>();

    public static void init(Context context, Class<? extends AbstractDb> classArray, Class<? extends AbstractTable> ... classArray2) throws IllegalAccessException, InstantiationException {
        context = context.getApplicationContext();
        AbstractDb abstractDb = dbMap.get(classArray);
        if (abstractDb == null) {
            abstractDb = classArray.newInstance();
            dbMap.put((Class<? extends AbstractDb>)classArray, abstractDb);
        }
        classArray = classArray2;
        int n2 = classArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Class<? extends AbstractTable> clazz = classArray[i2];
            abstractDb.addTable(clazz);
        }
        abstractDb.init(context);
    }

    public static Collection<AbstractTable> getTables(Class<? extends AbstractDb> clazz) {
        AbstractDb abstractDb = dbMap.get(clazz);
        if (abstractDb == null) {
            throw new RuntimeException("db " + clazz.getSimpleName() + "has not been initialized");
        }
        return abstractDb.getTables();
    }

    public static <T extends AbstractTable> T getTable(Class<? extends AbstractDb> clazz, Class<T> clazz2) {
        AbstractDb abstractDb = dbMap.get(clazz);
        if (abstractDb == null) {
            throw new RuntimeException("db " + clazz.getSimpleName() + " has not been initialized");
        }
        return abstractDb.getTable(clazz2);
    }
}

