/*
 * Decompiled with CFR 0.152.
 */
package com.getui.gtc.base.http;

import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;

public class GtHostnameVerifier
implements HostnameVerifier {
    public static final GtHostnameVerifier INSTANCE = new GtHostnameVerifier();
    private static final Pattern VERIFY_AS_IP_ADDRESS = Pattern.compile("([0-9a-fA-F]*:[0-9a-fA-F:.]*)|([\\d.]+)");
    private static final int ALT_DNS_NAME = 2;
    private static final int ALT_IPA_NAME = 7;

    @Override
    public boolean verify(String string, SSLSession certificateArray) {
        try {
            certificateArray = certificateArray.getPeerCertificates();
            return this.verify(string, (X509Certificate)certificateArray[0]);
        }
        catch (SSLException sSLException) {
            return false;
        }
    }

    public boolean verify(String string, X509Certificate x509Certificate) {
        if (VERIFY_AS_IP_ADDRESS.matcher(string).matches()) {
            return this.verifyIpAddress(string, x509Certificate);
        }
        return this.verifyHostname(string, x509Certificate);
    }

    private boolean verifyIpAddress(String string, X509Certificate object) {
        object = GtHostnameVerifier.getSubjectAltNames((X509Certificate)object, 7);
        int n2 = object.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!string.equalsIgnoreCase((String)object.get(i2))) continue;
            return true;
        }
        return false;
    }

    private boolean verifyHostname(String string, X509Certificate object) {
        string = string.toLowerCase(Locale.US);
        for (String string2 : GtHostnameVerifier.getSubjectAltNames((X509Certificate)object, 2)) {
            if (!this.verifyHostname(string, string2)) continue;
            return true;
        }
        return false;
    }

    private static List<String> getSubjectAltNames(X509Certificate iterator, int n2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            iterator = ((X509Certificate)((Object)iterator)).getSubjectAlternativeNames();
            if (iterator == null) {
                return Collections.emptyList();
            }
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Integer n3;
                Object object = (List)iterator.next();
                if (object == null || object.size() < 2 || (n3 = (Integer)object.get(0)) == null || n3 != n2 || (object = (String)object.get(1)) == null) continue;
                arrayList.add((String)object);
            }
            return arrayList;
        }
        catch (CertificateParsingException certificateParsingException) {
            return Collections.emptyList();
        }
    }

    public boolean verifyHostname(String string, String string2) {
        if (string == null || string.length() == 0 || string.startsWith(".") || string.endsWith("..")) {
            return false;
        }
        if (string2 == null || string2.length() == 0 || string2.startsWith(".") || string2.endsWith("..")) {
            return false;
        }
        if (!string.endsWith(".")) {
            string = string + '.';
        }
        if (!string2.endsWith(".")) {
            string2 = string2 + '.';
        }
        if (!(string2 = string2.toLowerCase(Locale.US)).contains("*")) {
            return string.equals(string2);
        }
        if (!string2.startsWith("*.") || string2.indexOf(42, 1) != -1) {
            return false;
        }
        if (string.length() < string2.length()) {
            return false;
        }
        if ("*.".equals(string2)) {
            return false;
        }
        if (!string.endsWith(string2 = string2.substring(1))) {
            return false;
        }
        int n2 = string.length() - string2.length();
        return n2 <= 0 || string.lastIndexOf(46, n2 - 1) == -1;
    }
}

