/*
 * Decompiled with CFR 0.152.
 */
package com.getui.gtc.base.http;

import android.net.Network;
import com.getui.gtc.base.http.Interceptor;
import com.getui.gtc.base.http.MediaType;
import com.getui.gtc.base.http.RequestBody;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class Request {
    private URL url;
    private String method;
    private Network network;
    private Map<String, String> headers;
    private RequestBody body;
    private Interceptor cryptInterceptor;
    private String tag;
    private int logFlags;

    private Request() {
    }

    private Request(Builder builder) {
        this.url = builder.url;
        this.method = builder.method;
        this.network = builder.network;
        this.headers = new HashMap<String, String>();
        this.headers.putAll(builder.headers);
        this.body = builder.body;
        this.cryptInterceptor = builder.cryptInterceptor;
        this.tag = builder.tag;
        this.logFlags = builder.logFlags;
    }

    public URL url() {
        return this.url;
    }

    public String method() {
        return this.method;
    }

    public Network network() {
        return this.network;
    }

    public Map<String, String> headers() {
        return this.headers;
    }

    public String header(String string) {
        return this.headers.get(string);
    }

    public RequestBody body() {
        return this.body;
    }

    public Interceptor cryptInterceptor() {
        return this.cryptInterceptor;
    }

    public String tag() {
        return this.tag;
    }

    public int logFlags() {
        return this.logFlags;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        URL url;
        String method;
        Network network;
        Map<String, String> headers;
        RequestBody body;
        Interceptor cryptInterceptor;
        String tag;
        int logFlags;

        public Builder() {
            this.method = "GET";
            this.headers = new HashMap<String, String>();
            this.tag = "";
            this.logFlags = -1;
        }

        Builder(Request request) {
            this.url = request.url;
            this.method = request.method;
            this.network = request.network;
            this.body = request.body;
            this.headers = request.headers;
            this.tag = request.tag;
            this.logFlags = request.logFlags;
        }

        public Builder url(String string) {
            if (string == null) {
                throw new NullPointerException("url == null");
            }
            try {
                return this.url(new URL(string));
            }
            catch (MalformedURLException malformedURLException) {
                throw new IllegalArgumentException(malformedURLException);
            }
        }

        public Builder url(URL uRL) {
            if (uRL == null) {
                throw new NullPointerException("url == null");
            }
            this.url = uRL;
            return this;
        }

        public Builder addHeader(String string, String string2) {
            this.headers.put(string, string2);
            return this;
        }

        public Builder removeHeader(String string) {
            this.headers.remove(string);
            return this;
        }

        public Builder headers(Map<String, String> map) {
            this.headers.clear();
            this.headers.putAll(map);
            return this;
        }

        public Builder method(String string) {
            this.method = string;
            return this;
        }

        public Builder network(Network network) {
            this.network = network;
            return this;
        }

        @Deprecated
        public Builder body(byte[] byArray) {
            if (byArray == null) {
                return this;
            }
            MediaType mediaType = MediaType.parse("application/json; charset=utf-8");
            this.body = RequestBody.create(mediaType, byArray);
            return this;
        }

        public Builder body(RequestBody requestBody) {
            this.body = requestBody;
            return this;
        }

        public Builder cryptInterceptor(Interceptor interceptor) {
            this.cryptInterceptor = interceptor;
            return this;
        }

        public Builder tag(String string) {
            this.tag = string;
            return this;
        }

        public Builder logFlags(int n2) {
            this.logFlags = n2;
            return this;
        }

        public Request build() {
            return new Request(this);
        }
    }
}

