/*
 * Decompiled with CFR 0.152.
 */
package com.reactlibrary;

import android.content.Context;
import android.media.ToneGenerator;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.honeywell.aidc.AidcManager;
import com.honeywell.aidc.BarcodeFailureEvent;
import com.honeywell.aidc.BarcodeReadEvent;
import com.honeywell.aidc.BarcodeReader;
import com.honeywell.aidc.ScannerNotClaimedException;
import com.honeywell.aidc.ScannerUnavailableException;
import com.honeywell.aidc.TriggerStateChangeEvent;
import com.honeywell.aidc.UnsupportedPropertyException;
import java.util.HashMap;
import java.util.Map;

public class RNHoneywellBarcodeScannerModule
extends ReactContextBaseJavaModule
implements BarcodeReader.BarcodeListener,
BarcodeReader.TriggerListener {
    private final ReactApplicationContext reactContext;
    private BarcodeReader reader;
    private AidcManager manager;
    private boolean triggerState = false;
    private String barcodeData;
    private static final String AUTOMATIC_CONTROL = "AUTOMATIC";
    private static final String MANUAL_CONTROL = "MANUAL";

    public RNHoneywellBarcodeScannerModule(ReactApplicationContext reactContext) {
        super(reactContext);
        this.reactContext = reactContext;
    }

    public Map<String, Object> getConstants() {
        HashMap<String, Object> constants = new HashMap<String, Object>();
        constants.put(MANUAL_CONTROL, "clientControl");
        constants.put(AUTOMATIC_CONTROL, "autoControl");
        return constants;
    }

    @ReactMethod
    public void setReaderMode(String mode) {
        try {
            if (this.reader != null) {
                this.reader.setProperty("TRIG_CONTROL_MODE", mode);
            }
        }
        catch (UnsupportedPropertyException e) {
            e.getMessage();
        }
    }

    @ReactMethod
    public void startReader() {
        AidcManager.create((Context)this.reactContext, (AidcManager.CreatedCallback)new AidcManager.CreatedCallback(){

            public void onCreated(AidcManager aidcManager) {
                RNHoneywellBarcodeScannerModule.this.manager = aidcManager;
                RNHoneywellBarcodeScannerModule.this.reader = RNHoneywellBarcodeScannerModule.this.manager.createBarcodeReader();
                try {
                    if (RNHoneywellBarcodeScannerModule.this.reader != null) {
                        RNHoneywellBarcodeScannerModule.this.reader.claim();
                    }
                    RNHoneywellBarcodeScannerModule.this.reader.setProperty("TRIG_CONTROL_MODE", "clientControl");
                }
                catch (ScannerUnavailableException e) {
                    e.printStackTrace();
                }
                catch (UnsupportedPropertyException e) {
                    e.printStackTrace();
                }
                RNHoneywellBarcodeScannerModule.this.reader.addTriggerListener((BarcodeReader.TriggerListener)RNHoneywellBarcodeScannerModule.this);
                HashMap<String, Comparable<Boolean>> properties = new HashMap<String, Comparable<Boolean>>();
                properties.put("DEC_CODE128_ENABLED", Boolean.valueOf(true));
                properties.put("DEC_GS1_128_ENABLED", Boolean.valueOf(true));
                properties.put("DEC_QR_ENABLED", Boolean.valueOf(true));
                properties.put("DEC_CODE39_ENABLED", Boolean.valueOf(true));
                properties.put("DEC_DATAMATRIX_ENABLED", Boolean.valueOf(true));
                properties.put("DEC_UPCA_ENABLE", Boolean.valueOf(true));
                properties.put("DEC_EAN13_ENABLED", Boolean.valueOf(false));
                properties.put("DEC_AZTEC_ENABLED", Boolean.valueOf(false));
                properties.put("DEC_CODABAR_ENABLED", Boolean.valueOf(false));
                properties.put("DEC_I25_ENABLED", Boolean.valueOf(false));
                properties.put("DEC_PDF417_ENABLED", Boolean.valueOf(false));
                properties.put("DEC_CODE39_MAX_LENGTH", Integer.valueOf(1000));
                properties.put("DEC_WINDOW_MODE", Boolean.valueOf(true));
                properties.put("NTF_BAD_READ_ENABLED", Boolean.valueOf(false));
                RNHoneywellBarcodeScannerModule.this.reader.setProperties(properties);
                RNHoneywellBarcodeScannerModule.this.reader.addBarcodeListener((BarcodeReader.BarcodeListener)RNHoneywellBarcodeScannerModule.this);
            }
        });
    }

    @ReactMethod
    public void stopReader() {
        if (this.reader != null) {
            this.reader.release();
            this.reader.close();
        }
        if (this.manager != null) {
            this.manager.close();
        }
    }

    public String getName() {
        return "RNHoneywellBarcodeScanner";
    }

    public void onBarcodeEvent(BarcodeReadEvent barcodeReadEvent) {
        String barcodeData = barcodeReadEvent.getBarcodeData();
        ((DeviceEventManagerModule.RCTDeviceEventEmitter)this.reactContext.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class)).emit("io.ibsgroup.codeCaptured", (Object)barcodeData);
        ToneGenerator beep = new ToneGenerator(3, 1600);
        beep.startTone(97, 700);
    }

    public void onFailureEvent(BarcodeFailureEvent barcodeFailureEvent) {
        ((DeviceEventManagerModule.RCTDeviceEventEmitter)this.reactContext.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class)).emit("io.ibsgroup.codeCaptured", (Object)false);
    }

    public void onTriggerEvent(TriggerStateChangeEvent triggerStateChangeEvent) {
        try {
            if (triggerStateChangeEvent.getState()) {
                this.reader.aim(!this.triggerState);
                this.reader.light(!this.triggerState);
                this.reader.decode(!this.triggerState);
                this.triggerState = !this.triggerState;
            }
        }
        catch (ScannerUnavailableException e) {
            e.printStackTrace();
        }
        catch (ScannerNotClaimedException e) {
            e.printStackTrace();
        }
    }
}

