/*
 * Decompiled with CFR 0.152.
 */
package com.github.pgengoux.huaweiprotectedapps;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Process;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.AppCompatCheckBox;
import android.view.View;
import android.widget.CompoundButton;
import android.widget.RelativeLayout;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class HuaweiProtectedAppsModule
extends ReactContextBaseJavaModule
implements LifecycleEventListener {
    public HuaweiProtectedAppsModule(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    public String getName() {
        return "HuaweiProtectedApps";
    }

    @ReactMethod
    public void AlertIfHuaweiDevice(String title, String message, String dontShowAgainText, String positiveText, String negativeText) {
        SharedPreferences settings = this.getCurrentActivity().getSharedPreferences("ProtectedApps", 0);
        String saveIfSkip = "skipProtectedAppsMessage";
        boolean skipMessage = settings.getBoolean("skipProtectedAppsMessage", false);
        if (!skipMessage) {
            final SharedPreferences.Editor editor = settings.edit();
            Intent intent = new Intent();
            intent.setClassName("com.huawei.systemmanager", "com.huawei.systemmanager.optimize.process.ProtectActivity");
            if (this.isCallable(intent)) {
                AppCompatCheckBox dontShowAgain = new AppCompatCheckBox((Context)this.getCurrentActivity());
                dontShowAgain.setText((CharSequence)dontShowAgainText);
                dontShowAgain.setLeft(20);
                dontShowAgain.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                        editor.putBoolean("skipProtectedAppsMessage", isChecked);
                        editor.apply();
                    }
                });
                RelativeLayout layout = new RelativeLayout((Context)this.getCurrentActivity());
                layout.setPadding(50, 50, 0, 0);
                layout.addView((View)dontShowAgain);
                new AlertDialog.Builder((Context)this.getCurrentActivity()).setIcon(17301543).setTitle((CharSequence)title).setMessage((CharSequence)message).setView((View)layout).setPositiveButton((CharSequence)positiveText, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        HuaweiProtectedAppsModule.this.huaweiProtectedApps();
                    }
                }).setNegativeButton((CharSequence)negativeText, null).show();
            } else {
                editor.putBoolean("skipProtectedAppsMessage", true);
                editor.apply();
            }
        }
    }

    private boolean isCallable(Intent intent) {
        List list = this.getReactApplicationContext().getPackageManager().queryIntentActivities(intent, 65536);
        return list.size() > 0;
    }

    private void huaweiProtectedApps() {
        try {
            String cmd = "am start -n com.huawei.systemmanager/.optimize.process.ProtectActivity";
            if (Build.VERSION.SDK_INT >= 17) {
                cmd = cmd + " --user " + this.getUserSerial();
            }
            Runtime.getRuntime().exec(cmd);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String getUserSerial() {
        Object userManager = this.getReactApplicationContext().getSystemService("user");
        if (null == userManager) {
            return "";
        }
        try {
            Method myUserHandleMethod = Process.class.getMethod("myUserHandle", null);
            Object myUserHandle = myUserHandleMethod.invoke(Process.class, (Object[])null);
            Method getSerialNumberForUser = userManager.getClass().getMethod("getSerialNumberForUser", myUserHandle.getClass());
            Long userSerial = (Long)getSerialNumberForUser.invoke(userManager, myUserHandle);
            if (userSerial != null) {
                return String.valueOf(userSerial);
            }
            return "";
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException exception) {
            return "";
        }
    }

    public void onHostResume() {
    }

    public void onHostPause() {
    }

    public void onHostDestroy() {
    }
}

