/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.csslayout;

import com.facebook.csslayout.CSSAlign;
import com.facebook.csslayout.CSSDirection;
import com.facebook.csslayout.CSSFlexDirection;
import com.facebook.csslayout.CSSJustify;
import com.facebook.csslayout.CSSLayout;
import com.facebook.csslayout.CSSLayoutContext;
import com.facebook.csslayout.CSSMeasureMode;
import com.facebook.csslayout.CSSNodeAPI;
import com.facebook.csslayout.CSSOverflow;
import com.facebook.csslayout.CSSPositionType;
import com.facebook.csslayout.CSSStyle;
import com.facebook.csslayout.CSSWrap;
import com.facebook.csslayout.CachedCSSLayout;
import com.facebook.csslayout.FloatUtil;
import com.facebook.csslayout.LayoutEngine;
import com.facebook.csslayout.MeasureOutput;
import com.facebook.csslayout.Spacing;
import com.facebook.infer.annotation.Assertions;
import java.util.ArrayList;
import javax.annotation.Nullable;

public class CSSNode
implements CSSNodeAPI<CSSNode> {
    final CSSStyle style = new CSSStyle();
    final CSSLayout layout = new CSSLayout();
    final CachedCSSLayout lastLayout = new CachedCSSLayout();
    public int lineIndex = 0;
    CSSNode nextChild;
    @Nullable
    private ArrayList<CSSNode> mChildren;
    @Nullable
    private CSSNode mParent;
    @Nullable
    private CSSNodeAPI.MeasureFunction mMeasureFunction = null;
    private LayoutState mLayoutState = LayoutState.DIRTY;
    private boolean mIsTextNode = false;
    private Object mData;

    @Override
    public void init() {
        this.reset();
    }

    @Override
    public int getChildCount() {
        return this.mChildren == null ? 0 : this.mChildren.size();
    }

    @Override
    public CSSNode getChildAt(int i) {
        Assertions.assertNotNull(this.mChildren);
        return this.mChildren.get(i);
    }

    @Override
    public void addChildAt(CSSNode child, int i) {
        if (child.mParent != null) {
            throw new IllegalStateException("Child already has a parent, it must be removed first.");
        }
        if (this.mChildren == null) {
            this.mChildren = new ArrayList(4);
        }
        this.mChildren.add(i, child);
        child.mParent = this;
        this.dirty();
    }

    @Override
    public CSSNode removeChildAt(int i) {
        Assertions.assertNotNull(this.mChildren);
        CSSNode removed = this.mChildren.remove(i);
        removed.mParent = null;
        this.dirty();
        return removed;
    }

    @Override
    @Nullable
    public CSSNode getParent() {
        return this.mParent;
    }

    @Override
    public int indexOf(CSSNode child) {
        Assertions.assertNotNull(this.mChildren);
        return this.mChildren.indexOf(child);
    }

    @Override
    public void setMeasureFunction(CSSNodeAPI.MeasureFunction measureFunction) {
        if (this.mMeasureFunction != measureFunction) {
            this.mMeasureFunction = measureFunction;
            this.dirty();
        }
    }

    @Override
    public boolean isMeasureDefined() {
        return this.mMeasureFunction != null;
    }

    @Override
    public void setIsTextNode(boolean isTextNode) {
        this.mIsTextNode = isTextNode;
    }

    @Override
    public boolean isTextNode() {
        return this.mIsTextNode;
    }

    MeasureOutput measure(MeasureOutput measureOutput, float width, CSSMeasureMode widthMode, float height, CSSMeasureMode heightMode) {
        if (!this.isMeasureDefined()) {
            throw new RuntimeException("Measure function isn't defined!");
        }
        measureOutput.height = Float.NaN;
        measureOutput.width = Float.NaN;
        ((CSSNodeAPI.MeasureFunction)Assertions.assertNotNull((Object)this.mMeasureFunction)).measure(this, width, widthMode, height, heightMode, measureOutput);
        return measureOutput;
    }

    @Override
    public void calculateLayout(CSSLayoutContext layoutContext) {
        LayoutEngine.layoutNode(layoutContext, this, Float.NaN, Float.NaN, null);
    }

    @Override
    public boolean isDirty() {
        return this.mLayoutState == LayoutState.DIRTY;
    }

    @Override
    public boolean hasNewLayout() {
        return this.mLayoutState == LayoutState.HAS_NEW_LAYOUT;
    }

    @Override
    public void dirty() {
        if (this.mLayoutState == LayoutState.DIRTY) {
            return;
        }
        if (this.mLayoutState == LayoutState.HAS_NEW_LAYOUT) {
            throw new IllegalStateException("Previous layout was ignored! markLayoutSeen() never called");
        }
        this.mLayoutState = LayoutState.DIRTY;
        if (this.mParent != null) {
            this.mParent.dirty();
        }
    }

    void markHasNewLayout() {
        this.mLayoutState = LayoutState.HAS_NEW_LAYOUT;
    }

    @Override
    public void markLayoutSeen() {
        if (!this.hasNewLayout()) {
            throw new IllegalStateException("Expected node to have a new layout to be seen!");
        }
        this.mLayoutState = LayoutState.UP_TO_DATE;
    }

    private void toStringWithIndentation(StringBuilder result, int level) {
        int i;
        StringBuilder indentation = new StringBuilder();
        for (i = 0; i < level; ++i) {
            indentation.append("__");
        }
        result.append(indentation.toString());
        result.append(this.layout.toString());
        if (this.getChildCount() == 0) {
            return;
        }
        result.append(", children: [\n");
        for (i = 0; i < this.getChildCount(); ++i) {
            this.getChildAt(i).toStringWithIndentation(result, level + 1);
            result.append("\n");
        }
        result.append(indentation + "]");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toStringWithIndentation(sb, 0);
        return sb.toString();
    }

    @Override
    public boolean valuesEqual(float f1, float f2) {
        return FloatUtil.floatsEqual(f1, f2);
    }

    @Override
    public CSSDirection getStyleDirection() {
        return this.style.direction;
    }

    @Override
    public void setDirection(CSSDirection direction) {
        if (this.style.direction != direction) {
            this.style.direction = direction;
            this.dirty();
        }
    }

    @Override
    public CSSFlexDirection getFlexDirection() {
        return this.style.flexDirection;
    }

    @Override
    public void setFlexDirection(CSSFlexDirection flexDirection) {
        if (this.style.flexDirection != flexDirection) {
            this.style.flexDirection = flexDirection;
            this.dirty();
        }
    }

    @Override
    public CSSJustify getJustifyContent() {
        return this.style.justifyContent;
    }

    @Override
    public void setJustifyContent(CSSJustify justifyContent) {
        if (this.style.justifyContent != justifyContent) {
            this.style.justifyContent = justifyContent;
            this.dirty();
        }
    }

    @Override
    public CSSAlign getAlignItems() {
        return this.style.alignItems;
    }

    @Override
    public void setAlignItems(CSSAlign alignItems) {
        if (this.style.alignItems != alignItems) {
            this.style.alignItems = alignItems;
            this.dirty();
        }
    }

    @Override
    public CSSAlign getAlignSelf() {
        return this.style.alignSelf;
    }

    @Override
    public void setAlignSelf(CSSAlign alignSelf) {
        if (this.style.alignSelf != alignSelf) {
            this.style.alignSelf = alignSelf;
            this.dirty();
        }
    }

    @Override
    public CSSAlign getAlignContent() {
        return this.style.alignContent;
    }

    @Override
    public void setAlignContent(CSSAlign alignContent) {
        if (this.style.alignContent != alignContent) {
            this.style.alignContent = alignContent;
            this.dirty();
        }
    }

    @Override
    public CSSPositionType getPositionType() {
        return this.style.positionType;
    }

    @Override
    public void setPositionType(CSSPositionType positionType) {
        if (this.style.positionType != positionType) {
            this.style.positionType = positionType;
            this.dirty();
        }
    }

    @Override
    public void setWrap(CSSWrap flexWrap) {
        if (this.style.flexWrap != flexWrap) {
            this.style.flexWrap = flexWrap;
            this.dirty();
        }
    }

    @Override
    public float getFlex() {
        return this.style.flex;
    }

    @Override
    public void setFlex(float flex) {
        if (!this.valuesEqual(this.style.flex, flex)) {
            this.style.flex = flex;
            this.dirty();
        }
    }

    @Override
    public Spacing getMargin() {
        return this.style.margin;
    }

    @Override
    public void setMargin(int spacingType, float margin) {
        if (this.style.margin.set(spacingType, margin)) {
            this.dirty();
        }
    }

    @Override
    public Spacing getPadding() {
        return this.style.padding;
    }

    @Override
    public void setPadding(int spacingType, float padding) {
        if (this.style.padding.set(spacingType, padding)) {
            this.dirty();
        }
    }

    @Override
    public Spacing getBorder() {
        return this.style.border;
    }

    @Override
    public void setBorder(int spacingType, float border) {
        if (this.style.border.set(spacingType, border)) {
            this.dirty();
        }
    }

    @Override
    public Spacing getPosition() {
        return this.style.position;
    }

    @Override
    public void setPosition(int spacingType, float position) {
        if (this.style.position.set(spacingType, position)) {
            this.dirty();
        }
    }

    @Override
    public float getStyleWidth() {
        return this.style.dimensions[0];
    }

    @Override
    public void setStyleWidth(float width) {
        if (!this.valuesEqual(this.style.dimensions[0], width)) {
            this.style.dimensions[0] = width;
            this.dirty();
        }
    }

    @Override
    public float getStyleHeight() {
        return this.style.dimensions[1];
    }

    @Override
    public void setStyleHeight(float height) {
        if (!this.valuesEqual(this.style.dimensions[1], height)) {
            this.style.dimensions[1] = height;
            this.dirty();
        }
    }

    @Override
    public float getStyleMaxWidth() {
        return this.style.maxWidth;
    }

    @Override
    public void setStyleMaxWidth(float maxWidth) {
        if (!this.valuesEqual(this.style.maxWidth, maxWidth)) {
            this.style.maxWidth = maxWidth;
            this.dirty();
        }
    }

    @Override
    public float getStyleMinWidth() {
        return this.style.minWidth;
    }

    @Override
    public void setStyleMinWidth(float minWidth) {
        if (!this.valuesEqual(this.style.minWidth, minWidth)) {
            this.style.minWidth = minWidth;
            this.dirty();
        }
    }

    @Override
    public float getStyleMaxHeight() {
        return this.style.maxHeight;
    }

    @Override
    public void setStyleMaxHeight(float maxHeight) {
        if (!this.valuesEqual(this.style.maxHeight, maxHeight)) {
            this.style.maxHeight = maxHeight;
            this.dirty();
        }
    }

    @Override
    public float getStyleMinHeight() {
        return this.style.minHeight;
    }

    @Override
    public void setStyleMinHeight(float minHeight) {
        if (!this.valuesEqual(this.style.minHeight, minHeight)) {
            this.style.minHeight = minHeight;
            this.dirty();
        }
    }

    @Override
    public float getLayoutX() {
        return this.layout.position[0];
    }

    @Override
    public float getLayoutY() {
        return this.layout.position[1];
    }

    @Override
    public float getLayoutWidth() {
        return this.layout.dimensions[0];
    }

    @Override
    public float getLayoutHeight() {
        return this.layout.dimensions[1];
    }

    @Override
    public CSSDirection getLayoutDirection() {
        return this.layout.direction;
    }

    @Override
    public CSSOverflow getOverflow() {
        return this.style.overflow;
    }

    @Override
    public void setOverflow(CSSOverflow overflow) {
        if (this.style.overflow != overflow) {
            this.style.overflow = overflow;
            this.dirty();
        }
    }

    @Override
    public void setData(Object data) {
        this.mData = data;
    }

    @Override
    public Object getData() {
        return this.mData;
    }

    @Override
    public void reset() {
        if (this.mParent != null || this.mChildren != null && this.mChildren.size() > 0) {
            throw new IllegalStateException("You should not reset an attached CSSNode");
        }
        this.style.reset();
        this.layout.resetResult();
        this.lineIndex = 0;
        this.mLayoutState = LayoutState.DIRTY;
    }

    private static enum LayoutState {
        DIRTY,
        HAS_NEW_LAYOUT,
        UP_TO_DATE;

    }
}

