/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.csslayout;

import com.facebook.csslayout.CSSAlign;
import com.facebook.csslayout.CSSDirection;
import com.facebook.csslayout.CSSFlexDirection;
import com.facebook.csslayout.CSSJustify;
import com.facebook.csslayout.CSSLayoutContext;
import com.facebook.csslayout.CSSMeasureMode;
import com.facebook.csslayout.CSSNodeAPI;
import com.facebook.csslayout.CSSOverflow;
import com.facebook.csslayout.CSSPositionType;
import com.facebook.csslayout.CSSWrap;
import com.facebook.csslayout.FloatUtil;
import com.facebook.csslayout.MeasureOutput;
import com.facebook.csslayout.Spacing;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.soloader.SoLoader;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class CSSNodeJNI
implements CSSNodeAPI<CSSNodeJNI> {
    private CSSNodeJNI mParent;
    private List<CSSNodeJNI> mChildren;
    private CSSNodeAPI.MeasureFunction mMeasureFunction;
    private long mNativePointer;
    private Object mData;

    private void assertNativeInstance() {
        if (this.mNativePointer == 0L) {
            throw new IllegalStateException("Null native pointer");
        }
    }

    private native long jni_CSSNodeNew();

    @Override
    public void init() {
        if (this.mNativePointer != 0L) {
            throw new IllegalStateException("Allready initialized node");
        }
        this.mNativePointer = this.jni_CSSNodeNew();
        this.mChildren = new ArrayList<CSSNodeJNI>(4);
    }

    private native void jni_CSSNodeFree(long var1);

    @Override
    public void reset() {
        this.assertNativeInstance();
        this.jni_CSSNodeFree(this.mNativePointer);
        this.mNativePointer = 0L;
        this.mChildren = null;
        this.mParent = null;
        this.mMeasureFunction = null;
    }

    @Override
    public int getChildCount() {
        return this.mChildren.size();
    }

    @Override
    public CSSNodeJNI getChildAt(int i) {
        return this.mChildren.get(i);
    }

    private native void jni_CSSNodeInsertChild(long var1, long var3, int var5);

    @Override
    public void addChildAt(CSSNodeJNI child, int i) {
        this.assertNativeInstance();
        this.mChildren.add(i, child);
        child.mParent = this;
        this.jni_CSSNodeInsertChild(this.mNativePointer, child.mNativePointer, i);
    }

    private native void jni_CSSNodeRemoveChild(long var1, long var3);

    @Override
    public CSSNodeJNI removeChildAt(int i) {
        this.assertNativeInstance();
        CSSNodeJNI child = this.mChildren.remove(i);
        child.mParent = null;
        this.jni_CSSNodeRemoveChild(this.mNativePointer, child.mNativePointer);
        return child;
    }

    @Override
    @Nullable
    public CSSNodeJNI getParent() {
        return this.mParent;
    }

    @Override
    public int indexOf(CSSNodeJNI child) {
        return this.mChildren.indexOf(child);
    }

    private native void jni_CSSNodeSetIsTextNode(long var1, boolean var3);

    @Override
    public void setIsTextNode(boolean isTextNode) {
        this.assertNativeInstance();
        this.jni_CSSNodeSetIsTextNode(this.mNativePointer, isTextNode);
    }

    private native boolean jni_CSSNodeGetIsTextNode(long var1);

    @Override
    public boolean isTextNode() {
        this.assertNativeInstance();
        return this.jni_CSSNodeGetIsTextNode(this.mNativePointer);
    }

    private native void jni_CSSNodeCalculateLayout(long var1);

    @Override
    public void calculateLayout(CSSLayoutContext layoutContext) {
        this.assertNativeInstance();
        this.jni_CSSNodeCalculateLayout(this.mNativePointer);
    }

    private native boolean jni_CSSNodeHasNewLayout(long var1);

    @Override
    public boolean hasNewLayout() {
        this.assertNativeInstance();
        return this.jni_CSSNodeHasNewLayout(this.mNativePointer);
    }

    private native void jni_CSSNodeMarkDirty(long var1);

    @Override
    public void dirty() {
        this.assertNativeInstance();
        this.jni_CSSNodeMarkDirty(this.mNativePointer);
    }

    private native boolean jni_CSSNodeIsDirty(long var1);

    @Override
    public boolean isDirty() {
        return this.jni_CSSNodeIsDirty(this.mNativePointer);
    }

    private native void jni_CSSNodeMarkLayoutSeen(long var1);

    @Override
    public void markLayoutSeen() {
        this.assertNativeInstance();
        this.jni_CSSNodeMarkLayoutSeen(this.mNativePointer);
    }

    private native int jni_CSSNodeStyleGetDirection(long var1);

    @Override
    public CSSDirection getStyleDirection() {
        this.assertNativeInstance();
        return CSSDirection.values()[this.jni_CSSNodeStyleGetDirection(this.mNativePointer)];
    }

    private native void jni_CSSNodeStyleSetDirection(long var1, int var3);

    @Override
    public void setDirection(CSSDirection direction) {
        this.assertNativeInstance();
        this.jni_CSSNodeStyleSetDirection(this.mNativePointer, direction.ordinal());
    }

    private native int jni_CSSNodeLayoutGetDirection(long var1);

    @Override
    public CSSDirection getLayoutDirection() {
        this.assertNativeInstance();
        return CSSDirection.values()[this.jni_CSSNodeLayoutGetDirection(this.mNativePointer)];
    }

    private native int jni_CSSNodeStyleGetFlexDirection(long var1);

    @Override
    public CSSFlexDirection getFlexDirection() {
        this.assertNativeInstance();
        return CSSFlexDirection.values()[this.jni_CSSNodeStyleGetFlexDirection(this.mNativePointer)];
    }

    private native void jni_CSSNodeStyleSetFlexDirection(long var1, int var3);

    @Override
    public void setFlexDirection(CSSFlexDirection flexDirection) {
        this.assertNativeInstance();
        this.jni_CSSNodeStyleSetFlexDirection(this.mNativePointer, flexDirection.ordinal());
    }

    private native int jni_CSSNodeStyleGetJustifyContent(long var1);

    @Override
    public CSSJustify getJustifyContent() {
        this.assertNativeInstance();
        return CSSJustify.values()[this.jni_CSSNodeStyleGetJustifyContent(this.mNativePointer)];
    }

    private native void jni_CSSNodeStyleSetJustifyContent(long var1, int var3);

    @Override
    public void setJustifyContent(CSSJustify justifyContent) {
        this.assertNativeInstance();
        this.jni_CSSNodeStyleSetJustifyContent(this.mNativePointer, justifyContent.ordinal());
    }

    private native int jni_CSSNodeStyleGetAlignItems(long var1);

    @Override
    public CSSAlign getAlignItems() {
        this.assertNativeInstance();
        return CSSAlign.values()[this.jni_CSSNodeStyleGetAlignItems(this.mNativePointer)];
    }

    private native void jni_CSSNodeStyleSetAlignItems(long var1, int var3);

    @Override
    public void setAlignItems(CSSAlign alignItems) {
        this.assertNativeInstance();
        this.jni_CSSNodeStyleSetAlignItems(this.mNativePointer, alignItems.ordinal());
    }

    private native int jni_CSSNodeStyleGetAlignSelf(long var1);

    @Override
    public CSSAlign getAlignSelf() {
        this.assertNativeInstance();
        return CSSAlign.values()[this.jni_CSSNodeStyleGetAlignSelf(this.mNativePointer)];
    }

    private native void jni_CSSNodeStyleSetAlignSelf(long var1, int var3);

    @Override
    public void setAlignSelf(CSSAlign alignSelf) {
        this.assertNativeInstance();
        this.jni_CSSNodeStyleSetAlignSelf(this.mNativePointer, alignSelf.ordinal());
    }

    private native int jni_CSSNodeStyleGetAlignContent(long var1);

    @Override
    public CSSAlign getAlignContent() {
        this.assertNativeInstance();
        return CSSAlign.values()[this.jni_CSSNodeStyleGetAlignContent(this.mNativePointer)];
    }

    private native void jni_CSSNodeStyleSetAlignContent(long var1, int var3);

    @Override
    public void setAlignContent(CSSAlign alignContent) {
        this.assertNativeInstance();
        this.jni_CSSNodeStyleSetAlignContent(this.mNativePointer, alignContent.ordinal());
    }

    private native int jni_CSSNodeStyleGetPositionType(long var1);

    @Override
    public CSSPositionType getPositionType() {
        this.assertNativeInstance();
        return CSSPositionType.values()[this.jni_CSSNodeStyleGetPositionType(this.mNativePointer)];
    }

    private native void jni_CSSNodeStyleSetPositionType(long var1, int var3);

    @Override
    public void setPositionType(CSSPositionType positionType) {
        this.assertNativeInstance();
        this.jni_CSSNodeStyleSetPositionType(this.mNativePointer, positionType.ordinal());
    }

    private native void jni_CSSNodeStyleSetFlexWrap(long var1, int var3);

    @Override
    public void setWrap(CSSWrap flexWrap) {
        this.assertNativeInstance();
        this.jni_CSSNodeStyleSetFlexWrap(this.mNativePointer, flexWrap.ordinal());
    }

    private native int jni_CSSNodeStyleGetOverflow(long var1);

    @Override
    public CSSOverflow getOverflow() {
        this.assertNativeInstance();
        return CSSOverflow.values()[this.jni_CSSNodeStyleGetOverflow(this.mNativePointer)];
    }

    private native void jni_CSSNodeStyleSetOverflow(long var1, int var3);

    @Override
    public void setOverflow(CSSOverflow overflow) {
        this.assertNativeInstance();
        this.jni_CSSNodeStyleSetOverflow(this.mNativePointer, overflow.ordinal());
    }

    private native float jni_CSSNodeStyleGetFlex(long var1);

    @Override
    public float getFlex() {
        this.assertNativeInstance();
        return this.jni_CSSNodeStyleGetFlex(this.mNativePointer);
    }

    private native void jni_CSSNodeStyleSetFlex(long var1, float var3);

    @Override
    public void setFlex(float flex) {
        this.assertNativeInstance();
        this.jni_CSSNodeStyleSetFlex(this.mNativePointer, flex);
    }

    private native float jni_CSSNodeStyleGetMargin(long var1, int var3);

    @Override
    public Spacing getMargin() {
        this.assertNativeInstance();
        Spacing margin = new Spacing();
        margin.set(0, this.jni_CSSNodeStyleGetMargin(this.mNativePointer, 0));
        margin.set(1, this.jni_CSSNodeStyleGetMargin(this.mNativePointer, 1));
        margin.set(2, this.jni_CSSNodeStyleGetMargin(this.mNativePointer, 2));
        margin.set(3, this.jni_CSSNodeStyleGetMargin(this.mNativePointer, 3));
        margin.set(4, this.jni_CSSNodeStyleGetMargin(this.mNativePointer, 4));
        margin.set(5, this.jni_CSSNodeStyleGetMargin(this.mNativePointer, 5));
        return margin;
    }

    private native void jni_CSSNodeStyleSetMargin(long var1, int var3, float var4);

    @Override
    public void setMargin(int spacingType, float margin) {
        this.assertNativeInstance();
        this.jni_CSSNodeStyleSetMargin(this.mNativePointer, spacingType, margin);
    }

    private native float jni_CSSNodeStyleGetPadding(long var1, int var3);

    @Override
    public Spacing getPadding() {
        this.assertNativeInstance();
        Spacing padding = new Spacing();
        padding.set(0, this.jni_CSSNodeStyleGetPadding(this.mNativePointer, 0));
        padding.set(1, this.jni_CSSNodeStyleGetPadding(this.mNativePointer, 1));
        padding.set(2, this.jni_CSSNodeStyleGetPadding(this.mNativePointer, 2));
        padding.set(3, this.jni_CSSNodeStyleGetPadding(this.mNativePointer, 3));
        padding.set(4, this.jni_CSSNodeStyleGetPadding(this.mNativePointer, 4));
        padding.set(5, this.jni_CSSNodeStyleGetPadding(this.mNativePointer, 5));
        return padding;
    }

    private native void jni_CSSNodeStyleSetPadding(long var1, int var3, float var4);

    @Override
    public void setPadding(int spacingType, float padding) {
        this.assertNativeInstance();
        this.jni_CSSNodeStyleSetPadding(this.mNativePointer, spacingType, padding);
    }

    private native float jni_CSSNodeStyleGetBorder(long var1, int var3);

    @Override
    public Spacing getBorder() {
        this.assertNativeInstance();
        Spacing border = new Spacing();
        border.set(0, this.jni_CSSNodeStyleGetBorder(this.mNativePointer, 0));
        border.set(1, this.jni_CSSNodeStyleGetBorder(this.mNativePointer, 1));
        border.set(2, this.jni_CSSNodeStyleGetBorder(this.mNativePointer, 2));
        border.set(3, this.jni_CSSNodeStyleGetBorder(this.mNativePointer, 3));
        border.set(4, this.jni_CSSNodeStyleGetBorder(this.mNativePointer, 4));
        border.set(5, this.jni_CSSNodeStyleGetBorder(this.mNativePointer, 5));
        return border;
    }

    private native void jni_CSSNodeStyleSetBorder(long var1, int var3, float var4);

    @Override
    public void setBorder(int spacingType, float border) {
        this.assertNativeInstance();
        this.jni_CSSNodeStyleSetBorder(this.mNativePointer, spacingType, border);
    }

    private native float jni_CSSNodeStyleGetPosition(long var1, int var3);

    @Override
    public Spacing getPosition() {
        this.assertNativeInstance();
        Spacing position = new Spacing();
        position.set(0, this.jni_CSSNodeStyleGetPosition(this.mNativePointer, 0));
        position.set(1, this.jni_CSSNodeStyleGetPosition(this.mNativePointer, 1));
        position.set(2, this.jni_CSSNodeStyleGetPosition(this.mNativePointer, 2));
        position.set(3, this.jni_CSSNodeStyleGetPosition(this.mNativePointer, 3));
        position.set(4, this.jni_CSSNodeStyleGetPosition(this.mNativePointer, 4));
        position.set(5, this.jni_CSSNodeStyleGetPosition(this.mNativePointer, 5));
        return position;
    }

    private native void jni_CSSNodeStyleSetPosition(long var1, int var3, float var4);

    @Override
    public void setPosition(int spacingType, float position) {
        this.assertNativeInstance();
        this.jni_CSSNodeStyleSetPosition(this.mNativePointer, spacingType, position);
    }

    private native float jni_CSSNodeStyleGetWidth(long var1);

    @Override
    public float getStyleWidth() {
        this.assertNativeInstance();
        return this.jni_CSSNodeStyleGetWidth(this.mNativePointer);
    }

    private native void jni_CSSNodeStyleSetWidth(long var1, float var3);

    @Override
    public void setStyleWidth(float width) {
        this.assertNativeInstance();
        this.jni_CSSNodeStyleSetWidth(this.mNativePointer, width);
    }

    private native float jni_CSSNodeStyleGetHeight(long var1);

    @Override
    public float getStyleHeight() {
        this.assertNativeInstance();
        return this.jni_CSSNodeStyleGetHeight(this.mNativePointer);
    }

    private native void jni_CSSNodeStyleSetHeight(long var1, float var3);

    @Override
    public void setStyleHeight(float height) {
        this.assertNativeInstance();
        this.jni_CSSNodeStyleSetHeight(this.mNativePointer, height);
    }

    private native float jni_CSSNodeStyleGetMinWidth(long var1);

    @Override
    public float getStyleMinWidth() {
        this.assertNativeInstance();
        return this.jni_CSSNodeStyleGetMinWidth(this.mNativePointer);
    }

    private native void jni_CSSNodeStyleSetMinWidth(long var1, float var3);

    @Override
    public void setStyleMinWidth(float minWidth) {
        this.assertNativeInstance();
        this.jni_CSSNodeStyleSetMinWidth(this.mNativePointer, minWidth);
    }

    private native float jni_CSSNodeStyleGetMinHeight(long var1);

    @Override
    public float getStyleMinHeight() {
        this.assertNativeInstance();
        return this.jni_CSSNodeStyleGetMinHeight(this.mNativePointer);
    }

    private native void jni_CSSNodeStyleSetMinHeight(long var1, float var3);

    @Override
    public void setStyleMinHeight(float minHeight) {
        this.assertNativeInstance();
        this.jni_CSSNodeStyleSetMinHeight(this.mNativePointer, minHeight);
    }

    private native float jni_CSSNodeStyleGetMaxWidth(long var1);

    @Override
    public float getStyleMaxWidth() {
        this.assertNativeInstance();
        return this.jni_CSSNodeStyleGetMaxWidth(this.mNativePointer);
    }

    private native void jni_CSSNodeStyleSetMaxWidth(long var1, float var3);

    @Override
    public void setStyleMaxWidth(float maxWidth) {
        this.assertNativeInstance();
        this.jni_CSSNodeStyleSetMaxWidth(this.mNativePointer, maxWidth);
    }

    private native float jni_CSSNodeStyleGetMaxHeight(long var1);

    @Override
    public float getStyleMaxHeight() {
        this.assertNativeInstance();
        return this.jni_CSSNodeStyleGetMaxHeight(this.mNativePointer);
    }

    private native void jni_CSSNodeStyleSetMaxHeight(long var1, float var3);

    @Override
    public void setStyleMaxHeight(float maxheight) {
        this.assertNativeInstance();
        this.jni_CSSNodeStyleSetMaxHeight(this.mNativePointer, maxheight);
    }

    private native float jni_CSSNodeLayoutGetLeft(long var1);

    @Override
    public float getLayoutX() {
        this.assertNativeInstance();
        return this.jni_CSSNodeLayoutGetLeft(this.mNativePointer);
    }

    private native float jni_CSSNodeLayoutGetTop(long var1);

    @Override
    public float getLayoutY() {
        this.assertNativeInstance();
        return this.jni_CSSNodeLayoutGetTop(this.mNativePointer);
    }

    private native float jni_CSSNodeLayoutGetWidth(long var1);

    @Override
    public float getLayoutWidth() {
        this.assertNativeInstance();
        return this.jni_CSSNodeLayoutGetWidth(this.mNativePointer);
    }

    private native float jni_CSSNodeLayoutGetHeight(long var1);

    @Override
    public float getLayoutHeight() {
        this.assertNativeInstance();
        return this.jni_CSSNodeLayoutGetHeight(this.mNativePointer);
    }

    private native void jni_CSSNodeSetHasMeasureFunc(long var1, boolean var3);

    @Override
    public void setMeasureFunction(CSSNodeAPI.MeasureFunction measureFunction) {
        this.assertNativeInstance();
        this.mMeasureFunction = measureFunction;
        this.jni_CSSNodeSetHasMeasureFunc(this.mNativePointer, measureFunction != null);
    }

    @DoNotStrip
    public long measure(float width, int widthMode, float height, int heightMode) {
        this.assertNativeInstance();
        if (!this.isMeasureDefined()) {
            throw new RuntimeException("Measure function isn't defined!");
        }
        MeasureOutput output = new MeasureOutput();
        this.mMeasureFunction.measure(this, width, CSSMeasureMode.values()[widthMode], height, CSSMeasureMode.values()[heightMode], output);
        return (long)output.width << 32 | (long)output.height;
    }

    @Override
    public boolean isMeasureDefined() {
        return this.mMeasureFunction != null;
    }

    @Override
    public boolean valuesEqual(float f1, float f2) {
        return FloatUtil.floatsEqual(f1, f2);
    }

    @Override
    public void setData(Object data) {
        this.mData = data;
    }

    @Override
    public Object getData() {
        return this.mData;
    }

    static {
        try {
            SoLoader.loadLibrary((String)"csslayout");
        }
        catch (Exception ignored) {
            System.out.println("Falling back to System.loadLibrary()");
            System.loadLibrary("csslayout");
        }
    }
}

