/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import com.facebook.react.LazyReactPackage;
import com.facebook.react.ReactPackage;
import com.facebook.react.bridge.JavaScriptModule;
import com.facebook.react.bridge.ModuleSpec;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.uimanager.ViewManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class CompositeLazyReactPackage
extends LazyReactPackage {
    private final List<LazyReactPackage> mChildReactPackages;

    public CompositeLazyReactPackage(LazyReactPackage ... args) {
        this.mChildReactPackages = Arrays.asList(args);
    }

    @Override
    public List<ModuleSpec> getNativeModules(ReactApplicationContext reactContext) {
        HashMap<Class<? extends NativeModule>, ModuleSpec> moduleMap = new HashMap<Class<? extends NativeModule>, ModuleSpec>();
        for (LazyReactPackage reactPackage : this.mChildReactPackages) {
            for (ModuleSpec module : reactPackage.getNativeModules(reactContext)) {
                moduleMap.put(module.getType(), module);
            }
        }
        return new ArrayList<ModuleSpec>(moduleMap.values());
    }

    @Override
    public List<Class<? extends JavaScriptModule>> createJSModules() {
        HashSet<Class<? extends JavaScriptModule>> moduleSet = new HashSet<Class<? extends JavaScriptModule>>();
        for (ReactPackage reactPackage : this.mChildReactPackages) {
            for (Class<? extends JavaScriptModule> jsModule : reactPackage.createJSModules()) {
                moduleSet.add(jsModule);
            }
        }
        return new ArrayList<Class<? extends JavaScriptModule>>(moduleSet);
    }

    @Override
    public List<ViewManager> createViewManagers(ReactApplicationContext reactContext) {
        HashMap<String, ViewManager> viewManagerMap = new HashMap<String, ViewManager>();
        for (ReactPackage reactPackage : this.mChildReactPackages) {
            for (ViewManager viewManager : reactPackage.createViewManagers(reactContext)) {
                viewManagerMap.put(viewManager.getName(), viewManager);
            }
        }
        return new ArrayList<ViewManager>(viewManagerMap.values());
    }
}

