/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.animated;

import com.facebook.react.animated.AnimationDriver;
import com.facebook.react.bridge.ReadableMap;

public class DecayAnimation
extends AnimationDriver {
    private final double mVelocity;
    private final double mDeceleration;
    private long mStartFrameTimeMillis = -1L;
    private double mFromValue;
    private double mLastValue;

    public DecayAnimation(ReadableMap config) {
        this.mVelocity = config.getDouble("velocity");
        this.mDeceleration = config.getDouble("deceleration");
    }

    @Override
    public void runAnimationStep(long frameTimeNanos) {
        double value;
        long frameTimeMillis = frameTimeNanos / 1000000L;
        if (this.mStartFrameTimeMillis == -1L) {
            this.mStartFrameTimeMillis = frameTimeMillis - 16L;
            this.mFromValue = this.mAnimatedValue.mValue;
            this.mLastValue = this.mAnimatedValue.mValue;
        }
        if (Math.abs(this.mLastValue - (value = this.mFromValue + this.mVelocity / (1.0 - this.mDeceleration) * (1.0 - Math.exp(-(1.0 - this.mDeceleration) * (double)(frameTimeMillis - this.mStartFrameTimeMillis))))) < 0.1) {
            this.mHasFinished = true;
            return;
        }
        this.mLastValue = value;
        this.mAnimatedValue.mValue = value;
    }
}

