/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.animated;

import com.facebook.react.animated.AnimatedNode;
import com.facebook.react.animated.NativeAnimatedNodesManager;
import com.facebook.react.animated.TransformAnimatedNode;
import com.facebook.react.animated.ValueAnimatedNode;
import com.facebook.react.bridge.JavaOnlyMap;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapKeySetIterator;
import java.util.HashMap;
import java.util.Map;

class StyleAnimatedNode
extends AnimatedNode {
    private final NativeAnimatedNodesManager mNativeAnimatedNodesManager;
    private final Map<String, Integer> mPropMapping;

    StyleAnimatedNode(ReadableMap config, NativeAnimatedNodesManager nativeAnimatedNodesManager) {
        ReadableMap style2 = config.getMap("style");
        ReadableMapKeySetIterator iter = style2.keySetIterator();
        this.mPropMapping = new HashMap<String, Integer>();
        while (iter.hasNextKey()) {
            String propKey = iter.nextKey();
            int nodeIndex = style2.getInt(propKey);
            this.mPropMapping.put(propKey, nodeIndex);
        }
        this.mNativeAnimatedNodesManager = nativeAnimatedNodesManager;
    }

    public void collectViewUpdates(JavaOnlyMap propsMap) {
        for (Map.Entry<String, Integer> entry : this.mPropMapping.entrySet()) {
            AnimatedNode node = this.mNativeAnimatedNodesManager.getNodeById(entry.getValue());
            if (node == null) {
                throw new IllegalArgumentException("Mapped style node does not exists");
            }
            if (node instanceof TransformAnimatedNode) {
                ((TransformAnimatedNode)node).collectViewUpdates(propsMap);
                continue;
            }
            if (node instanceof ValueAnimatedNode) {
                propsMap.putDouble(entry.getKey(), ((ValueAnimatedNode)node).mValue);
                continue;
            }
            throw new IllegalArgumentException("Unsupported type of node used in property node " + node.getClass());
        }
    }
}

