/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import com.facebook.jni.HybridData;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.NativeMap;
import com.facebook.react.bridge.ReactBridge;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapKeySetIterator;
import com.facebook.react.bridge.ReadableNativeArray;
import com.facebook.react.bridge.ReadableType;
import java.util.HashMap;

@DoNotStrip
public class ReadableNativeMap
extends NativeMap
implements ReadableMap {
    protected ReadableNativeMap(HybridData hybridData) {
        super(hybridData);
    }

    @Override
    public native boolean hasKey(String var1);

    @Override
    public native boolean isNull(String var1);

    @Override
    public native boolean getBoolean(String var1);

    @Override
    public native double getDouble(String var1);

    @Override
    public native int getInt(String var1);

    @Override
    public native String getString(String var1);

    @Override
    public native ReadableNativeArray getArray(String var1);

    @Override
    public native ReadableNativeMap getMap(String var1);

    @Override
    public native ReadableType getType(String var1);

    @Override
    public ReadableMapKeySetIterator keySetIterator() {
        return new ReadableNativeMapKeySetIterator(this);
    }

    public HashMap<String, Object> toHashMap() {
        ReadableMapKeySetIterator iterator = this.keySetIterator();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        block8: while (iterator.hasNextKey()) {
            String key = iterator.nextKey();
            switch (this.getType(key)) {
                case Null: {
                    hashMap.put(key, null);
                    continue block8;
                }
                case Boolean: {
                    hashMap.put(key, this.getBoolean(key));
                    continue block8;
                }
                case Number: {
                    hashMap.put(key, this.getDouble(key));
                    continue block8;
                }
                case String: {
                    hashMap.put(key, this.getString(key));
                    continue block8;
                }
                case Map: {
                    hashMap.put(key, this.getMap(key).toHashMap());
                    continue block8;
                }
                case Array: {
                    hashMap.put(key, this.getArray(key).toArrayList());
                    continue block8;
                }
            }
            throw new IllegalArgumentException("Could not convert object with key: " + key + ".");
        }
        return hashMap;
    }

    static {
        ReactBridge.staticInit();
    }

    @DoNotStrip
    private static class ReadableNativeMapKeySetIterator
    implements ReadableMapKeySetIterator {
        @DoNotStrip
        private final HybridData mHybridData;
        @DoNotStrip
        private final ReadableNativeMap mMap;

        public ReadableNativeMapKeySetIterator(ReadableNativeMap readableNativeMap) {
            this.mMap = readableNativeMap;
            this.mHybridData = ReadableNativeMapKeySetIterator.initHybrid(readableNativeMap);
        }

        @Override
        public native boolean hasNextKey();

        @Override
        public native String nextKey();

        private static native HybridData initHybrid(ReadableNativeMap var0);
    }
}

