/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.cxxbridge;

import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.BaseJavaModule;
import com.facebook.react.bridge.CatalystInstance;
import com.facebook.react.bridge.ExecutorToken;
import com.facebook.react.bridge.NativeArray;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReadableNativeArray;
import com.facebook.react.bridge.WritableNativeArray;
import com.facebook.react.bridge.WritableNativeMap;
import com.facebook.react.cxxbridge.Arguments;
import com.facebook.systrace.Systrace;
import com.facebook.systrace.SystraceMessage;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@DoNotStrip
class JavaModuleWrapper {
    private final CatalystInstance mCatalystInstance;
    private final BaseJavaModule mModule;
    private final ArrayList<BaseJavaModule.JavaMethod> mMethods;

    public JavaModuleWrapper(CatalystInstance catalystinstance, BaseJavaModule module) {
        this.mCatalystInstance = catalystinstance;
        this.mModule = module;
        this.mMethods = new ArrayList();
    }

    @DoNotStrip
    public BaseJavaModule getModule() {
        return this.mModule;
    }

    @DoNotStrip
    public String getName() {
        return this.mModule.getName();
    }

    @DoNotStrip
    public List<MethodDescriptor> getMethodDescriptors() {
        ArrayList<MethodDescriptor> descs = new ArrayList<MethodDescriptor>();
        for (Map.Entry<String, NativeModule.NativeMethod> entry : this.mModule.getMethods().entrySet()) {
            MethodDescriptor md = new MethodDescriptor();
            md.name = entry.getKey();
            md.type = entry.getValue().getType();
            BaseJavaModule.JavaMethod method = (BaseJavaModule.JavaMethod)entry.getValue();
            this.mMethods.add(method);
            descs.add(md);
        }
        return descs;
    }

    @DoNotStrip
    public List<MethodDescriptor> newGetMethodDescriptors() {
        Object method;
        MethodDescriptor md;
        ArrayList<MethodDescriptor> descs = new ArrayList<MethodDescriptor>();
        for (Map.Entry<String, NativeModule.NativeMethod> entry : this.mModule.getMethods().entrySet()) {
            md = new MethodDescriptor();
            md.name = entry.getKey();
            md.type = entry.getValue().getType();
            method = (BaseJavaModule.JavaMethod)entry.getValue();
            md.method = ((BaseJavaModule.JavaMethod)method).getMethod();
            md.signature = ((BaseJavaModule.JavaMethod)method).getSignature();
            descs.add(md);
        }
        for (Map.Entry<String, Object> entry : this.mModule.getSyncHooks().entrySet()) {
            md = new MethodDescriptor();
            md.name = entry.getKey();
            md.type = "syncHook";
            method = (BaseJavaModule.SyncJavaHook)entry.getValue();
            md.method = ((BaseJavaModule.SyncJavaHook)method).getMethod();
            md.signature = ((BaseJavaModule.SyncJavaHook)method).getSignature();
            descs.add(md);
        }
        return descs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DoNotStrip
    public NativeArray getConstants() {
        WritableNativeMap writableNativeMap;
        SystraceMessage.beginSection(0L, "Map constants").arg("moduleName", this.getName()).flush();
        Map<String, Object> map = this.mModule.getConstants();
        Systrace.endSection(0L);
        SystraceMessage.beginSection(0L, "WritableNativeMap constants").arg("moduleName", this.getName()).flush();
        try {
            writableNativeMap = Arguments.makeNativeMap(map);
        }
        finally {
            Systrace.endSection(0L);
        }
        WritableNativeArray array = new WritableNativeArray();
        array.pushMap(writableNativeMap);
        return array;
    }

    @DoNotStrip
    public boolean supportsWebWorkers() {
        return this.mModule.supportsWebWorkers();
    }

    @DoNotStrip
    public void invoke(ExecutorToken token, int methodId, ReadableNativeArray parameters) {
        if (this.mMethods == null || methodId >= this.mMethods.size()) {
            return;
        }
        this.mMethods.get(methodId).invoke(this.mCatalystInstance, token, parameters);
    }

    @DoNotStrip
    public class MethodDescriptor {
        @DoNotStrip
        Method method;
        @DoNotStrip
        String signature;
        @DoNotStrip
        String name;
        @DoNotStrip
        String type;
    }
}

