/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import com.facebook.react.bridge.JavaScriptModule;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import java.io.File;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;

public class JSCHeapCapture
extends ReactContextBaseJavaModule {
    @Nullable
    private HeapCapture mHeapCapture = null;
    @Nullable
    private PerCaptureCallback mCaptureInProgress = null;
    private static final HashSet<JSCHeapCapture> sRegisteredDumpers = new HashSet();

    private static synchronized void registerHeapCapture(JSCHeapCapture dumper) {
        if (sRegisteredDumpers.contains(dumper)) {
            throw new RuntimeException("a JSCHeapCapture registered more than once");
        }
        sRegisteredDumpers.add(dumper);
    }

    private static synchronized void unregisterHeapCapture(JSCHeapCapture dumper) {
        sRegisteredDumpers.remove(dumper);
    }

    public static synchronized void captureHeap(String path, final CaptureCallback callback) {
        final LinkedList<File> captureFiles = new LinkedList<File>();
        final LinkedList<CaptureException> captureFailures = new LinkedList<CaptureException>();
        if (sRegisteredDumpers.isEmpty()) {
            captureFailures.add(new CaptureException("No JSC registered"));
            callback.onComplete(captureFiles, captureFailures);
            return;
        }
        int disambiguate = 0;
        File f = new File(path + "/capture" + Integer.toString(disambiguate) + ".json");
        while (f.delete()) {
            f = new File(path + "/capture" + Integer.toString(++disambiguate) + ".json");
        }
        final int numRegisteredDumpers = sRegisteredDumpers.size();
        disambiguate = 0;
        for (JSCHeapCapture dumper : sRegisteredDumpers) {
            File file = new File(path + "/capture" + Integer.toString(disambiguate) + ".json");
            dumper.captureHeapHelper(file, new PerCaptureCallback(){

                @Override
                public void onSuccess(File capture) {
                    captureFiles.add(capture);
                    if (captureFiles.size() + captureFailures.size() == numRegisteredDumpers) {
                        callback.onComplete(captureFiles, captureFailures);
                    }
                }

                @Override
                public void onFailure(CaptureException cause) {
                    captureFailures.add(cause);
                    if (captureFiles.size() + captureFailures.size() == numRegisteredDumpers) {
                        callback.onComplete(captureFiles, captureFailures);
                    }
                }
            });
        }
    }

    public JSCHeapCapture(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    private synchronized void captureHeapHelper(File file, PerCaptureCallback callback) {
        if (this.mHeapCapture == null) {
            callback.onFailure(new CaptureException("HeapCapture.js module not connected"));
            return;
        }
        if (this.mCaptureInProgress != null) {
            callback.onFailure(new CaptureException("Heap capture already in progress"));
            return;
        }
        this.mCaptureInProgress = callback;
        this.mHeapCapture.captureHeap(file.getPath());
    }

    @ReactMethod
    public synchronized void captureComplete(String path, String error) {
        if (this.mCaptureInProgress != null) {
            if (error == null) {
                this.mCaptureInProgress.onSuccess(new File(path));
            } else {
                this.mCaptureInProgress.onFailure(new CaptureException(error));
            }
            this.mCaptureInProgress = null;
        }
    }

    @Override
    public String getName() {
        return "JSCHeapCapture";
    }

    @Override
    public void initialize() {
        super.initialize();
        this.mHeapCapture = this.getReactApplicationContext().getJSModule(HeapCapture.class);
        JSCHeapCapture.registerHeapCapture(this);
    }

    @Override
    public void onCatalystInstanceDestroy() {
        super.onCatalystInstanceDestroy();
        JSCHeapCapture.unregisterHeapCapture(this);
        this.mHeapCapture = null;
    }

    private static interface PerCaptureCallback {
        public void onSuccess(File var1);

        public void onFailure(CaptureException var1);
    }

    public static interface CaptureCallback {
        public void onComplete(List<File> var1, List<CaptureException> var2);
    }

    public static class CaptureException
    extends Exception {
        CaptureException(String message) {
            super(message);
        }

        CaptureException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static interface HeapCapture
    extends JavaScriptModule {
        public void captureHeap(String var1);
    }
}

