/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.util.Log;
import com.facebook.react.devsupport.JSCHeapCapture;
import java.io.File;
import java.io.IOException;
import java.util.List;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class JSCHeapUpload {
    public static JSCHeapCapture.CaptureCallback captureCallback(final String uploadUrl) {
        return new JSCHeapCapture.CaptureCallback(){

            @Override
            public void onComplete(List<File> captures, List<JSCHeapCapture.CaptureException> failures) {
                for (JSCHeapCapture.CaptureException e : failures) {
                    Log.e((String)"JSCHeapCapture", (String)e.getMessage());
                }
                OkHttpClient httpClient = new OkHttpClient.Builder().build();
                for (File path : captures) {
                    RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (File)path);
                    Request request = new Request.Builder().url(uploadUrl).method("POST", body).build();
                    Call call = httpClient.newCall(request);
                    call.enqueue(new Callback(){

                        public void onFailure(Call call, IOException e) {
                            Log.e((String)"JSCHeapCapture", (String)("Upload of heap capture failed: " + e.toString()));
                        }

                        public void onResponse(Call call, Response response) throws IOException {
                            if (!response.isSuccessful()) {
                                Log.e((String)"JSCHeapCapture", (String)("Upload of heap capture failed with code: " + Integer.toString(response.code())));
                            }
                        }
                    });
                }
            }
        };
    }
}

