/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import com.facebook.react.bridge.JavaScriptModule;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;

public class JSCSamplingProfiler
extends ReactContextBaseJavaModule {
    @Nullable
    private SamplingProfiler mSamplingProfiler = null;
    private boolean mOperationInProgress = false;
    private int mOperationToken = 0;
    @Nullable
    private String mOperationError = null;
    @Nullable
    private String mSamplingProfilerResult = null;
    private static final HashSet<JSCSamplingProfiler> sRegisteredDumpers = new HashSet();

    private static synchronized void registerSamplingProfiler(JSCSamplingProfiler dumper) {
        if (sRegisteredDumpers.contains(dumper)) {
            throw new RuntimeException("a JSCSamplingProfiler registered more than once");
        }
        sRegisteredDumpers.add(dumper);
    }

    private static synchronized void unregisterSamplingProfiler(JSCSamplingProfiler dumper) {
        sRegisteredDumpers.remove(dumper);
    }

    public static synchronized List<String> poke(long timeout) throws ProfilerException {
        LinkedList<String> results = new LinkedList<String>();
        if (sRegisteredDumpers.isEmpty()) {
            throw new ProfilerException("No JSC registered");
        }
        for (JSCSamplingProfiler dumper : sRegisteredDumpers) {
            dumper.pokeHelper(timeout);
            results.add(dumper.mSamplingProfilerResult);
        }
        return results;
    }

    public JSCSamplingProfiler(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    private synchronized void pokeHelper(long timeout) throws ProfilerException {
        if (this.mSamplingProfiler == null) {
            throw new ProfilerException("SamplingProfiler.js module not connected");
        }
        this.mSamplingProfiler.poke(this.getOperationToken());
        this.waitForOperation(timeout);
    }

    private int getOperationToken() throws ProfilerException {
        if (this.mOperationInProgress) {
            throw new ProfilerException("Another operation already in progress.");
        }
        this.mOperationInProgress = true;
        return ++this.mOperationToken;
    }

    private void waitForOperation(long timeout) throws ProfilerException {
        try {
            this.wait(timeout);
        }
        catch (InterruptedException e) {
            throw new ProfilerException("Waiting for heap capture failed: " + e.getMessage());
        }
        if (this.mOperationInProgress) {
            this.mOperationInProgress = false;
            throw new ProfilerException("heap capture timed out.");
        }
        if (this.mOperationError != null) {
            throw new ProfilerException(this.mOperationError);
        }
    }

    @ReactMethod
    public synchronized void operationComplete(int token, String result, String error) {
        if (token != this.mOperationToken) {
            throw new RuntimeException("Completed operation is not in progress.");
        }
        this.mOperationInProgress = false;
        this.mSamplingProfilerResult = result;
        this.mOperationError = error;
        this.notify();
    }

    @Override
    public String getName() {
        return "JSCSamplingProfiler";
    }

    @Override
    public void initialize() {
        super.initialize();
        this.mSamplingProfiler = this.getReactApplicationContext().getJSModule(SamplingProfiler.class);
        JSCSamplingProfiler.registerSamplingProfiler(this);
    }

    @Override
    public void onCatalystInstanceDestroy() {
        super.onCatalystInstanceDestroy();
        JSCSamplingProfiler.unregisterSamplingProfiler(this);
        this.mSamplingProfiler = null;
    }

    public static class ProfilerException
    extends Exception {
        ProfilerException(String message) {
            super(message);
        }
    }

    public static interface SamplingProfiler
    extends JavaScriptModule {
        public void poke(int var1);
    }
}

