/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.os.Handler;
import android.os.Looper;
import com.facebook.common.logging.FLog;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.ws.WebSocket;
import okhttp3.ws.WebSocketCall;
import okhttp3.ws.WebSocketListener;
import okio.Buffer;

public class JSPackagerWebSocketClient
implements WebSocketListener {
    private static final String TAG = "JSPackagerWebSocketClient";
    private static final int RECONNECT_DELAY_MS = 2000;
    private final String mUrl;
    private final Handler mHandler;
    private boolean mSuppressConnectionErrors;
    @Nullable
    private WebSocket mWebSocket;
    @Nullable
    private JSPackagerCallback mCallback;

    public JSPackagerWebSocketClient(String url, JSPackagerCallback callback) {
        this.mUrl = url;
        this.mCallback = callback;
        this.mHandler = new Handler(Looper.getMainLooper());
    }

    public void connect() {
        OkHttpClient httpClient = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).readTimeout(0L, TimeUnit.MINUTES).build();
        Request request = new Request.Builder().url(this.mUrl).build();
        WebSocketCall call = WebSocketCall.create((OkHttpClient)httpClient, (Request)request);
        call.enqueue((WebSocketListener)this);
    }

    private void reconnect() {
        if (!this.mSuppressConnectionErrors) {
            FLog.w((String)TAG, (String)"Couldn't connect to packager, will silently retry");
            this.mSuppressConnectionErrors = true;
        }
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                JSPackagerWebSocketClient.this.connect();
            }
        }, 2000L);
    }

    public void closeQuietly() {
        if (this.mWebSocket != null) {
            try {
                this.mWebSocket.close(1000, "End of session");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mWebSocket = null;
        }
    }

    private void triggerMessageCallback(String target, String action) {
        if (this.mCallback != null) {
            this.mCallback.onMessage(target, action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(ResponseBody response) throws IOException {
        if (response.contentType() != WebSocket.TEXT) {
            FLog.w((String)TAG, (String)("Websocket received unexpected message with payload of type " + response.contentType()));
            return;
        }
        String message = null;
        try {
            message = response.source().readUtf8();
        }
        finally {
            response.close();
        }
        try {
            JsonParser parser = new JsonFactory().createParser(message);
            Integer version = null;
            String target = null;
            String action = null;
            while (parser.nextToken() != JsonToken.END_OBJECT) {
                String field = parser.getCurrentName();
                if ("version".equals(field)) {
                    parser.nextToken();
                    version = parser.getIntValue();
                    continue;
                }
                if ("target".equals(field)) {
                    parser.nextToken();
                    target = parser.getText();
                    continue;
                }
                if (!"action".equals(field)) continue;
                parser.nextToken();
                action = parser.getText();
            }
            if (version != 1) {
                return;
            }
            if (target == null || action == null) {
                return;
            }
            this.triggerMessageCallback(target, action);
        }
        catch (IOException e) {
            this.abort("Parsing response message from websocket failed", e);
        }
    }

    public void onFailure(IOException e, Response response) {
        if (this.mWebSocket != null) {
            this.abort("Websocket exception", e);
        }
        this.reconnect();
    }

    public void onOpen(WebSocket webSocket, Response response) {
        this.mWebSocket = webSocket;
        this.mSuppressConnectionErrors = false;
    }

    public void onClose(int code, String reason) {
        this.mWebSocket = null;
        this.reconnect();
    }

    public void onPong(Buffer payload) {
    }

    private void abort(String message, Throwable cause) {
        FLog.e((String)TAG, (String)("Error occurred, shutting down websocket connection: " + message), (Throwable)cause);
        this.closeQuietly();
    }

    public static interface JSPackagerCallback {
        public void onMessage(String var1, String var2);
    }
}

