/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.camera;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.graphics.BitmapFactory;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Environment;
import android.provider.MediaStore;
import android.text.TextUtils;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.GuardedAsyncTask;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.bridge.WritableNativeArray;
import com.facebook.react.bridge.WritableNativeMap;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import javax.annotation.Nullable;

public class CameraRollManager
extends ReactContextBaseJavaModule {
    private static final String ERROR_UNABLE_TO_LOAD = "E_UNABLE_TO_LOAD";
    private static final String ERROR_UNABLE_TO_LOAD_PERMISSION = "E_UNABLE_TO_LOAD_PERMISSION";
    private static final String ERROR_UNABLE_TO_SAVE = "E_UNABLE_TO_SAVE";
    public static final boolean IS_JELLY_BEAN_OR_LATER = Build.VERSION.SDK_INT >= 16;
    private static final String[] PROJECTION = IS_JELLY_BEAN_OR_LATER ? new String[]{"_id", "mime_type", "bucket_display_name", "datetaken", "width", "height", "longitude", "latitude"} : new String[]{"_id", "mime_type", "bucket_display_name", "datetaken", "longitude", "latitude"};
    private static final String SELECTION_BUCKET = "bucket_display_name = ?";
    private static final String SELECTION_DATE_TAKEN = "datetaken < ?";

    public CameraRollManager(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    @Override
    public String getName() {
        return "RKCameraRollManager";
    }

    @ReactMethod
    public void saveToCameraRoll(String uri, String type, Promise promise) {
        MediaType parsedType = type.equals("video") ? MediaType.VIDEO : MediaType.PHOTO;
        new SaveToCameraRoll(this.getReactApplicationContext(), Uri.parse((String)uri), parsedType, promise).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
    }

    @ReactMethod
    public void getPhotos(ReadableMap params, Promise promise) {
        ReadableArray mimeTypes;
        int first = params.getInt("first");
        String after = params.hasKey("after") ? params.getString("after") : null;
        String groupName = params.hasKey("groupName") ? params.getString("groupName") : null;
        ReadableArray readableArray = mimeTypes = params.hasKey("mimeTypes") ? params.getArray("mimeTypes") : null;
        if (params.hasKey("groupTypes")) {
            throw new JSApplicationIllegalArgumentException("groupTypes is not supported on Android");
        }
        new GetPhotosTask(this.getReactApplicationContext(), first, after, groupName, mimeTypes, promise).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
    }

    private static void putPageInfo(Cursor photos, WritableMap response, int limit) {
        WritableNativeMap pageInfo = new WritableNativeMap();
        pageInfo.putBoolean("has_next_page", limit < photos.getCount());
        if (limit < photos.getCount()) {
            photos.moveToPosition(limit - 1);
            pageInfo.putString("end_cursor", photos.getString(photos.getColumnIndex("datetaken")));
        }
        response.putMap("page_info", pageInfo);
    }

    private static void putEdges(ContentResolver resolver, Cursor photos, WritableMap response, int limit) {
        WritableNativeArray edges = new WritableNativeArray();
        photos.moveToFirst();
        int idIndex = photos.getColumnIndex("_id");
        int mimeTypeIndex = photos.getColumnIndex("mime_type");
        int groupNameIndex = photos.getColumnIndex("bucket_display_name");
        int dateTakenIndex = photos.getColumnIndex("datetaken");
        int widthIndex = IS_JELLY_BEAN_OR_LATER ? photos.getColumnIndex("width") : -1;
        int heightIndex = IS_JELLY_BEAN_OR_LATER ? photos.getColumnIndex("height") : -1;
        int longitudeIndex = photos.getColumnIndex("longitude");
        int latitudeIndex = photos.getColumnIndex("latitude");
        for (int i = 0; i < limit && !photos.isAfterLast(); ++i) {
            WritableNativeMap edge = new WritableNativeMap();
            WritableNativeMap node = new WritableNativeMap();
            boolean imageInfoSuccess = CameraRollManager.putImageInfo(resolver, photos, node, idIndex, widthIndex, heightIndex);
            if (imageInfoSuccess) {
                CameraRollManager.putBasicNodeInfo(photos, node, mimeTypeIndex, groupNameIndex, dateTakenIndex);
                CameraRollManager.putLocationInfo(photos, node, longitudeIndex, latitudeIndex);
                edge.putMap("node", node);
                edges.pushMap(edge);
            } else {
                --i;
            }
            photos.moveToNext();
        }
        response.putArray("edges", edges);
    }

    private static void putBasicNodeInfo(Cursor photos, WritableMap node, int mimeTypeIndex, int groupNameIndex, int dateTakenIndex) {
        node.putString("type", photos.getString(mimeTypeIndex));
        node.putString("group_name", photos.getString(groupNameIndex));
        node.putDouble("timestamp", (double)photos.getLong(dateTakenIndex) / 1000.0);
    }

    private static boolean putImageInfo(ContentResolver resolver, Cursor photos, WritableMap node, int idIndex, int widthIndex, int heightIndex) {
        WritableNativeMap image = new WritableNativeMap();
        Uri photoUri = Uri.withAppendedPath((Uri)MediaStore.Images.Media.EXTERNAL_CONTENT_URI, (String)photos.getString(idIndex));
        image.putString("uri", photoUri.toString());
        float width = -1.0f;
        float height = -1.0f;
        if (IS_JELLY_BEAN_OR_LATER) {
            width = photos.getInt(widthIndex);
            height = photos.getInt(heightIndex);
        }
        if (width <= 0.0f || height <= 0.0f) {
            try {
                AssetFileDescriptor photoDescriptor = resolver.openAssetFileDescriptor(photoUri, "r");
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inJustDecodeBounds = true;
                BitmapFactory.decodeFileDescriptor((FileDescriptor)photoDescriptor.getFileDescriptor(), null, (BitmapFactory.Options)options);
                photoDescriptor.close();
                width = options.outWidth;
                height = options.outHeight;
            }
            catch (IOException e) {
                FLog.e((String)"React", (String)("Could not get width/height for " + photoUri.toString()), (Throwable)e);
                return false;
            }
        }
        image.putDouble("width", width);
        image.putDouble("height", height);
        node.putMap("image", image);
        return true;
    }

    private static void putLocationInfo(Cursor photos, WritableMap node, int longitudeIndex, int latitudeIndex) {
        double longitude = photos.getDouble(longitudeIndex);
        double latitude = photos.getDouble(latitudeIndex);
        if (longitude > 0.0 || latitude > 0.0) {
            WritableNativeMap location = new WritableNativeMap();
            location.putDouble("longitude", longitude);
            location.putDouble("latitude", latitude);
            node.putMap("location", location);
        }
    }

    private static class GetPhotosTask
    extends GuardedAsyncTask<Void, Void> {
        private final Context mContext;
        private final int mFirst;
        @Nullable
        private final String mAfter;
        @Nullable
        private final String mGroupName;
        @Nullable
        private final ReadableArray mMimeTypes;
        private final Promise mPromise;

        private GetPhotosTask(ReactContext context, int first, @Nullable String after, @Nullable String groupName, @Nullable ReadableArray mimeTypes, Promise promise) {
            super(context);
            this.mContext = context;
            this.mFirst = first;
            this.mAfter = after;
            this.mGroupName = groupName;
            this.mMimeTypes = mimeTypes;
            this.mPromise = promise;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doInBackgroundGuarded(Void ... params) {
            block10: {
                StringBuilder selection = new StringBuilder("1");
                ArrayList<String> selectionArgs = new ArrayList<String>();
                if (!TextUtils.isEmpty((CharSequence)this.mAfter)) {
                    selection.append(" AND datetaken < ?");
                    selectionArgs.add(this.mAfter);
                }
                if (!TextUtils.isEmpty((CharSequence)this.mGroupName)) {
                    selection.append(" AND bucket_display_name = ?");
                    selectionArgs.add(this.mGroupName);
                }
                if (this.mMimeTypes != null && this.mMimeTypes.size() > 0) {
                    selection.append(" AND mime_type IN (");
                    for (int i = 0; i < this.mMimeTypes.size(); ++i) {
                        selection.append("?,");
                        selectionArgs.add(this.mMimeTypes.getString(i));
                    }
                    selection.replace(selection.length() - 1, selection.length(), ")");
                }
                WritableNativeMap response = new WritableNativeMap();
                ContentResolver resolver = this.mContext.getContentResolver();
                try {
                    Cursor photos = resolver.query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, PROJECTION, selection.toString(), selectionArgs.toArray(new String[selectionArgs.size()]), "datetaken DESC, date_modified DESC LIMIT " + (this.mFirst + 1));
                    if (photos == null) {
                        this.mPromise.reject(CameraRollManager.ERROR_UNABLE_TO_LOAD, "Could not get photos");
                        break block10;
                    }
                    try {
                        CameraRollManager.putEdges(resolver, photos, response, this.mFirst);
                        CameraRollManager.putPageInfo(photos, response, this.mFirst);
                    }
                    finally {
                        photos.close();
                        this.mPromise.resolve(response);
                    }
                }
                catch (SecurityException e) {
                    this.mPromise.reject(CameraRollManager.ERROR_UNABLE_TO_LOAD_PERMISSION, "Could not get photos: need READ_EXTERNAL_STORAGE permission", e);
                }
            }
        }
    }

    private static class SaveToCameraRoll
    extends GuardedAsyncTask<Void, Void> {
        private final Context mContext;
        private final Uri mUri;
        private final Promise mPromise;
        private final MediaType mType;

        public SaveToCameraRoll(ReactContext context, Uri uri, MediaType type, Promise promise) {
            super(context);
            this.mContext = context;
            this.mUri = uri;
            this.mPromise = promise;
            this.mType = type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doInBackgroundGuarded(Void ... params) {
            File source = new File(this.mUri.getPath());
            AbstractInterruptibleChannel input = null;
            AbstractInterruptibleChannel output = null;
            try {
                String sourceExt;
                String sourceName;
                File exportDir = this.mType == MediaType.PHOTO ? Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES) : Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_MOVIES);
                exportDir.mkdirs();
                if (!exportDir.isDirectory()) {
                    this.mPromise.reject(CameraRollManager.ERROR_UNABLE_TO_LOAD, "External media storage directory not available");
                    return;
                }
                File dest = new File(exportDir, source.getName());
                int n = 0;
                String fullSourceName = source.getName();
                if (fullSourceName.indexOf(46) >= 0) {
                    sourceName = fullSourceName.substring(0, fullSourceName.lastIndexOf(46));
                    sourceExt = fullSourceName.substring(fullSourceName.lastIndexOf(46));
                } else {
                    sourceName = fullSourceName;
                    sourceExt = "";
                }
                while (!dest.createNewFile()) {
                    dest = new File(exportDir, sourceName + "_" + n++ + sourceExt);
                }
                input = new FileInputStream(source).getChannel();
                output = new FileOutputStream(dest).getChannel();
                ((FileChannel)output).transferFrom((ReadableByteChannel)((Object)input), 0L, ((FileChannel)input).size());
                input.close();
                output.close();
                MediaScannerConnection.scanFile((Context)this.mContext, (String[])new String[]{dest.getAbsolutePath()}, null, (MediaScannerConnection.OnScanCompletedListener)new MediaScannerConnection.OnScanCompletedListener(){

                    public void onScanCompleted(String path, Uri uri) {
                        if (uri != null) {
                            SaveToCameraRoll.this.mPromise.resolve(uri.toString());
                        } else {
                            SaveToCameraRoll.this.mPromise.reject(CameraRollManager.ERROR_UNABLE_TO_SAVE, "Could not add image to gallery");
                        }
                    }
                });
            }
            catch (IOException e) {
                this.mPromise.reject(e);
            }
            finally {
                if (input != null && input.isOpen()) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        FLog.e((String)"React", (String)"Could not close input channel", (Throwable)e);
                    }
                }
                if (output != null && output.isOpen()) {
                    try {
                        output.close();
                    }
                    catch (IOException e) {
                        FLog.e((String)"React", (String)"Could not close output channel", (Throwable)e);
                    }
                }
            }
        }
    }

    private static enum MediaType {
        PHOTO,
        VIDEO;

    }
}

