/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.i18nmanager;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.v4.text.TextUtilsCompat;
import java.util.Locale;

public class I18nUtil {
    private static I18nUtil sharedI18nUtilInstance = null;
    private static final String SHARED_PREFS_NAME = "com.facebook.react.modules.i18nmanager.I18nUtil";
    private static final String KEY_FOR_PREFS_ALLOWRTL = "RCTI18nUtil_allowRTL";
    private static final String KEY_FOR_PREFS_FORCERTL = "RCTI18nUtil_forceRTL";

    private I18nUtil() {
    }

    public static I18nUtil getInstance() {
        if (sharedI18nUtilInstance == null) {
            sharedI18nUtilInstance = new I18nUtil();
        }
        return sharedI18nUtilInstance;
    }

    public boolean isRTL(Context context) {
        if (this.isRTLForced(context)) {
            return true;
        }
        return this.isRTLAllowed(context) && this.isDevicePreferredLanguageRTL();
    }

    private boolean isRTLAllowed(Context context) {
        return this.isPrefSet(context, KEY_FOR_PREFS_ALLOWRTL, false);
    }

    public void allowRTL(Context context, boolean allowRTL) {
        this.setPref(context, KEY_FOR_PREFS_ALLOWRTL, allowRTL);
    }

    private boolean isRTLForced(Context context) {
        return this.isPrefSet(context, KEY_FOR_PREFS_FORCERTL, false);
    }

    public void forceRTL(Context context, boolean forceRTL) {
        this.setPref(context, KEY_FOR_PREFS_FORCERTL, forceRTL);
    }

    private boolean isDevicePreferredLanguageRTL() {
        int directionality = TextUtilsCompat.getLayoutDirectionFromLocale((Locale)Locale.getDefault());
        return directionality == 1;
    }

    private boolean isPrefSet(Context context, String key, boolean defaultValue) {
        SharedPreferences prefs = context.getSharedPreferences(SHARED_PREFS_NAME, 0);
        return prefs.getBoolean(key, defaultValue);
    }

    private void setPref(Context context, String key, boolean value) {
        SharedPreferences.Editor editor = context.getSharedPreferences(SHARED_PREFS_NAME, 0).edit();
        editor.putBoolean(key, value);
        editor.apply();
    }
}

