/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.network;

import com.facebook.react.modules.network.ProgressListener;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.ForwardingSink;
import okio.Okio;
import okio.Sink;

public class ProgressRequestBody
extends RequestBody {
    private final RequestBody mRequestBody;
    private final ProgressListener mProgressListener;
    private BufferedSink mBufferedSink;

    public ProgressRequestBody(RequestBody requestBody, ProgressListener progressListener) {
        this.mRequestBody = requestBody;
        this.mProgressListener = progressListener;
    }

    public MediaType contentType() {
        return this.mRequestBody.contentType();
    }

    public long contentLength() throws IOException {
        return this.mRequestBody.contentLength();
    }

    public void writeTo(BufferedSink sink) throws IOException {
        if (this.mBufferedSink == null) {
            this.mBufferedSink = Okio.buffer((Sink)this.sink((Sink)sink));
        }
        this.mRequestBody.writeTo(this.mBufferedSink);
        this.mBufferedSink.flush();
    }

    private Sink sink(Sink sink) {
        return new ForwardingSink(sink){
            long bytesWritten;
            long contentLength;
            {
                this.bytesWritten = 0L;
                this.contentLength = 0L;
            }

            public void write(Buffer source, long byteCount) throws IOException {
                super.write(source, byteCount);
                if (this.contentLength == 0L) {
                    this.contentLength = ProgressRequestBody.this.contentLength();
                }
                this.bytesWritten += byteCount;
                ProgressRequestBody.this.mProgressListener.onProgress(this.bytesWritten, this.contentLength, this.bytesWritten == this.contentLength);
            }
        };
    }
}

