/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.permissions;

import android.app.Activity;
import android.os.Build;
import android.os.Process;
import android.util.SparseArray;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.modules.core.PermissionAwareActivity;
import com.facebook.react.modules.core.PermissionListener;

public class PermissionsModule
extends ReactContextBaseJavaModule
implements PermissionListener {
    private final SparseArray<Callback> mCallbacks = new SparseArray();
    private int mRequestCode = 0;

    public PermissionsModule(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    @Override
    public String getName() {
        return "PermissionsAndroid";
    }

    @ReactMethod
    public void checkPermission(String permission, Promise promise) {
        PermissionAwareActivity activity = this.getPermissionAwareActivity();
        if (Build.VERSION.SDK_INT < 23) {
            promise.resolve(activity.checkPermission(permission, Process.myPid(), Process.myUid()) == 0);
            return;
        }
        promise.resolve(activity.checkSelfPermission(permission) == 0);
    }

    @ReactMethod
    public void shouldShowRequestPermissionRationale(String permission, Promise promise) {
        if (Build.VERSION.SDK_INT < 23) {
            promise.resolve(false);
            return;
        }
        promise.resolve(this.getPermissionAwareActivity().shouldShowRequestPermissionRationale(permission));
    }

    @ReactMethod
    public void requestPermission(String permission, final Promise promise) {
        PermissionAwareActivity activity = this.getPermissionAwareActivity();
        if (Build.VERSION.SDK_INT < 23) {
            promise.resolve(activity.checkPermission(permission, Process.myPid(), Process.myUid()) == 0);
            return;
        }
        if (activity.checkSelfPermission(permission) == 0) {
            promise.resolve(true);
            return;
        }
        this.mCallbacks.put(this.mRequestCode, (Object)new Callback(){

            @Override
            public void invoke(Object ... args) {
                promise.resolve(args[0].equals(0));
            }
        });
        activity.requestPermissions(new String[]{permission}, this.mRequestCode, this);
        ++this.mRequestCode;
    }

    @Override
    public boolean onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        ((Callback)this.mCallbacks.get(requestCode)).invoke(grantResults[0]);
        this.mCallbacks.remove(requestCode);
        return this.mCallbacks.size() == 0;
    }

    private PermissionAwareActivity getPermissionAwareActivity() {
        Activity activity = this.getCurrentActivity();
        if (activity == null) {
            throw new IllegalStateException("Tried to use permissions API while not attached to an Activity.");
        }
        if (!(activity instanceof PermissionAwareActivity)) {
            throw new IllegalStateException("Tried to use permissions API but the host Activity doesn't implement PermissionAwareActivity.");
        }
        return (PermissionAwareActivity)activity;
    }
}

